/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.APersistentVector;
import clojure.lang.ASeq;
import clojure.lang.ArrayChunk;
import clojure.lang.ArrayIter;
import clojure.lang.ArraySeq;
import clojure.lang.Associative;
import clojure.lang.BigInt;
import clojure.lang.ChunkedCons;
import clojure.lang.Compiler;
import clojure.lang.Cons;
import clojure.lang.Counted;
import clojure.lang.DynamicClassLoader;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LazySeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.MapEntry;
import clojure.lang.Namespace;
import clojure.lang.Obj;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Ratio;
import clojure.lang.Reduced;
import clojure.lang.Reflector;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.StringSeq;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RT {
    public static final Boolean T = Boolean.TRUE;
    public static final Boolean F = Boolean.FALSE;
    public static final String LOADER_SUFFIX = "__init";
    static final IPersistentMap DEFAULT_IMPORTS = RT.map(Symbol.intern("Boolean"), Boolean.class, Symbol.intern("Byte"), Byte.class, Symbol.intern("Character"), Character.class, Symbol.intern("Class"), Class.class, Symbol.intern("ClassLoader"), ClassLoader.class, Symbol.intern("Compiler"), Compiler.class, Symbol.intern("Double"), Double.class, Symbol.intern("Enum"), Enum.class, Symbol.intern("Float"), Float.class, Symbol.intern("InheritableThreadLocal"), InheritableThreadLocal.class, Symbol.intern("Integer"), Integer.class, Symbol.intern("Long"), Long.class, Symbol.intern("Math"), Math.class, Symbol.intern("Number"), Number.class, Symbol.intern("Object"), Object.class, Symbol.intern("Package"), Package.class, Symbol.intern("Process"), Process.class, Symbol.intern("ProcessBuilder"), ProcessBuilder.class, Symbol.intern("Runtime"), Runtime.class, Symbol.intern("RuntimePermission"), RuntimePermission.class, Symbol.intern("SecurityManager"), SecurityManager.class, Symbol.intern("Short"), Short.class, Symbol.intern("StackTraceElement"), StackTraceElement.class, Symbol.intern("StrictMath"), StrictMath.class, Symbol.intern("String"), String.class, Symbol.intern("StringBuffer"), StringBuffer.class, Symbol.intern("StringBuilder"), StringBuilder.class, Symbol.intern("System"), System.class, Symbol.intern("Thread"), Thread.class, Symbol.intern("ThreadGroup"), ThreadGroup.class, Symbol.intern("ThreadLocal"), ThreadLocal.class, Symbol.intern("Throwable"), Throwable.class, Symbol.intern("Void"), Void.class, Symbol.intern("Appendable"), Appendable.class, Symbol.intern("CharSequence"), CharSequence.class, Symbol.intern("Cloneable"), Cloneable.class, Symbol.intern("Comparable"), Comparable.class, Symbol.intern("Iterable"), Iterable.class, Symbol.intern("Readable"), Readable.class, Symbol.intern("Runnable"), Runnable.class, Symbol.intern("Callable"), Callable.class, Symbol.intern("BigInteger"), BigInteger.class, Symbol.intern("BigDecimal"), BigDecimal.class, Symbol.intern("ArithmeticException"), ArithmeticException.class, Symbol.intern("ArrayIndexOutOfBoundsException"), ArrayIndexOutOfBoundsException.class, Symbol.intern("ArrayStoreException"), ArrayStoreException.class, Symbol.intern("ClassCastException"), ClassCastException.class, Symbol.intern("ClassNotFoundException"), ClassNotFoundException.class, Symbol.intern("CloneNotSupportedException"), CloneNotSupportedException.class, Symbol.intern("EnumConstantNotPresentException"), EnumConstantNotPresentException.class, Symbol.intern("Exception"), Exception.class, Symbol.intern("IllegalAccessException"), IllegalAccessException.class, Symbol.intern("IllegalArgumentException"), IllegalArgumentException.class, Symbol.intern("IllegalMonitorStateException"), IllegalMonitorStateException.class, Symbol.intern("IllegalStateException"), IllegalStateException.class, Symbol.intern("IllegalThreadStateException"), IllegalThreadStateException.class, Symbol.intern("IndexOutOfBoundsException"), IndexOutOfBoundsException.class, Symbol.intern("InstantiationException"), InstantiationException.class, Symbol.intern("InterruptedException"), InterruptedException.class, Symbol.intern("NegativeArraySizeException"), NegativeArraySizeException.class, Symbol.intern("NoSuchFieldException"), NoSuchFieldException.class, Symbol.intern("NoSuchMethodException"), NoSuchMethodException.class, Symbol.intern("NullPointerException"), NullPointerException.class, Symbol.intern("NumberFormatException"), NumberFormatException.class, Symbol.intern("RuntimeException"), RuntimeException.class, Symbol.intern("SecurityException"), SecurityException.class, Symbol.intern("StringIndexOutOfBoundsException"), StringIndexOutOfBoundsException.class, Symbol.intern("TypeNotPresentException"), TypeNotPresentException.class, Symbol.intern("UnsupportedOperationException"), UnsupportedOperationException.class, Symbol.intern("AbstractMethodError"), AbstractMethodError.class, Symbol.intern("AssertionError"), AssertionError.class, Symbol.intern("ClassCircularityError"), ClassCircularityError.class, Symbol.intern("ClassFormatError"), ClassFormatError.class, Symbol.intern("Error"), Error.class, Symbol.intern("ExceptionInInitializerError"), ExceptionInInitializerError.class, Symbol.intern("IllegalAccessError"), IllegalAccessError.class, Symbol.intern("IncompatibleClassChangeError"), IncompatibleClassChangeError.class, Symbol.intern("InstantiationError"), InstantiationError.class, Symbol.intern("InternalError"), InternalError.class, Symbol.intern("LinkageError"), LinkageError.class, Symbol.intern("NoClassDefFoundError"), NoClassDefFoundError.class, Symbol.intern("NoSuchFieldError"), NoSuchFieldError.class, Symbol.intern("NoSuchMethodError"), NoSuchMethodError.class, Symbol.intern("OutOfMemoryError"), OutOfMemoryError.class, Symbol.intern("StackOverflowError"), StackOverflowError.class, Symbol.intern("ThreadDeath"), ThreadDeath.class, Symbol.intern("UnknownError"), UnknownError.class, Symbol.intern("UnsatisfiedLinkError"), UnsatisfiedLinkError.class, Symbol.intern("UnsupportedClassVersionError"), UnsupportedClassVersionError.class, Symbol.intern("VerifyError"), VerifyError.class, Symbol.intern("VirtualMachineError"), VirtualMachineError.class, Symbol.intern("Thread$UncaughtExceptionHandler"), Thread.UncaughtExceptionHandler.class, Symbol.intern("Thread$State"), Thread.State.class, Symbol.intern("Deprecated"), Deprecated.class, Symbol.intern("Override"), Override.class, Symbol.intern("SuppressWarnings"), SuppressWarnings.class);
    public static Charset UTF8 = Charset.forName("UTF-8");
    public static final Namespace CLOJURE_NS = Namespace.createCore();
    public static final Var OUT = Var.intern(CLOJURE_NS, Symbol.intern("*out*"), new OutputStreamWriter(System.out)).setDynamic();
    public static final Var IN = Var.intern(CLOJURE_NS, Symbol.intern("*in*"), new LineNumberingPushbackReader(new InputStreamReader(System.in))).setDynamic();
    public static final Var ERR = Var.intern(CLOJURE_NS, Symbol.intern("*err*"), new PrintWriter((Writer)new OutputStreamWriter(System.err), true)).setDynamic();
    static final Keyword TAG_KEY = Keyword.intern(null, "tag");
    static final Keyword CONST_KEY = Keyword.intern(null, "const");
    public static final Var AGENT = Var.intern(CLOJURE_NS, Symbol.intern("*agent*"), null).setDynamic();
    static Object readeval = RT.readTrueFalseUnknown(System.getProperty("clojure.read.eval", "true"));
    public static final Var READEVAL = Var.intern(CLOJURE_NS, Symbol.intern("*read-eval*"), readeval).setDynamic();
    public static final Var DATA_READERS = Var.intern(CLOJURE_NS, Symbol.intern("*data-readers*"), RT.map(new Object[0])).setDynamic();
    public static final Var DEFAULT_DATA_READER_FN = Var.intern(CLOJURE_NS, Symbol.intern("*default-data-reader-fn*"), RT.map(new Object[0])).setDynamic();
    public static final Var DEFAULT_DATA_READERS = Var.intern(CLOJURE_NS, Symbol.intern("default-data-readers"), RT.map(new Object[0]));
    public static final Var SUPPRESS_READ = Var.intern(CLOJURE_NS, Symbol.intern("*suppress-read*"), null).setDynamic();
    public static final Var ASSERT = Var.intern(CLOJURE_NS, Symbol.intern("*assert*"), T).setDynamic();
    public static final Var MATH_CONTEXT = Var.intern(CLOJURE_NS, Symbol.intern("*math-context*"), null).setDynamic();
    static Keyword LINE_KEY = Keyword.intern(null, "line");
    static Keyword COLUMN_KEY = Keyword.intern(null, "column");
    static Keyword FILE_KEY = Keyword.intern(null, "file");
    static Keyword DECLARED_KEY = Keyword.intern(null, "declared");
    static Keyword DOC_KEY = Keyword.intern(null, "doc");
    public static final Var USE_CONTEXT_CLASSLOADER = Var.intern(CLOJURE_NS, Symbol.intern("*use-context-classloader*"), T).setDynamic();
    public static final Var UNCHECKED_MATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*unchecked-math*"), Boolean.FALSE).setDynamic();
    static final Symbol LOAD_FILE = Symbol.intern("load-file");
    static final Symbol IN_NAMESPACE = Symbol.intern("in-ns");
    static final Symbol NAMESPACE = Symbol.intern("ns");
    static final Symbol IDENTICAL = Symbol.intern("identical?");
    static final Var CMD_LINE_ARGS = Var.intern(CLOJURE_NS, Symbol.intern("*command-line-args*"), null).setDynamic();
    public static final Var CURRENT_NS = Var.intern(CLOJURE_NS, Symbol.intern("*ns*"), CLOJURE_NS).setDynamic();
    static final Var FLUSH_ON_NEWLINE = Var.intern(CLOJURE_NS, Symbol.intern("*flush-on-newline*"), T).setDynamic();
    static final Var PRINT_META = Var.intern(CLOJURE_NS, Symbol.intern("*print-meta*"), F).setDynamic();
    static final Var PRINT_READABLY = Var.intern(CLOJURE_NS, Symbol.intern("*print-readably*"), T).setDynamic();
    static final Var PRINT_DUP = Var.intern(CLOJURE_NS, Symbol.intern("*print-dup*"), F).setDynamic();
    static final Var WARN_ON_REFLECTION = Var.intern(CLOJURE_NS, Symbol.intern("*warn-on-reflection*"), F).setDynamic();
    static final Var ALLOW_UNRESOLVED_VARS = Var.intern(CLOJURE_NS, Symbol.intern("*allow-unresolved-vars*"), F).setDynamic();
    static final Var IN_NS_VAR = Var.intern(CLOJURE_NS, Symbol.intern("in-ns"), F);
    static final Var NS_VAR = Var.intern(CLOJURE_NS, Symbol.intern("ns"), F);
    static final Var FN_LOADER_VAR = Var.intern(CLOJURE_NS, Symbol.intern("*fn-loader*"), null).setDynamic();
    static final Var PRINT_INITIALIZED = Var.intern(CLOJURE_NS, Symbol.intern("print-initialized"));
    static final Var PR_ON = Var.intern(CLOJURE_NS, Symbol.intern("pr-on"));
    static final IFn inNamespace = new AFn(){

        @Override
        public Object invoke(Object arg1) {
            Symbol nsname = (Symbol)arg1;
            Namespace ns2 = Namespace.findOrCreate(nsname);
            CURRENT_NS.set(ns2);
            return ns2;
        }
    };
    static final IFn bootNamespace = new AFn(){

        @Override
        public Object invoke(Object __form, Object __env, Object arg1) {
            Symbol nsname = (Symbol)arg1;
            Namespace ns2 = Namespace.findOrCreate(nsname);
            CURRENT_NS.set(ns2);
            return ns2;
        }
    };
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Comparator DEFAULT_COMPARATOR = new DefaultComparator();
    static AtomicInteger id = new AtomicInteger(1);
    private static final int CHUNK_SIZE = 32;

    static Object readTrueFalseUnknown(String s) {
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        return Keyword.intern(null, "unknown");
    }

    public static List<String> processCommandLine(String[] args) {
        List<String> arglist = Arrays.asList(args);
        int split2 = arglist.indexOf("--");
        if (split2 >= 0) {
            CMD_LINE_ARGS.bindRoot(RT.seq(arglist.subList(split2 + 1, args.length)));
            return arglist.subList(0, split2);
        }
        return arglist;
    }

    public static PrintWriter errPrintWriter() {
        Writer w = (Writer)ERR.deref();
        if (w instanceof PrintWriter) {
            return (PrintWriter)w;
        }
        return new PrintWriter(w);
    }

    public static void addURL(Object url) throws MalformedURLException {
        URL u = url instanceof String ? new URL((String)url) : (URL)url;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (!(ccl instanceof DynamicClassLoader)) {
            throw new IllegalAccessError("Context classloader is not a DynamicClassLoader");
        }
        ((DynamicClassLoader)ccl).addURL(u);
    }

    public static Keyword keyword(String ns2, String name2) {
        return Keyword.intern(Symbol.intern(ns2, name2));
    }

    public static Var var(String ns2, String name2) {
        return Var.intern(Namespace.findOrCreate(Symbol.intern(null, ns2)), Symbol.intern(null, name2));
    }

    public static Var var(String ns2, String name2, Object init) {
        return Var.intern(Namespace.findOrCreate(Symbol.intern(null, ns2)), Symbol.intern(null, name2), init);
    }

    public static void loadResourceScript(String name2) throws IOException {
        RT.loadResourceScript(name2, true);
    }

    public static void maybeLoadResourceScript(String name2) throws IOException {
        RT.loadResourceScript(name2, false);
    }

    public static void loadResourceScript(String name2, boolean failIfNotFound) throws IOException {
        RT.loadResourceScript(RT.class, name2, failIfNotFound);
    }

    public static void loadResourceScript(Class c, String name2) throws IOException {
        RT.loadResourceScript(c, name2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResourceScript(Class c, String name2, boolean failIfNotFound) throws IOException {
        int slash = name2.lastIndexOf(47);
        String file2 = slash >= 0 ? name2.substring(slash + 1) : name2;
        InputStream ins = RT.resourceAsStream(RT.baseLoader(), name2);
        if (ins != null) {
            try {
                Compiler.load(new InputStreamReader(ins, UTF8), name2, file2);
            }
            finally {
                ins.close();
            }
        } else if (failIfNotFound) {
            throw new FileNotFoundException("Could not locate Clojure resource on classpath: " + name2);
        }
    }

    public static void init() {
        RT.errPrintWriter().println("No need to call RT.init() anymore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastModified(URL url, String libfile) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            if (url.getProtocol().equals("jar")) {
                long l = ((JarURLConnection)connection).getJarFile().getEntry(libfile).getTime();
                return l;
            }
            long l = connection.getLastModified();
            return l;
        }
        finally {
            InputStream ins = connection.getInputStream();
            if (ins != null) {
                ins.close();
            }
        }
    }

    static void compile(String cljfile) throws IOException {
        InputStream ins = RT.resourceAsStream(RT.baseLoader(), cljfile);
        if (ins != null) {
            try {
                Compiler.compile(new InputStreamReader(ins, UTF8), cljfile, cljfile.substring(1 + cljfile.lastIndexOf("/")));
            }
            finally {
                ins.close();
            }
        } else {
            throw new FileNotFoundException("Could not locate Clojure resource on classpath: " + cljfile);
        }
    }

    public static void load(String scriptbase) throws IOException, ClassNotFoundException {
        RT.load(scriptbase, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String scriptbase, boolean failIfNotFound) throws IOException, ClassNotFoundException {
        String cljfile;
        String classfile = scriptbase + LOADER_SUFFIX + ".class";
        String scriptfile = cljfile = scriptbase + ".clj";
        URL classURL = RT.getResource(RT.baseLoader(), classfile);
        URL cljURL = RT.getResource(RT.baseLoader(), scriptfile);
        if (cljURL == null) {
            scriptfile = scriptbase + ".cljc";
            cljURL = RT.getResource(RT.baseLoader(), scriptfile);
        }
        boolean loaded = false;
        if (classURL != null && (cljURL == null || RT.lastModified(classURL, classfile) > RT.lastModified(cljURL, scriptfile)) || classURL == null) {
            try {
                Var.pushThreadBindings(RT.mapUniqueKeys(CURRENT_NS, CURRENT_NS.deref(), WARN_ON_REFLECTION, WARN_ON_REFLECTION.deref(), UNCHECKED_MATH, UNCHECKED_MATH.deref()));
                loaded = RT.loadClassForName(scriptbase.replace('/', '.') + LOADER_SUFFIX) != null;
            }
            finally {
                Var.popThreadBindings();
            }
        }
        if (!loaded && cljURL != null) {
            if (RT.booleanCast(Compiler.COMPILE_FILES.deref())) {
                RT.compile(scriptfile);
            } else {
                RT.loadResourceScript(RT.class, scriptfile);
            }
        } else if (!loaded && failIfNotFound) {
            throw new FileNotFoundException(String.format("Could not locate %s or %s on classpath.%s", classfile, cljfile, scriptbase.contains("_") ? " Please check that namespaces with dashes use underscores in the Clojure file name." : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doInit() throws ClassNotFoundException, IOException {
        RT.load("clojure/core");
        Var.pushThreadBindings(RT.mapUniqueKeys(CURRENT_NS, CURRENT_NS.deref(), WARN_ON_REFLECTION, WARN_ON_REFLECTION.deref(), UNCHECKED_MATH, UNCHECKED_MATH.deref()));
        try {
            Symbol USER = Symbol.intern("user");
            Symbol CLOJURE = Symbol.intern("clojure.core");
            Var in_ns = RT.var("clojure.core", "in-ns");
            Var refer2 = RT.var("clojure.core", "refer");
            in_ns.invoke(USER);
            refer2.invoke(CLOJURE);
            RT.maybeLoadResourceScript("user.clj");
            Var require2 = RT.var("clojure.core", "require");
            Symbol SERVER = Symbol.intern("clojure.core.server");
            require2.invoke(SERVER);
            Var start_servers2 = RT.var("clojure.core.server", "start-servers");
            start_servers2.invoke(System.getProperties());
        }
        finally {
            Var.popThreadBindings();
        }
    }

    public static int nextID() {
        return id.getAndIncrement();
    }

    public static void loadLibrary(String libname) {
        System.loadLibrary(libname);
    }

    public static ISeq chunkIteratorSeq(final Iterator iter) {
        if (iter.hasNext()) {
            return new LazySeq(new AFn(){

                @Override
                public Object invoke() {
                    Object[] arr = new Object[32];
                    int n = 0;
                    while (iter.hasNext() && n < 32) {
                        arr[n++] = iter.next();
                    }
                    return new ChunkedCons(new ArrayChunk(arr, 0, n), RT.chunkIteratorSeq(iter));
                }
            });
        }
        return null;
    }

    public static ISeq seq(Object coll) {
        if (coll instanceof ASeq) {
            return (ASeq)coll;
        }
        if (coll instanceof LazySeq) {
            return ((LazySeq)coll).seq();
        }
        return RT.seqFrom(coll);
    }

    static ISeq seqFrom(Object coll) {
        if (coll instanceof Seqable) {
            return ((Seqable)coll).seq();
        }
        if (coll == null) {
            return null;
        }
        if (coll instanceof Iterable) {
            return RT.chunkIteratorSeq(((Iterable)coll).iterator());
        }
        if (coll.getClass().isArray()) {
            return ArraySeq.createFromObject(coll);
        }
        if (coll instanceof CharSequence) {
            return StringSeq.create((CharSequence)coll);
        }
        if (coll instanceof Map) {
            return RT.seq(((Map)coll).entrySet());
        }
        Class<?> c = coll.getClass();
        Class<?> sc = c.getSuperclass();
        throw new IllegalArgumentException("Don't know how to create ISeq from: " + c.getName());
    }

    public static Iterator iter(Object coll) {
        if (coll instanceof Iterable) {
            return ((Iterable)coll).iterator();
        }
        if (coll == null) {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (coll instanceof Map) {
            return ((Map)coll).entrySet().iterator();
        }
        if (coll instanceof String) {
            final String s = (String)coll;
            return new Iterator(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < s.length();
                }

                public Object next() {
                    return Character.valueOf(s.charAt(this.i++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (coll.getClass().isArray()) {
            return ArrayIter.createFromObject(coll);
        }
        return RT.iter(RT.seq(coll));
    }

    public static Object seqOrElse(Object o) {
        return RT.seq(o) == null ? null : o;
    }

    public static ISeq keys(Object coll) {
        if (coll instanceof IPersistentMap) {
            return APersistentMap.KeySeq.createFromMap((IPersistentMap)coll);
        }
        return APersistentMap.KeySeq.create(RT.seq(coll));
    }

    public static ISeq vals(Object coll) {
        if (coll instanceof IPersistentMap) {
            return APersistentMap.ValSeq.createFromMap((IPersistentMap)coll);
        }
        return APersistentMap.ValSeq.create(RT.seq(coll));
    }

    public static IPersistentMap meta(Object x) {
        if (x instanceof IMeta) {
            return ((IMeta)x).meta();
        }
        return null;
    }

    public static int count(Object o) {
        if (o instanceof Counted) {
            return ((Counted)o).count();
        }
        Object object = o;
        o = null;
        return RT.countFrom(Util.ret1(object, null));
    }

    static int countFrom(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof IPersistentCollection) {
            ISeq s = RT.seq(o);
            o = null;
            int i = 0;
            while (s != null) {
                if (s instanceof Counted) {
                    return i + s.count();
                }
                ++i;
                s = s.next();
            }
            return i;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o instanceof Map.Entry) {
            return 2;
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("count not supported on this type: " + o.getClass().getSimpleName());
    }

    public static IPersistentCollection conj(IPersistentCollection coll, Object x) {
        if (coll == null) {
            return new PersistentList(x);
        }
        return coll.cons(x);
    }

    public static ISeq cons(Object x, Object coll) {
        if (coll == null) {
            return new PersistentList(x);
        }
        if (coll instanceof ISeq) {
            return new Cons(x, (ISeq)coll);
        }
        return new Cons(x, RT.seq(coll));
    }

    public static Object first(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).first();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.first();
    }

    public static Object second(Object x) {
        return RT.first(RT.next(x));
    }

    public static Object third(Object x) {
        return RT.first(RT.next(RT.next(x)));
    }

    public static Object fourth(Object x) {
        return RT.first(RT.next(RT.next(RT.next(x))));
    }

    public static ISeq next(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).next();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.next();
    }

    public static ISeq more(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).more();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return PersistentList.EMPTY;
        }
        return seq.more();
    }

    public static Object peek(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).peek();
    }

    public static Object pop(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).pop();
    }

    public static Object get(Object coll, Object key2) {
        if (coll instanceof ILookup) {
            return ((ILookup)coll).valAt(key2);
        }
        return RT.getFrom(coll, key2);
    }

    static Object getFrom(Object coll, Object key2) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.get(key2);
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set2 = (IPersistentSet)coll;
            return set2.get(key2);
        }
        if (key2 instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key2).intValue();
            if (n >= 0 && n < RT.count(coll)) {
                return RT.nth(coll, n);
            }
            return null;
        }
        return null;
    }

    public static Object get(Object coll, Object key2, Object notFound) {
        if (coll instanceof ILookup) {
            return ((ILookup)coll).valAt(key2, notFound);
        }
        return RT.getFrom(coll, key2, notFound);
    }

    static Object getFrom(Object coll, Object key2, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            if (m.containsKey(key2)) {
                return m.get(key2);
            }
            return notFound;
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set2 = (IPersistentSet)coll;
            if (set2.contains(key2)) {
                return set2.get(key2);
            }
            return notFound;
        }
        if (key2 instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key2).intValue();
            return n >= 0 && n < RT.count(coll) ? RT.nth(coll, n) : notFound;
        }
        return notFound;
    }

    public static Associative assoc(Object coll, Object key2, Object val2) {
        if (coll == null) {
            return new PersistentArrayMap(new Object[]{key2, val2});
        }
        return ((Associative)coll).assoc(key2, val2);
    }

    public static Object contains(Object coll, Object key2) {
        if (coll == null) {
            return F;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).containsKey(key2) ? T : F;
        }
        if (coll instanceof IPersistentSet) {
            return ((IPersistentSet)coll).contains(key2) ? T : F;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.containsKey(key2) ? T : F;
        }
        if (coll instanceof Set) {
            Set s = (Set)coll;
            return s.contains(key2) ? T : F;
        }
        if (key2 instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key2).intValue();
            return n >= 0 && n < RT.count(coll);
        }
        throw new IllegalArgumentException("contains? not supported on type: " + coll.getClass().getName());
    }

    public static Object find(Object coll, Object key2) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).entryAt(key2);
        }
        Map m = (Map)coll;
        if (m.containsKey(key2)) {
            return MapEntry.create(key2, m.get(key2));
        }
        return null;
    }

    public static ISeq findKey(Keyword key2, ISeq keyvals) {
        while (keyvals != null) {
            ISeq r = keyvals.next();
            if (r == null) {
                throw Util.runtimeException("Malformed keyword argslist");
            }
            if (keyvals.first() == key2) {
                return r;
            }
            keyvals = r.next();
        }
        return null;
    }

    public static Object dissoc(Object coll, Object key2) {
        if (coll == null) {
            return null;
        }
        return ((IPersistentMap)coll).without(key2);
    }

    public static Object nth(Object coll, int n) {
        if (coll instanceof Indexed) {
            return ((Indexed)coll).nth(n);
        }
        Object object = coll;
        coll = null;
        return RT.nthFrom(Util.ret1(object, null), n);
    }

    static Object nthFrom(Object coll, int n) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof CharSequence) {
            return Character.valueOf(((CharSequence)coll).charAt(n));
        }
        if (coll.getClass().isArray()) {
            return Reflector.prepRet(coll.getClass().getComponentType(), Array.get(coll, n));
        }
        if (coll instanceof RandomAccess) {
            return ((List)coll).get(n);
        }
        if (coll instanceof Matcher) {
            return ((Matcher)coll).group(n);
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e2 = (Map.Entry)coll;
            if (n == 0) {
                return e2.getKey();
            }
            if (n == 1) {
                return e2.getValue();
            }
            throw new IndexOutOfBoundsException();
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            throw new IndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object nth(Object coll, int n, Object notFound) {
        if (coll instanceof Indexed) {
            Indexed v = (Indexed)coll;
            return v.nth(n, notFound);
        }
        return RT.nthFrom(coll, n, notFound);
    }

    static Object nthFrom(Object coll, int n, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (n < 0) {
            return notFound;
        }
        if (coll instanceof CharSequence) {
            CharSequence s = (CharSequence)coll;
            if (n < s.length()) {
                return Character.valueOf(s.charAt(n));
            }
            return notFound;
        }
        if (coll.getClass().isArray()) {
            if (n < Array.getLength(coll)) {
                return Reflector.prepRet(coll.getClass().getComponentType(), Array.get(coll, n));
            }
            return notFound;
        }
        if (coll instanceof RandomAccess) {
            List list = (List)coll;
            if (n < list.size()) {
                return list.get(n);
            }
            return notFound;
        }
        if (coll instanceof Matcher) {
            Matcher m = (Matcher)coll;
            if (n < m.groupCount()) {
                return m.group(n);
            }
            return notFound;
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e2 = (Map.Entry)coll;
            if (n == 0) {
                return e2.getKey();
            }
            if (n == 1) {
                return e2.getValue();
            }
            return notFound;
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            return notFound;
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object assocN(int n, Object val2, Object coll) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof IPersistentVector) {
            return ((IPersistentVector)coll).assocN(n, val2);
        }
        if (coll instanceof Object[]) {
            Object[] array2 = (Object[])coll;
            array2[n] = val2;
            return array2;
        }
        return null;
    }

    static boolean hasTag(Object o, Object tag) {
        return Util.equals(tag, RT.get(RT.meta(o), TAG_KEY));
    }

    public static Object box(Object x) {
        return x;
    }

    public static Character box(char x) {
        return Character.valueOf(x);
    }

    public static Object box(boolean x) {
        return x ? T : F;
    }

    public static Object box(Boolean x) {
        return x;
    }

    public static Number box(byte x) {
        return x;
    }

    public static Number box(short x) {
        return x;
    }

    public static Number box(int x) {
        return x;
    }

    public static Number box(long x) {
        return x;
    }

    public static Number box(float x) {
        return Float.valueOf(x);
    }

    public static Number box(double x) {
        return x;
    }

    public static char charCast(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        long n = ((Number)x).longValue();
        if (n < 0L || n > 65535L) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return (char)n;
    }

    public static char charCast(byte x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(short x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(char x) {
        return x;
    }

    public static char charCast(int x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(long x) {
        char i = (char)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(float x) {
        if (x >= 0.0f && x <= 65535.0f) {
            return (char)x;
        }
        throw new IllegalArgumentException("Value out of range for char: " + x);
    }

    public static char charCast(double x) {
        if (x >= 0.0 && x <= 65535.0) {
            return (char)x;
        }
        throw new IllegalArgumentException("Value out of range for char: " + x);
    }

    public static boolean booleanCast(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return x != null;
    }

    public static boolean booleanCast(boolean x) {
        return x;
    }

    public static byte byteCast(Object x) {
        if (x instanceof Byte) {
            return (Byte)x;
        }
        long n = RT.longCast(x);
        if (n < -128L || n > 127L) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return (byte)n;
    }

    public static byte byteCast(byte x) {
        return x;
    }

    public static byte byteCast(short x) {
        byte i = (byte)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(int x) {
        byte i = (byte)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(long x) {
        byte i = (byte)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(float x) {
        if (x >= -128.0f && x <= 127.0f) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Value out of range for byte: " + x);
    }

    public static byte byteCast(double x) {
        if (x >= -128.0 && x <= 127.0) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Value out of range for byte: " + x);
    }

    public static short shortCast(Object x) {
        if (x instanceof Short) {
            return (Short)x;
        }
        long n = RT.longCast(x);
        if (n < -32768L || n > 32767L) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return (short)n;
    }

    public static short shortCast(byte x) {
        return x;
    }

    public static short shortCast(short x) {
        return x;
    }

    public static short shortCast(int x) {
        short i = (short)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return i;
    }

    public static short shortCast(long x) {
        short i = (short)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return i;
    }

    public static short shortCast(float x) {
        if (x >= -32768.0f && x <= 32767.0f) {
            return (short)x;
        }
        throw new IllegalArgumentException("Value out of range for short: " + x);
    }

    public static short shortCast(double x) {
        if (x >= -32768.0 && x <= 32767.0) {
            return (short)x;
        }
        throw new IllegalArgumentException("Value out of range for short: " + x);
    }

    public static int intCast(Object x) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Number) {
            long n = RT.longCast(x);
            return RT.intCast(n);
        }
        return ((Character)x).charValue();
    }

    public static int intCast(char x) {
        return x;
    }

    public static int intCast(byte x) {
        return x;
    }

    public static int intCast(short x) {
        return x;
    }

    public static int intCast(int x) {
        return x;
    }

    public static int intCast(float x) {
        if (x < -2.1474836E9f || x > 2.1474836E9f) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return (int)x;
    }

    public static int intCast(long x) {
        int i = (int)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return i;
    }

    public static int intCast(double x) {
        if (x < -2.147483648E9 || x > 2.147483647E9) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return (int)x;
    }

    public static long longCast(Object x) {
        if (x instanceof Integer || x instanceof Long) {
            return ((Number)x).longValue();
        }
        if (x instanceof BigInt) {
            BigInt bi = (BigInt)x;
            if (bi.bipart == null) {
                return bi.lpart;
            }
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        if (x instanceof BigInteger) {
            BigInteger bi = (BigInteger)x;
            if (bi.bitLength() < 64) {
                return bi.longValue();
            }
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        if (x instanceof Byte || x instanceof Short) {
            return ((Number)x).longValue();
        }
        if (x instanceof Ratio) {
            return RT.longCast(((Ratio)x).bigIntegerValue());
        }
        if (x instanceof Character) {
            return RT.longCast(((Character)x).charValue());
        }
        return RT.longCast(((Number)x).doubleValue());
    }

    public static long longCast(byte x) {
        return x;
    }

    public static long longCast(short x) {
        return x;
    }

    public static long longCast(int x) {
        return x;
    }

    public static long longCast(float x) {
        if (x < -9.223372E18f || x > 9.223372E18f) {
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        return (long)x;
    }

    public static long longCast(long x) {
        return x;
    }

    public static long longCast(double x) {
        if (x < -9.223372036854776E18 || x > 9.223372036854776E18) {
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        return (long)x;
    }

    public static float floatCast(Object x) {
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        double n = ((Number)x).doubleValue();
        if (n < -3.4028234663852886E38 || n > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Value out of range for float: " + x);
        }
        return (float)n;
    }

    public static float floatCast(byte x) {
        return x;
    }

    public static float floatCast(short x) {
        return x;
    }

    public static float floatCast(int x) {
        return x;
    }

    public static float floatCast(float x) {
        return x;
    }

    public static float floatCast(long x) {
        return x;
    }

    public static float floatCast(double x) {
        if (x < -3.4028234663852886E38 || x > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Value out of range for float: " + x);
        }
        return (float)x;
    }

    public static double doubleCast(Object x) {
        return ((Number)x).doubleValue();
    }

    public static double doubleCast(byte x) {
        return x;
    }

    public static double doubleCast(short x) {
        return x;
    }

    public static double doubleCast(int x) {
        return x;
    }

    public static double doubleCast(float x) {
        return x;
    }

    public static double doubleCast(long x) {
        return x;
    }

    public static double doubleCast(double x) {
        return x;
    }

    public static byte uncheckedByteCast(Object x) {
        return ((Number)x).byteValue();
    }

    public static byte uncheckedByteCast(byte x) {
        return x;
    }

    public static byte uncheckedByteCast(short x) {
        return (byte)x;
    }

    public static byte uncheckedByteCast(int x) {
        return (byte)x;
    }

    public static byte uncheckedByteCast(long x) {
        return (byte)x;
    }

    public static byte uncheckedByteCast(float x) {
        return (byte)x;
    }

    public static byte uncheckedByteCast(double x) {
        return (byte)x;
    }

    public static short uncheckedShortCast(Object x) {
        return ((Number)x).shortValue();
    }

    public static short uncheckedShortCast(byte x) {
        return x;
    }

    public static short uncheckedShortCast(short x) {
        return x;
    }

    public static short uncheckedShortCast(int x) {
        return (short)x;
    }

    public static short uncheckedShortCast(long x) {
        return (short)x;
    }

    public static short uncheckedShortCast(float x) {
        return (short)x;
    }

    public static short uncheckedShortCast(double x) {
        return (short)x;
    }

    public static char uncheckedCharCast(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return (char)((Number)x).longValue();
    }

    public static char uncheckedCharCast(byte x) {
        return (char)x;
    }

    public static char uncheckedCharCast(short x) {
        return (char)x;
    }

    public static char uncheckedCharCast(char x) {
        return x;
    }

    public static char uncheckedCharCast(int x) {
        return (char)x;
    }

    public static char uncheckedCharCast(long x) {
        return (char)x;
    }

    public static char uncheckedCharCast(float x) {
        return (char)x;
    }

    public static char uncheckedCharCast(double x) {
        return (char)x;
    }

    public static int uncheckedIntCast(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return ((Character)x).charValue();
    }

    public static int uncheckedIntCast(byte x) {
        return x;
    }

    public static int uncheckedIntCast(short x) {
        return x;
    }

    public static int uncheckedIntCast(char x) {
        return x;
    }

    public static int uncheckedIntCast(int x) {
        return x;
    }

    public static int uncheckedIntCast(long x) {
        return (int)x;
    }

    public static int uncheckedIntCast(float x) {
        return (int)x;
    }

    public static int uncheckedIntCast(double x) {
        return (int)x;
    }

    public static long uncheckedLongCast(Object x) {
        return ((Number)x).longValue();
    }

    public static long uncheckedLongCast(byte x) {
        return x;
    }

    public static long uncheckedLongCast(short x) {
        return x;
    }

    public static long uncheckedLongCast(int x) {
        return x;
    }

    public static long uncheckedLongCast(long x) {
        return x;
    }

    public static long uncheckedLongCast(float x) {
        return (long)x;
    }

    public static long uncheckedLongCast(double x) {
        return (long)x;
    }

    public static float uncheckedFloatCast(Object x) {
        return ((Number)x).floatValue();
    }

    public static float uncheckedFloatCast(byte x) {
        return x;
    }

    public static float uncheckedFloatCast(short x) {
        return x;
    }

    public static float uncheckedFloatCast(int x) {
        return x;
    }

    public static float uncheckedFloatCast(long x) {
        return x;
    }

    public static float uncheckedFloatCast(float x) {
        return x;
    }

    public static float uncheckedFloatCast(double x) {
        return (float)x;
    }

    public static double uncheckedDoubleCast(Object x) {
        return ((Number)x).doubleValue();
    }

    public static double uncheckedDoubleCast(byte x) {
        return x;
    }

    public static double uncheckedDoubleCast(short x) {
        return x;
    }

    public static double uncheckedDoubleCast(int x) {
        return x;
    }

    public static double uncheckedDoubleCast(long x) {
        return x;
    }

    public static double uncheckedDoubleCast(float x) {
        return x;
    }

    public static double uncheckedDoubleCast(double x) {
        return x;
    }

    public static IPersistentMap map(Object ... init) {
        if (init == null) {
            return PersistentArrayMap.EMPTY;
        }
        if (init.length <= 16) {
            return PersistentArrayMap.createWithCheck(init);
        }
        return PersistentHashMap.createWithCheck(init);
    }

    public static IPersistentMap mapUniqueKeys(Object ... init) {
        if (init == null) {
            return PersistentArrayMap.EMPTY;
        }
        if (init.length <= 16) {
            return new PersistentArrayMap(init);
        }
        return PersistentHashMap.create(init);
    }

    public static IPersistentSet set(Object ... init) {
        return PersistentHashSet.createWithCheck(init);
    }

    public static IPersistentVector vector(Object ... init) {
        return LazilyPersistentVector.createOwning(init);
    }

    public static IPersistentVector subvec(IPersistentVector v, int start, int end) {
        if (end < start || start < 0 || end > v.count()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return PersistentVector.EMPTY;
        }
        return new APersistentVector.SubVector(null, v, start, end);
    }

    public static ISeq list() {
        return null;
    }

    public static ISeq list(Object arg1) {
        return new PersistentList(arg1);
    }

    public static ISeq list(Object arg1, Object arg2) {
        return RT.listStar(arg1, arg2, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3) {
        return RT.listStar(arg1, arg2, arg3, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4) {
        return RT.listStar(arg1, arg2, arg3, arg4, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return RT.listStar(arg1, arg2, arg3, arg4, arg5, null);
    }

    public static ISeq listStar(Object arg1, ISeq rest) {
        return RT.cons(arg1, rest);
    }

    public static ISeq listStar(Object arg1, Object arg2, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, rest));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, rest)));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, rest))));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, RT.cons(arg5, rest)))));
    }

    public static ISeq arrayToList(Object[] a) {
        ISeq ret = null;
        for (int i = a.length - 1; i >= 0; --i) {
            ret = RT.cons(a[i], ret);
        }
        return ret;
    }

    public static Object[] object_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new Object[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        Object[] ret = new Object[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = s.first();
        }
        return ret;
    }

    public static Object[] toArray(Object coll) {
        if (coll == null) {
            return EMPTY_ARRAY;
        }
        if (coll instanceof Object[]) {
            return (Object[])coll;
        }
        if (coll instanceof Collection) {
            return ((Collection)coll).toArray();
        }
        if (coll instanceof Iterable) {
            ArrayList ret = new ArrayList();
            for (Object o : (Iterable)coll) {
                ret.add(o);
            }
            return ret.toArray();
        }
        if (coll instanceof Map) {
            return ((Map)coll).entrySet().toArray();
        }
        if (coll instanceof String) {
            char[] chars2 = ((String)coll).toCharArray();
            Object[] ret = new Object[chars2.length];
            for (int i = 0; i < chars2.length; ++i) {
                ret[i] = Character.valueOf(chars2[i]);
            }
            return ret;
        }
        if (coll.getClass().isArray()) {
            ISeq s = RT.seq(coll);
            Object[] ret = new Object[RT.count(s)];
            int i = 0;
            while (i < ret.length) {
                ret[i] = s.first();
                ++i;
                s = s.next();
            }
            return ret;
        }
        throw Util.runtimeException("Unable to convert: " + coll.getClass() + " to Object[]");
    }

    public static Object[] seqToArray(ISeq seq) {
        int len = RT.length(seq);
        Object[] ret = new Object[len];
        int i = 0;
        while (seq != null) {
            ret[i] = seq.first();
            ++i;
            seq = seq.next();
        }
        return ret;
    }

    public static Object[] seqToPassedArray(ISeq seq, Object[] passed) {
        Object[] dest = passed;
        int len = RT.count(seq);
        if (len > dest.length) {
            dest = (Object[])Array.newInstance(passed.getClass().getComponentType(), len);
        }
        int i = 0;
        while (seq != null) {
            dest[i] = seq.first();
            ++i;
            seq = seq.next();
        }
        if (len < passed.length) {
            dest[len] = null;
        }
        return dest;
    }

    public static Object seqToTypedArray(ISeq seq) {
        Class<Object> type2 = seq != null && seq.first() != null ? seq.first().getClass() : Object.class;
        return RT.seqToTypedArray(type2, seq);
    }

    public static Object seqToTypedArray(Class type2, ISeq seq) {
        Object ret = Array.newInstance(type2, RT.length(seq));
        if (type2 == Integer.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.intCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type2 == Byte.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.byteCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type2 == Float.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, Float.valueOf(RT.floatCast(seq.first())));
                ++i;
                seq = seq.next();
            }
        } else if (type2 == Short.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.shortCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type2 == Character.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, Character.valueOf(RT.charCast(seq.first())));
                ++i;
                seq = seq.next();
            }
        } else {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, seq.first());
                ++i;
                seq = seq.next();
            }
        }
        return ret;
    }

    public static int length(ISeq list) {
        int i = 0;
        for (ISeq c = list; c != null; c = c.next()) {
            ++i;
        }
        return i;
    }

    public static int boundedLength(ISeq list, int limit) {
        int i = 0;
        for (ISeq c = list; c != null && i <= limit; ++i, c = c.next()) {
        }
        return i;
    }

    static Character readRet(int ret) {
        if (ret == -1) {
            return null;
        }
        return RT.box((char)ret);
    }

    public static Character readChar(Reader r) throws IOException {
        int ret = r.read();
        return RT.readRet(ret);
    }

    public static Character peekChar(Reader r) throws IOException {
        int ret;
        if (r instanceof PushbackReader) {
            ret = r.read();
            ((PushbackReader)r).unread(ret);
        } else {
            r.mark(1);
            ret = r.read();
            r.reset();
        }
        return RT.readRet(ret);
    }

    public static int getLineNumber(Reader r) {
        if (r instanceof LineNumberingPushbackReader) {
            return ((LineNumberingPushbackReader)r).getLineNumber();
        }
        return 0;
    }

    public static int getColumnNumber(Reader r) {
        if (r instanceof LineNumberingPushbackReader) {
            return ((LineNumberingPushbackReader)r).getColumnNumber();
        }
        return 0;
    }

    public static LineNumberingPushbackReader getLineNumberingReader(Reader r) {
        if (RT.isLineNumberingReader(r)) {
            return (LineNumberingPushbackReader)r;
        }
        return new LineNumberingPushbackReader(r);
    }

    public static boolean isLineNumberingReader(Reader r) {
        return r instanceof LineNumberingPushbackReader;
    }

    public static boolean isReduced(Object r) {
        return r instanceof Reduced;
    }

    public static String resolveClassNameInContext(String className) {
        return className;
    }

    public static boolean suppressRead() {
        return RT.booleanCast(SUPPRESS_READ.deref());
    }

    public static String printString(Object x) {
        try {
            StringWriter sw = new StringWriter();
            RT.print(x, sw);
            return sw.toString();
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(e2);
        }
    }

    public static Object readString(String s) {
        return RT.readString(s, null);
    }

    public static Object readString(String s, Object opts) {
        PushbackReader r = new PushbackReader(new StringReader(s));
        return LispReader.read(r, opts);
    }

    public static void print(Object x, Writer w) throws IOException {
        if (PRINT_INITIALIZED.isBound() && RT.booleanCast(PRINT_INITIALIZED.deref())) {
            PR_ON.invoke(x, w);
        } else {
            Object s;
            Obj o;
            boolean readably = RT.booleanCast(PRINT_READABLY.deref());
            if (x instanceof Obj && RT.count((o = (Obj)x).meta()) > 0 && (readably && RT.booleanCast(PRINT_META.deref()) || RT.booleanCast(PRINT_DUP.deref()))) {
                IPersistentMap meta = o.meta();
                w.write("#^");
                if (meta.count() == 1 && meta.containsKey(TAG_KEY)) {
                    RT.print(meta.valAt(TAG_KEY), w);
                } else {
                    RT.print(meta, w);
                }
                w.write(32);
            }
            if (x == null) {
                w.write("nil");
            } else if (x instanceof ISeq || x instanceof IPersistentList) {
                w.write(40);
                RT.printInnerSeq(RT.seq(x), w);
                w.write(41);
            } else if (x instanceof String) {
                s = (String)x;
                if (!readably) {
                    w.write((String)s);
                } else {
                    w.write(34);
                    block17: for (int i = 0; i < ((String)s).length(); ++i) {
                        char c = ((String)s).charAt(i);
                        switch (c) {
                            case '\n': {
                                w.write("\\n");
                                continue block17;
                            }
                            case '\t': {
                                w.write("\\t");
                                continue block17;
                            }
                            case '\r': {
                                w.write("\\r");
                                continue block17;
                            }
                            case '\"': {
                                w.write("\\\"");
                                continue block17;
                            }
                            case '\\': {
                                w.write("\\\\");
                                continue block17;
                            }
                            case '\f': {
                                w.write("\\f");
                                continue block17;
                            }
                            case '\b': {
                                w.write("\\b");
                                continue block17;
                            }
                            default: {
                                w.write(c);
                            }
                        }
                    }
                    w.write(34);
                }
            } else if (x instanceof IPersistentMap) {
                w.write(123);
                for (s = RT.seq(x); s != null; s = s.next()) {
                    IMapEntry e2 = (IMapEntry)s.first();
                    RT.print(e2.key(), w);
                    w.write(32);
                    RT.print(e2.val(), w);
                    if (s.next() == null) continue;
                    w.write(", ");
                }
                w.write(125);
            } else if (x instanceof IPersistentVector) {
                IPersistentVector a = (IPersistentVector)x;
                w.write(91);
                for (int i = 0; i < a.count(); ++i) {
                    RT.print(a.nth(i), w);
                    if (i >= a.count() - 1) continue;
                    w.write(32);
                }
                w.write(93);
            } else if (x instanceof IPersistentSet) {
                w.write("#{");
                for (s = RT.seq(x); s != null; s = s.next()) {
                    RT.print(s.first(), w);
                    if (s.next() == null) continue;
                    w.write(" ");
                }
                w.write(125);
            } else if (x instanceof Character) {
                char c = ((Character)x).charValue();
                if (!readably) {
                    w.write(c);
                } else {
                    w.write(92);
                    switch (c) {
                        case '\n': {
                            w.write("newline");
                            break;
                        }
                        case '\t': {
                            w.write("tab");
                            break;
                        }
                        case ' ': {
                            w.write("space");
                            break;
                        }
                        case '\b': {
                            w.write("backspace");
                            break;
                        }
                        case '\f': {
                            w.write("formfeed");
                            break;
                        }
                        case '\r': {
                            w.write("return");
                            break;
                        }
                        default: {
                            w.write(c);
                        }
                    }
                }
            } else if (x instanceof Class) {
                w.write("#=");
                w.write(((Class)x).getName());
            } else if (x instanceof BigDecimal && readably) {
                w.write(x.toString());
                w.write(77);
            } else if (x instanceof BigInt && readably) {
                w.write(x.toString());
                w.write(78);
            } else if (x instanceof BigInteger && readably) {
                w.write(x.toString());
                w.write("BIGINT");
            } else if (x instanceof Var) {
                Var v = (Var)x;
                w.write("#=(var " + v.ns.name + "/" + v.sym + ")");
            } else if (x instanceof Pattern) {
                Pattern p = (Pattern)x;
                w.write("#\"" + p.pattern() + "\"");
            } else {
                w.write(x.toString());
            }
        }
    }

    private static void printInnerSeq(ISeq x, Writer w) throws IOException {
        for (ISeq s = x; s != null; s = s.next()) {
            RT.print(s.first(), w);
            if (s.next() == null) continue;
            w.write(32);
        }
    }

    public static void formatAesthetic(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else {
            w.write(obj.toString());
        }
    }

    public static void formatStandard(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else if (obj instanceof String) {
            w.write(34);
            w.write((String)obj);
            w.write(34);
        } else if (obj instanceof Character) {
            w.write(92);
            char c = ((Character)obj).charValue();
            switch (c) {
                case '\n': {
                    w.write("newline");
                    break;
                }
                case '\t': {
                    w.write("tab");
                    break;
                }
                case ' ': {
                    w.write("space");
                    break;
                }
                case '\b': {
                    w.write("backspace");
                    break;
                }
                case '\f': {
                    w.write("formfeed");
                    break;
                }
                default: {
                    w.write(c);
                    break;
                }
            }
        } else {
            w.write(obj.toString());
        }
    }

    public static Object format(Object o, String s, Object ... args) throws IOException {
        Writer w = o == null ? new StringWriter() : (Util.equals(o, T) ? (Writer)OUT.deref() : (Writer)o);
        RT.doFormat(w, s, ArraySeq.create(args));
        if (o == null) {
            return w.toString();
        }
        return null;
    }

    public static ISeq doFormat(Writer w, String s, ISeq args) throws IOException {
        int i = 0;
        block12: while (i < s.length()) {
            char c = s.charAt(i++);
            block0 : switch (Character.toLowerCase(c)) {
                case '~': {
                    char d = s.charAt(i++);
                    switch (Character.toLowerCase(d)) {
                        case '%': {
                            w.write(10);
                            break block0;
                        }
                        case 't': {
                            w.write(9);
                            break block0;
                        }
                        case 'a': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatAesthetic(w, RT.first(args));
                            args = RT.next(args);
                            break block0;
                        }
                        case 's': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatStandard(w, RT.first(args));
                            args = RT.next(args);
                            break block0;
                        }
                        case '{': {
                            int j = s.indexOf("~}", i);
                            if (j == -1) {
                                throw new IllegalArgumentException("Missing ~}");
                            }
                            String subs2 = s.substring(i, j);
                            ISeq sargs = RT.seq(RT.first(args));
                            while (sargs != null) {
                                sargs = RT.doFormat(w, subs2, sargs);
                            }
                            args = RT.next(args);
                            i = j + 2;
                            break block0;
                        }
                        case '^': {
                            if (args != null) continue block12;
                            return null;
                        }
                        case '~': {
                            w.write(126);
                            break block0;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported ~ directive: " + d);
                        }
                    }
                }
                default: {
                    w.write(c);
                }
            }
        }
        return args;
    }

    public static Object[] setValues(Object ... vals2) {
        if (vals2.length > 0) {
            return vals2;
        }
        return null;
    }

    public static ClassLoader makeClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Var.pushThreadBindings(RT.map(USE_CONTEXT_CLASSLOADER, T));
                    DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(RT.baseLoader());
                    return dynamicClassLoader;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        });
    }

    public static ClassLoader baseLoader() {
        if (Compiler.LOADER.isBound()) {
            return (ClassLoader)Compiler.LOADER.deref();
        }
        if (RT.booleanCast(USE_CONTEXT_CLASSLOADER.deref())) {
            return Thread.currentThread().getContextClassLoader();
        }
        return Compiler.class.getClassLoader();
    }

    public static InputStream resourceAsStream(ClassLoader loader, String name2) {
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(name2);
        }
        return loader.getResourceAsStream(name2);
    }

    public static URL getResource(ClassLoader loader, String name2) {
        if (loader == null) {
            return ClassLoader.getSystemResource(name2);
        }
        return loader.getResource(name2);
    }

    public static Class classForName(String name2, boolean load2, ClassLoader loader) {
        try {
            Class<?> c = null;
            if (!(loader instanceof DynamicClassLoader)) {
                c = DynamicClassLoader.findInMemoryClass(name2);
            }
            if (c != null) {
                return c;
            }
            return Class.forName(name2, load2, loader);
        }
        catch (ClassNotFoundException e2) {
            throw Util.sneakyThrow(e2);
        }
    }

    public static Class classForName(String name2) {
        return RT.classForName(name2, true, RT.baseLoader());
    }

    public static Class classForNameNonLoading(String name2) {
        return RT.classForName(name2, false, RT.baseLoader());
    }

    public static Class loadClassForName(String name2) {
        try {
            RT.classForNameNonLoading(name2);
        }
        catch (Exception e2) {
            if (e2 instanceof ClassNotFoundException) {
                return null;
            }
            throw Util.sneakyThrow(e2);
        }
        return RT.classForName(name2);
    }

    public static float aget(float[] xs, int i) {
        return xs[i];
    }

    public static float aset(float[] xs, int i, float v) {
        xs[i] = v;
        return v;
    }

    public static int alength(float[] xs) {
        return xs.length;
    }

    public static float[] aclone(float[] xs) {
        return (float[])xs.clone();
    }

    public static double aget(double[] xs, int i) {
        return xs[i];
    }

    public static double aset(double[] xs, int i, double v) {
        xs[i] = v;
        return v;
    }

    public static int alength(double[] xs) {
        return xs.length;
    }

    public static double[] aclone(double[] xs) {
        return (double[])xs.clone();
    }

    public static int aget(int[] xs, int i) {
        return xs[i];
    }

    public static int aset(int[] xs, int i, int v) {
        xs[i] = v;
        return v;
    }

    public static int alength(int[] xs) {
        return xs.length;
    }

    public static int[] aclone(int[] xs) {
        return (int[])xs.clone();
    }

    public static long aget(long[] xs, int i) {
        return xs[i];
    }

    public static long aset(long[] xs, int i, long v) {
        xs[i] = v;
        return v;
    }

    public static int alength(long[] xs) {
        return xs.length;
    }

    public static long[] aclone(long[] xs) {
        return (long[])xs.clone();
    }

    public static char aget(char[] xs, int i) {
        return xs[i];
    }

    public static char aset(char[] xs, int i, char v) {
        xs[i] = v;
        return v;
    }

    public static int alength(char[] xs) {
        return xs.length;
    }

    public static char[] aclone(char[] xs) {
        return (char[])xs.clone();
    }

    public static byte aget(byte[] xs, int i) {
        return xs[i];
    }

    public static byte aset(byte[] xs, int i, byte v) {
        xs[i] = v;
        return v;
    }

    public static int alength(byte[] xs) {
        return xs.length;
    }

    public static byte[] aclone(byte[] xs) {
        return (byte[])xs.clone();
    }

    public static short aget(short[] xs, int i) {
        return xs[i];
    }

    public static short aset(short[] xs, int i, short v) {
        xs[i] = v;
        return v;
    }

    public static int alength(short[] xs) {
        return xs.length;
    }

    public static short[] aclone(short[] xs) {
        return (short[])xs.clone();
    }

    public static boolean aget(boolean[] xs, int i) {
        return xs[i];
    }

    public static boolean aset(boolean[] xs, int i, boolean v) {
        xs[i] = v;
        return v;
    }

    public static int alength(boolean[] xs) {
        return xs.length;
    }

    public static boolean[] aclone(boolean[] xs) {
        return (boolean[])xs.clone();
    }

    public static Object aget(Object[] xs, int i) {
        return xs[i];
    }

    public static Object aset(Object[] xs, int i, Object v) {
        xs[i] = v;
        return v;
    }

    public static int alength(Object[] xs) {
        return xs.length;
    }

    public static Object[] aclone(Object[] xs) {
        return (Object[])xs.clone();
    }

    static {
        Keyword arglistskw = Keyword.intern(null, "arglists");
        Symbol namesym = Symbol.intern("name");
        OUT.setTag(Symbol.intern("java.io.Writer"));
        CURRENT_NS.setTag(Symbol.intern("clojure.lang.Namespace"));
        AGENT.setMeta(RT.map(DOC_KEY, "The agent currently running an action on this thread, else nil"));
        AGENT.setTag(Symbol.intern("clojure.lang.Agent"));
        MATH_CONTEXT.setTag(Symbol.intern("java.math.MathContext"));
        Var nv = Var.intern(CLOJURE_NS, NAMESPACE, bootNamespace);
        nv.setMacro();
        Var v = Var.intern(CLOJURE_NS, IN_NAMESPACE, inNamespace);
        v.setMeta(RT.map(DOC_KEY, "Sets *ns* to the namespace named by the symbol, creating it if needed.", arglistskw, RT.list(RT.vector(namesym))));
        v = Var.intern(CLOJURE_NS, LOAD_FILE, new AFn(){

            @Override
            public Object invoke(Object arg1) {
                try {
                    return Compiler.loadFile((String)arg1);
                }
                catch (IOException e2) {
                    throw Util.sneakyThrow(e2);
                }
            }
        });
        v.setMeta(RT.map(DOC_KEY, "Sequentially read and evaluate the set of forms contained in the file.", arglistskw, RT.list(RT.vector(namesym))));
        try {
            RT.doInit();
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(e2);
        }
    }

    private static final class DefaultComparator
    implements Comparator,
    Serializable {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Util.compare(o1, o2);
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT_COMPARATOR;
        }
    }
}

