(ns {{project-ns}}.core
  (:import goog.History)
  (:require [reagent.core :as reagent]
            [secretary.core :as secretary :include-macros true]
            [goog.events :as events]
            [goog.history.EventType :as EventType]
            [{{project-ns}}.global-state :refer [global-app-state]]
            [{{project-ns}}.router :as router]))

(defonce debug? ^boolean js/goog.DEBUG)

(defn dev-setup []
  (when debug?
    (enable-console-print!)
    (println "dev mode")))

(defn hook-browser-navigation! []
  (doto (History.)
    (events/listen
     EventType/NAVIGATE
     (fn [event]
       (secretary/dispatch! (.-token event))))
    (.setEnabled true)))

(defn current-page [state]
  (let [page-key (-> @state :page :name)]
    [(router/page page-key) state]))

(defn reload []
  (reagent/render [current-page global-app-state] (.getElementById js/document "app")))

(defn ^:export main []
  (dev-setup)
  (router/app-routes)
  (hook-browser-navigation!)
  (reload))
