(ns {{project-ns}}.routes.demo-route
  (:require [reagent.core :as reagent :refer [atom]]
            [{{project-ns}}.global-state :refer [global-app-state]]))

(def route-state (atom {:form-input-field "" :form-data ""}))

(defn update-input-field-value [new-value]
  (swap! route-state assoc :form-input-field new-value))

(defn update-form-data-with-form-values []
  (swap! route-state assoc :form-data (:form-input-field @route-state)))

(defn form-input-box []
  [:input {:type        "text"
           :placeholder "Enter Something"
           :value       (:form-input-field @route-state)
           :on-change   #(update-input-field-value (-> % .-target .-value))}])

(defn update-form-button []
  [:input {:type     "button"
           :value    "Update Form"
           :on-click #(update-form-data-with-form-values)}])

(defn demo-page []
  [:div
   [:h1 (str "ID: " (:params (:page @global-app-state)))]
   [:h2 {:id "header"} "Contrived Example"]
   [form-input-box]
   [update-form-button]
   [:p "Form data: "(:form-data @route-state)]
   [:div [:a {:href "#/"} "Go To Index Page"]]])

