(defproject {{ name }} "0.1.0-SNAPSHOT"

  :min-lein-version "2.6.1"

  :dependencies [[org.clojure/clojure       "1.8.0"]
                 [org.clojure/clojurescript "1.9.93" :scope "provided"]
                 [reagent                   "0.6.0-rc"]
                 [reagent-forms             "0.5.24"]
                 [reagent-utils             "0.1.9"]
                 [secretary                 "1.2.3"]]

  :plugins [[lein-cljsbuild "1.1.3" :exclusions [[org.clojure/clojure]]]
            [lein-less      "1.7.5"]]

  :source-paths ["src"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled" "target"]

  :cljsbuild {:builds
              [{:id           "test"
                :source-paths ["src" "test"]
                :compiler     {:output-to     "resources/public/js/compiled/test.js"
                               :output-dir    "resources/public/js/compiled/test"
                               :main          {{name}}.runner
                               :optimizations :none}}

               {:id           "dev"
                :source-paths ["src"]
                :figwheel     {:on-jsload "{{project-ns}}.core/reload"}
                :compiler     {:main                 {{project-ns}}.core
                               :optimizations        :none
                               :asset-path           "js/compiled/dev"
                               :output-to            "resources/public/js/compiled/app.js"
                               :output-dir           "resources/public/js/compiled/dev"
                               :source-map-timestamp true
                               :preloads             [devtools.preload]}}

               ;; Compressed minified build for production. You can build this with: `lein cljsbuild once min`
               {:id           "min"
                :source-paths ["src"]
                :compiler     {:output-to       "resources/public/js/compiled/app.js"
                               :output-dir      "resources/public/js/compiled/min"
                               :main            {{project-ns}}.core
                               :optimizations   :advanced
                               :closure-defines {goog.DEBUG false}
                               :pretty-print    false}}]}

  :figwheel {:css-dirs ["resources/public/css"]}

  :less {:source-paths ["less"]
         :target-path  "resources/public/css"}

  :profiles {:dev {:dependencies [[binaryage/devtools "0.8.1"]]
                   :plugins      [[lein-figwheel  "0.5.8"]
                                  [lein-doo       "0.1.7"]]}})
