/*
 * Decompiled with CFR 0.152.
 */
package flop;

import flop.DMath;
import java.util.Random;

public class DArray {
    public static int sampleDiscrete(Random random, double[] dArray) {
        double d = random.nextDouble();
        for (int i = 0; i < dArray.length; ++i) {
            if (!((d -= dArray[i]) <= 0.0)) continue;
            return i;
        }
        assert (dArray.length > 0);
        return 0;
    }

    public static double logAdd(double[] dArray) {
        double d = 0.0;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d2)) continue;
            d2 = dArray[i];
            d = i;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = d2 - 30.0;
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if ((double)i == d || !(dArray[i] > d3)) continue;
            d4 += DMath.sloppyExpNegative(dArray[i] - d2);
        }
        if (d4 > 0.0) {
            return d2 + Math.log(1.0 + d4);
        }
        return d2;
    }

    public static void addInPlace(double[] dArray, double[] dArray2, double d, double d2) {
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = d * dArray2[i] + d2;
            if (d3 == 0.0) continue;
            int n = i;
            dArray[n] = dArray[n] + d3;
        }
    }

    public static void multiplyInPlace(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] * dArray2[i];
        }
    }
}

