/*
 * Decompiled with CFR 0.152.
 */
package flop;

import java.util.Random;

public class DMath {
    static final double LOGTOLERANCE = 30.0;
    private static double[] sloppyExpCache;
    private static final int sloppyExpBins = 100000;
    private static final double invBinSize = 3333.3333333333335;
    public static double[] cachedLogs;
    public static double MIN_LOG;
    public static double MAX_LOG;
    public static int NUM_APPROX;

    public static long leftShift(long l, int n) {
        return l << n;
    }

    public static long rightShift(long l, int n) {
        return l >> n;
    }

    public static long unsignedRightShift(long l, int n) {
        return l >>> n;
    }

    public static int intCast(long l) {
        return (int)l;
    }

    public static double sampleGaussian(Random random) {
        double d = random.nextDouble();
        double d2 = random.nextDouble();
        double d3 = Math.sqrt(-2.0 * DMath.sloppyLog(d)) * Math.cos(Math.PI * 2 * d2);
        return d3;
    }

    public static double sampleGamma(Random random, double d, double d2) {
        double d3;
        double d4;
        if (d < 1.0) {
            d4 = DMath.sloppyExp(DMath.sloppyLog(random.nextDouble()) / d);
            d += 1.0;
        } else {
            d4 = 1.0;
        }
        double d5 = d - 0.3333333333333333;
        double d6 = 1.0 / Math.sqrt(9.0 * d5);
        while (true) {
            double d7;
            if ((d3 = 1.0 + d6 * (d7 = DMath.sampleGaussian(random))) <= 0.0) {
                continue;
            }
            d3 = d3 * d3 * d3;
            d7 *= d7;
            double d8 = random.nextDouble();
            if (d8 < 1.0 - 0.0331 * d7 * d7 || DMath.sloppyLog(d8) < 0.5 * d7 + d5 * (1.0 - d3 + DMath.sloppyLog(d3))) break;
        }
        return d4 * d5 * d3 / d2;
    }

    public static double digamma(double d) {
        double d2 = 0.0;
        while (d <= 5.0) {
            d2 -= 1.0 / d;
            d += 1.0;
        }
        double d3 = 1.0 / (d * d);
        double d4 = d3 * (-0.08333333333333333 + d3 * (0.008333333333333333 + d3 * (-0.003968253968253968 + d3 * (0.004166666666666667 + d3 * (-0.007575757575757576 + d3 * (0.021092796092796094 + d3 * (-0.08333333333333333 + d3 * 3617.0 / 8160.0)))))));
        return d2 + DMath.sloppyLog(d) - 0.5 / d + d4;
    }

    public static double logGamma(double d) {
        double d2 = (d - 0.5) * DMath.sloppyLog(d + 4.5) - (d + 4.5);
        double d3 = 1.0 + 76.18009173 / (d + 0.0) - 86.50532033 / (d + 1.0) + 24.01409822 / (d + 2.0) - 1.231739516 / (d + 3.0) + 0.00120858003 / (d + 4.0) - 5.36382E-6 / (d + 5.0);
        return d2 + DMath.sloppyLog(d3 * Math.sqrt(Math.PI * 2));
    }

    public static double sloppyExp(double d) {
        if (d < -30.0) {
            return 0.0;
        }
        if (Math.abs(d) < 0.001) {
            return 1.0 + d;
        }
        return Math.exp(d);
    }

    public static double sloppyExpNegative(double d) {
        double d2;
        assert (d <= 0.0);
        if (sloppyExpCache == null) {
            sloppyExpCache = new double[100001];
            d2 = 1.5E-4;
            for (int i = 0; i < 100000; ++i) {
                DMath.sloppyExpCache[i] = Math.exp((double)i * 30.0 / 100000.0 - 30.0 + d2);
            }
            DMath.sloppyExpCache[100000] = 1.0;
        }
        if (d <= -30.0) {
            return 0.0;
        }
        d2 = (d + 30.0) * 3333.3333333333335;
        return sloppyExpCache[(int)d2];
    }

    public static double sloppyLog(double d) {
        return Math.log(d);
    }

    static {
        MIN_LOG = -30.0;
        MAX_LOG = 600.0;
        NUM_APPROX = 20000;
    }
}

