/*
 * Decompiled with CFR 0.152.
 */
package flop;

import clojure.lang.Counted;
import clojure.lang.IFn;
import flop.LDReducable;
import gnu.trove.TLongDoubleHashMap;
import gnu.trove.TLongDoubleIterator;
import gnu.trove.TLongDoubleProcedure;
import gnu.trove.TLongIntHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class LongDoubleFeatureVector
implements Counted,
Iterable<Map.Entry<Long, Double>>,
Externalizable,
Cloneable,
LDReducable {
    public static final long serialVersionUID = 7600069475578538731L;
    public static final double growthRate = 1.5;
    public long[] keys;
    public double[] values;
    public int count = 0;
    public TLongIntHashMap keyIndex;

    public LongDoubleFeatureVector(int n) {
        this.keys = new long[n];
        this.values = new double[n];
        this.keyIndex = new TLongIntHashMap();
    }

    public long[] keys() {
        return Arrays.copyOf(this.keys, this.size());
    }

    public LongDoubleFeatureVector() {
        this(4);
    }

    public LongDoubleFeatureVector(LongDoubleFeatureVector longDoubleFeatureVector) {
        this(longDoubleFeatureVector.size());
        this.putAll(longDoubleFeatureVector);
    }

    public LongDoubleFeatureVector(Map<Long, Double> map) {
        this(map.size());
        this.putAll(map);
    }

    public LongDoubleFeatureVector(TLongDoubleHashMap tLongDoubleHashMap) {
        this(tLongDoubleHashMap.size());
        this.putAll(tLongDoubleHashMap);
    }

    public LongDoubleFeatureVector clone() {
        return new LongDoubleFeatureVector(this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.compact();
        objectOutput.writeByte(1);
        objectOutput.writeInt(this.count);
        objectOutput.writeObject(this.keys);
        objectOutput.writeObject(this.values);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readByte() != 1) {
            throw new IOException("Unknown object version");
        }
        this.count = objectInput.readInt();
        this.keys = (long[])objectInput.readObject();
        this.values = (double[])objectInput.readObject();
        for (int i = 0; i < this.count; ++i) {
            this.keyIndex.put(this.keys[i], i);
        }
    }

    public void clear() {
        this.count = 0;
        this.keys = new long[4];
        this.values = new double[4];
        this.keyIndex = new TLongIntHashMap();
    }

    public int capacity() {
        return this.keys.length;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public int indexOf(long l) {
        int n = this.keyIndex.get(l);
        if (n > 0) {
            return n;
        }
        if (this.count > 0 && this.keys[0] == l) {
            return 0;
        }
        return -1;
    }

    public double get(long l) {
        int n = this.indexOf(l);
        if (n < 0) {
            return 0.0;
        }
        return this.values[n];
    }

    private void rawPut(long l, double d) {
        int n = this.indexOf(l);
        if (n < 0) {
            if (d == 0.0) {
                return;
            }
            this.keys[this.count] = l;
            this.values[this.count] = d;
            this.keyIndex.put(l, this.count);
            ++this.count;
        } else if (d == 0.0) {
            this.rawRemove(l);
        } else {
            this.values[n] = d;
        }
    }

    private double rawIncrement(long l, double d) {
        int n = this.indexOf(l);
        if (n < 0) {
            this.keys[this.count] = l;
            this.values[this.count] = d;
            this.keyIndex.put(l, this.count);
            ++this.count;
            return d;
        }
        double d2 = this.values[n] + d;
        if (d2 == 0.0) {
            this.rawRemove(l);
        } else {
            int n2 = n;
            this.values[n2] = this.values[n2] + d;
        }
        return d2;
    }

    public void putAll(TLongDoubleHashMap tLongDoubleHashMap) {
        this.ensureCapacity(this.count + tLongDoubleHashMap.size());
        tLongDoubleHashMap.forEachEntry(new TLongDoubleProcedure(){

            public boolean execute(long l, double d) {
                LongDoubleFeatureVector.this.rawPut(l, d);
                return true;
            }
        });
    }

    public void incrementAll(TLongDoubleHashMap tLongDoubleHashMap, final double d) {
        this.ensureCapacity(this.count + tLongDoubleHashMap.size());
        tLongDoubleHashMap.forEachEntry(new TLongDoubleProcedure(){

            public boolean execute(long l, double d2) {
                LongDoubleFeatureVector.this.rawIncrement(l, d2 * d);
                return true;
            }
        });
    }

    public void putAll(Map<Long, Double> map) {
        this.ensureCapacity(this.count + map.size());
        for (Map.Entry<Long, Double> entry : map.entrySet()) {
            this.rawPut(entry.getKey(), entry.getValue());
        }
    }

    public void incrementAll(Map<Long, Double> map, double d) {
        this.ensureCapacity(this.count + map.size());
        for (Map.Entry<Long, Double> entry : map.entrySet()) {
            this.rawIncrement(entry.getKey(), entry.getValue() * d);
        }
    }

    public void putAll(LongDoubleFeatureVector longDoubleFeatureVector) {
        this.ensureCapacity(this.count + longDoubleFeatureVector.size());
        for (int i = 0; i < longDoubleFeatureVector.count; ++i) {
            this.rawPut(longDoubleFeatureVector.keys[i], longDoubleFeatureVector.values[i]);
        }
    }

    public void incrementAll(LongDoubleFeatureVector longDoubleFeatureVector, double d) {
        this.ensureCapacity(this.count + longDoubleFeatureVector.size());
        for (int i = 0; i < longDoubleFeatureVector.count; ++i) {
            this.rawIncrement(longDoubleFeatureVector.keys[i], longDoubleFeatureVector.values[i] * d);
        }
    }

    public void put(long l, double d) {
        this.ensureCapacity(this.count + 1);
        this.rawPut(l, d);
    }

    public double increment(long l, double d) {
        this.ensureCapacity(this.count + 1);
        return this.rawIncrement(l, d);
    }

    public boolean rawRemove(long l) {
        int n = this.indexOf(l);
        if (n < 0) {
            return false;
        }
        this.keyIndex.remove(l);
        --this.count;
        if (this.count > n) {
            this.keys[n] = this.keys[this.count];
            this.values[n] = this.values[this.count];
            this.keyIndex.put(this.keys[n], n);
        }
        return true;
    }

    public boolean remove(long l) {
        if (!this.rawRemove(l)) {
            return false;
        }
        if ((double)this.count < (double)this.keys.length / 2.25) {
            this.resize((int)((double)this.count * 1.5));
        }
        return true;
    }

    public boolean removeAll(List<Long> list) {
        boolean bl = false;
        for (long l : list) {
            bl = this.remove(l) || bl;
        }
        return bl;
    }

    public void ensureCapacity(int n) {
        if (n > this.keys.length) {
            this.resize((int)Math.max((double)n, 1.5 * (double)this.keys.length));
        }
    }

    public void resize(int n) {
        if (n < this.count) {
            throw new IllegalArgumentException("cannot decrease capacity below size");
        }
        this.keys = Arrays.copyOf(this.keys, n);
        this.values = Arrays.copyOf(this.values, n);
    }

    public void compact() {
        this.resize(this.count);
    }

    public FVIterator fvIterator() {
        return new FVIterator();
    }

    @Override
    public Iterator<Map.Entry<Long, Double>> iterator() {
        return new FVIterator();
    }

    public Map<Long, Double> asMap() {
        HashMap<Long, Double> hashMap = new HashMap<Long, Double>();
        for (int i = 0; i < this.count; ++i) {
            hashMap.put(this.keys[i], this.values[i]);
        }
        return hashMap;
    }

    public TLongDoubleHashMap asTrove() {
        TLongDoubleHashMap tLongDoubleHashMap = new TLongDoubleHashMap();
        for (int i = 0; i < this.count; ++i) {
            tLongDoubleHashMap.put(this.keys[i], this.values[i]);
        }
        return tLongDoubleHashMap;
    }

    public double norm() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.values[i] * this.values[i];
        }
        return Math.sqrt(d);
    }

    public double diffNorm(LongDoubleFeatureVector longDoubleFeatureVector) {
        double d;
        int n;
        double d2 = 0.0;
        for (n = 0; n < this.count; ++n) {
            d = this.values[n] - longDoubleFeatureVector.get(this.keys[n]);
            d2 += d * d;
        }
        for (n = 0; n < longDoubleFeatureVector.count; ++n) {
            if (this.indexOf(longDoubleFeatureVector.keys[n]) > 0) continue;
            d = 0.0 - longDoubleFeatureVector.values[n];
            d2 += d * d;
        }
        return Math.sqrt(d2);
    }

    public LongDoubleFeatureVector scaleInPlace(double d) {
        int n = 0;
        while (n < this.count) {
            int n2 = n++;
            this.values[n2] = this.values[n2] * d;
        }
        return this;
    }

    public LongDoubleFeatureVector normalizeInPlace() {
        double d = this.norm();
        if (d > 0.0) {
            this.scaleInPlace(1.0 / d);
        }
        return this;
    }

    public LongDoubleFeatureVector normalized() {
        return new LongDoubleFeatureVector(this).normalizeInPlace();
    }

    public double dotProduct(TLongDoubleHashMap tLongDoubleHashMap) {
        double d = 0.0;
        if (tLongDoubleHashMap.size() > 0) {
            for (int i = 0; i < this.count; ++i) {
                d += this.values[i] * tLongDoubleHashMap.get(this.keys[i]);
            }
        }
        return d;
    }

    public double dotProduct(LongDoubleFeatureVector longDoubleFeatureVector) {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.values[i] * longDoubleFeatureVector.get(this.keys[i]);
        }
        return d;
    }

    public static double dotProduct(TLongDoubleHashMap tLongDoubleHashMap, TLongDoubleHashMap tLongDoubleHashMap2) {
        if (tLongDoubleHashMap.size() > tLongDoubleHashMap2.size()) {
            return LongDoubleFeatureVector.dotProduct(tLongDoubleHashMap2, tLongDoubleHashMap);
        }
        double d = 0.0;
        TLongDoubleIterator tLongDoubleIterator = tLongDoubleHashMap.iterator();
        while (tLongDoubleIterator.hasNext()) {
            tLongDoubleIterator.advance();
            d += tLongDoubleIterator.value() * tLongDoubleHashMap2.get(tLongDoubleIterator.key());
        }
        return d;
    }

    public double dotProduct(double[] dArray) {
        double d = 0.0;
        if (dArray.length > 0) {
            for (int i = 0; i < this.count; ++i) {
                d += this.values[i] * dArray[(int)this.keys[i]];
            }
        }
        return d;
    }

    public double dotProduct(float[] fArray) {
        double d = 0.0;
        if (fArray.length > 0) {
            for (int i = 0; i < this.count; ++i) {
                d += this.values[i] * (double)fArray[(int)this.keys[i]];
            }
        }
        return d;
    }

    public void forEachEntry(IFn.LDO lDO) {
        int n = this.count;
        for (int i = 0; i < this.count; ++i) {
            lDO.invokePrim(this.keys[i], this.values[i]);
        }
        if (this.count != n) {
            throw new RuntimeException("You cannot add or remove items in a LongDoubleFeatureVector while iterating over it");
        }
    }

    @Override
    public Object reduce(IFn.OLDO oLDO, Object object) {
        for (int i = 0; i < this.count; ++i) {
            object = oLDO.invokePrim(object, this.keys[i], this.values[i]);
        }
        return object;
    }

    public LongDoubleFeatureVector mapKeys(IFn.LDL lDL) {
        LongDoubleFeatureVector longDoubleFeatureVector = new LongDoubleFeatureVector(this.count);
        for (int i = 0; i < this.count; ++i) {
            long l = lDL.invokePrim(this.keys[i], this.values[i]);
            longDoubleFeatureVector.put(l, this.values[i]);
        }
        return longDoubleFeatureVector;
    }

    public LongDoubleFeatureVector mapVals(IFn.LDD lDD) {
        LongDoubleFeatureVector longDoubleFeatureVector = new LongDoubleFeatureVector(this.count);
        for (int i = 0; i < this.count; ++i) {
            double d = lDD.invokePrim(this.keys[i], this.values[i]);
            longDoubleFeatureVector.put(this.keys[i], d);
        }
        return longDoubleFeatureVector;
    }

    public class FVIterator
    implements Iterator<Map.Entry<Long, Double>> {
        int i = 0;

        @Override
        public boolean hasNext() {
            return this.i < LongDoubleFeatureVector.this.count;
        }

        @Override
        public Map.Entry<Long, Double> next() {
            return new AbstractMap.SimpleEntry<Long, Double>(LongDoubleFeatureVector.this.keys[this.i], LongDoubleFeatureVector.this.values[this.i++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long key() {
            return LongDoubleFeatureVector.this.keys[this.i];
        }

        public double value() {
            return LongDoubleFeatureVector.this.values[this.i];
        }
    }
}

