/*
 * Decompiled with CFR 0.152.
 */
package flop;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.Seqable;
import java.io.Serializable;

public final class OrderedIntDoubleMapping
implements Serializable,
Seqable {
    static final double DEFAULT_VALUE = 0.0;
    public int[] indices;
    public double[] values;
    public int numMappings;

    OrderedIntDoubleMapping() {
        this(11);
    }

    public OrderedIntDoubleMapping(int n) {
        this.indices = new int[n];
        this.values = new double[n];
        this.numMappings = 0;
    }

    OrderedIntDoubleMapping(int[] nArray, double[] dArray, int n) {
        this.indices = nArray;
        this.values = dArray;
        this.numMappings = n;
    }

    public OrderedIntDoubleMapping(OrderedIntDoubleMapping orderedIntDoubleMapping) {
        this((int[])orderedIntDoubleMapping.indices.clone(), (double[])orderedIntDoubleMapping.values.clone(), orderedIntDoubleMapping.numMappings);
    }

    private void growTo(int n) {
        if (n > this.indices.length) {
            int[] nArray = new int[n];
            System.arraycopy(this.indices, 0, nArray, 0, this.numMappings);
            this.indices = nArray;
            double[] dArray = new double[n];
            System.arraycopy(this.values, 0, dArray, 0, this.numMappings);
            this.values = dArray;
        }
    }

    public int find(int n) {
        int n2 = 0;
        int n3 = this.numMappings - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2 >>> 1);
            int n5 = this.indices[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public double get(int n) {
        int n2 = this.find(n);
        return n2 >= 0 ? this.values[n2] : 0.0;
    }

    public void set(int n, double d) {
        int n2 = this.find(n);
        if (n2 >= 0) {
            if (d == 0.0) {
                int n3 = n2 + 1;
                int n4 = n2;
                while (n3 < this.numMappings) {
                    this.indices[n4] = this.indices[n3];
                    this.values[n4] = this.values[n3];
                    ++n3;
                    ++n4;
                }
                --this.numMappings;
            } else {
                this.values[n2] = d;
            }
        } else if (d != 0.0) {
            int n5;
            if (this.numMappings >= this.indices.length) {
                this.growTo(Math.max((int)(1.2 * (double)this.numMappings), this.numMappings + 1));
            }
            if (this.numMappings > (n5 = -n2 - 1)) {
                int n6 = this.numMappings - 1;
                int n7 = this.numMappings;
                while (n6 >= n5) {
                    this.indices[n7] = this.indices[n6];
                    this.values[n7] = this.values[n6];
                    --n6;
                    --n7;
                }
            }
            this.indices[n5] = n;
            this.values[n5] = d;
            ++this.numMappings;
        }
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.numMappings; ++i) {
            n = 31 * n + this.indices[i];
            n = 31 * n + (int)Double.doubleToRawLongBits(this.values[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof OrderedIntDoubleMapping) {
            OrderedIntDoubleMapping orderedIntDoubleMapping = (OrderedIntDoubleMapping)object;
            if (this.numMappings == orderedIntDoubleMapping.numMappings) {
                for (int i = 0; i < this.numMappings; ++i) {
                    if (this.indices[i] == orderedIntDoubleMapping.indices[i] && this.values[i] == orderedIntDoubleMapping.values[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10 * this.numMappings);
        for (int i = 0; i < this.numMappings; ++i) {
            stringBuilder.append('(');
            stringBuilder.append(this.indices[i]);
            stringBuilder.append(',');
            stringBuilder.append(this.values[i]);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public ISeq seq() {
        if (this.numMappings > 0) {
            return new Seq(this, 0);
        }
        return null;
    }

    static class Seq
    extends ASeq
    implements Counted {
        final OrderedIntDoubleMapping m;
        final int i;

        Seq(OrderedIntDoubleMapping orderedIntDoubleMapping, int n) {
            this.m = orderedIntDoubleMapping;
            this.i = n;
        }

        public Seq(IPersistentMap iPersistentMap, OrderedIntDoubleMapping orderedIntDoubleMapping, int n) {
            super(iPersistentMap);
            this.m = orderedIntDoubleMapping;
            this.i = n;
        }

        public Object first() {
            return new MapEntry((Object)this.m.indices[this.i], (Object)this.m.values[this.i]);
        }

        public ISeq next() {
            if (this.i < this.m.numMappings - 1) {
                return new Seq(this.m, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.m.numMappings - this.i;
        }

        public Obj withMeta(IPersistentMap iPersistentMap) {
            return new Seq(iPersistentMap, this.m, this.i);
        }
    }
}

