/*
 * Decompiled with CFR 0.152.
 */
package hiphip.double_;

import hiphip.IndexArrays;

public class Helpers {
    public static int maxIndex(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public static int minIndex(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static int partition(double[] dArray, int n, int n2, double d) {
        int n3 = n;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            while (d < dArray[i]) {
                if (--n4 == i) {
                    return n4;
                }
                Helpers.swap(dArray, n4, i);
            }
            if (!(dArray[i] < d)) continue;
            if (n3 < i) {
                Helpers.swap(dArray, n3, i);
            }
            ++n3;
        }
        return n4;
    }

    private static double choosePivot(double[] dArray, int n, int n2) {
        return dArray[(n + n2) / 2];
    }

    public static void select(double[] dArray, int n, int n2, int n3) {
        double d = Helpers.choosePivot(dArray, n, n2);
        int n4 = Helpers.partition(dArray, n, n2, d);
        if (n4 - n < n3) {
            Helpers.select(dArray, n4, n2, n3 - (n4 - n));
        } else if (n3 < n4 - n) {
            assert (d == dArray[--n4]);
            do {
                if (--n4 - n >= n3) continue;
                return;
            } while (dArray[n4] == d);
            Helpers.select(dArray, n, n4 + 1, n3);
        }
    }

    public static int partitionIndices(int[] nArray, double[] dArray, int n, int n2, double d) {
        int n3 = n;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            while (d < dArray[nArray[i]]) {
                if (--n4 == i) {
                    return n4;
                }
                IndexArrays.swap(nArray, n4, i);
            }
            if (!(dArray[nArray[i]] < d)) continue;
            if (n3 < i) {
                IndexArrays.swap(nArray, n3, i);
            }
            ++n3;
        }
        return n4;
    }

    private static double choosePivot(int[] nArray, double[] dArray, int n, int n2) {
        return dArray[nArray[(n + n2) / 2]];
    }

    public static void selectIndices(int[] nArray, double[] dArray, int n, int n2, int n3) {
        double d = Helpers.choosePivot(nArray, dArray, n, n2);
        int n4 = Helpers.partitionIndices(nArray, dArray, n, n2, d);
        if (n4 - n < n3) {
            Helpers.selectIndices(nArray, dArray, n4, n2, n3 - (n4 - n));
        } else if (n3 < n4 - n) {
            assert (d == dArray[nArray[--n4]]);
            do {
                if (--n4 - n >= n3) continue;
                return;
            } while (dArray[nArray[n4]] == d);
            Helpers.selectIndices(nArray, dArray, n, n4 + 1, n3);
        }
    }

    public static void sortIndices(int[] nArray, double[] dArray, int n, int n2) {
        double d = Helpers.choosePivot(nArray, dArray, n, n2);
        int n3 = Helpers.partitionIndices(nArray, dArray, n, n2, d);
        if (n3 + 1 < n2) {
            Helpers.sortIndices(nArray, dArray, n3, n2);
        }
        assert (d == dArray[nArray[--n3]]);
        do {
            if (--n3 > n) continue;
            return;
        } while (dArray[nArray[n3]] == d);
        Helpers.sortIndices(nArray, dArray, n, n3 + 1);
    }
}

