/*
 * Decompiled with CFR 0.152.
 */
package plumbing;

import clojure.lang.BigInt;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.ITransientMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Ratio;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class JsonExt {
    public static void generate(JsonGenerator jsonGenerator, Map map, Object object) throws Exception {
        Generator generator = new Generator(jsonGenerator, map);
        generator.generate(object);
    }

    public static Object parse(JsonParser jsonParser, boolean bl, boolean bl2, Object object) throws Exception {
        if (bl) {
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == null) {
                return object;
            }
        }
        switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                ITransientMap iTransientMap = PersistentArrayMap.EMPTY.asTransient();
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
                    String string = jsonParser.getText();
                    jsonParser.nextToken();
                    String string2 = bl2 ? Keyword.intern((String)string) : string;
                    iTransientMap = iTransientMap.assoc((Object)string2, JsonExt.parse(jsonParser, false, bl2, object));
                    jsonParser.nextToken();
                }
                return iTransientMap.persistent();
            }
            case START_ARRAY: {
                PersistentVector.TransientVector transientVector = PersistentVector.EMPTY.asTransient();
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    transientVector = transientVector.conj(JsonExt.parse(jsonParser, false, bl2, object));
                    jsonParser.nextToken();
                }
                return transientVector.persistent();
            }
            case VALUE_STRING: {
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (jsonParser.getNumberType() == JsonParser.NumberType.BIG_INTEGER) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getLongValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new Exception("Cannot parse " + jsonParser.getCurrentToken());
    }

    public static class Generator {
        final JsonGenerator jg;
        final Map coercions;

        public Generator(JsonGenerator jsonGenerator, Map map) {
            this.jg = jsonGenerator;
            this.coercions = map;
        }

        public Object coercionKey(Object object) {
            if (object != null) {
                return object.getClass();
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void generate(Object object) throws Exception {
            Object object2;
            if (this.coercions != null) {
                while ((object2 = (IFn)this.coercions.get(this.coercionKey(object))) != null) {
                    object = object2.invoke(object);
                }
            }
            if (object instanceof String) {
                this.jg.writeString((String)object);
                return;
            } else if (object instanceof Number) {
                if (object instanceof Integer) {
                    this.jg.writeNumber(((Integer)object).intValue());
                    return;
                } else if (object instanceof Long) {
                    this.jg.writeNumber(((Long)object).longValue());
                    return;
                } else if (object instanceof BigInteger) {
                    this.jg.writeNumber((BigInteger)object);
                    return;
                } else if (object instanceof BigInt) {
                    this.jg.writeNumber(((BigInt)object).toBigInteger());
                    return;
                } else if (object instanceof Ratio) {
                    object2 = (Ratio)object;
                    Double d = new Double(object2.doubleValue());
                    this.jg.writeNumber(d.doubleValue());
                    return;
                } else if (object instanceof Double) {
                    this.jg.writeNumber(((Double)object).doubleValue());
                    return;
                } else if (object instanceof Float) {
                    this.jg.writeNumber(((Float)object).floatValue());
                    return;
                } else {
                    if (!(object instanceof BigDecimal)) throw new Exception("Cannot generate number " + object);
                    this.jg.writeNumber((BigDecimal)object);
                }
                return;
            } else if (object instanceof Boolean) {
                this.jg.writeBoolean(((Boolean)object).booleanValue());
                return;
            } else if (object == null) {
                this.jg.writeNull();
                return;
            } else if (object instanceof Keyword) {
                this.jg.writeString(((Keyword)object).getName());
                return;
            } else if (object instanceof Map) {
                object2 = (Map)object;
                this.jg.writeStartObject();
                for (Map.Entry entry : object2.entrySet()) {
                    Object k = entry.getKey();
                    if (k instanceof Keyword) {
                        this.jg.writeFieldName(((Keyword)k).getName());
                    } else {
                        this.jg.writeFieldName(k.toString());
                    }
                    this.generate(entry.getValue());
                }
                this.jg.writeEndObject();
                return;
            } else if (object instanceof Iterable) {
                this.jg.writeStartArray();
                for (Object e : (Iterable)object) {
                    this.generate(e);
                }
                this.jg.writeEndArray();
                return;
            } else {
                if (!(object instanceof IDeref)) throw new Exception("Cannot generate " + object);
                this.generate(((IDeref)object).deref());
            }
        }
    }
}

