/*
 * Decompiled with CFR 0.152.
 */
package plumbing;

public final class MurmurHash {
    private MurmurHash() {
    }

    public static int hash32(byte[] byArray, int n, int n2) {
        int n3 = n2 ^ n;
        int n4 = n / 4;
        for (int i = 0; i < n4; ++i) {
            int n5 = i * 4;
            int n6 = (byArray[n5 + 0] & 0xFF) + ((byArray[n5 + 1] & 0xFF) << 8) + ((byArray[n5 + 2] & 0xFF) << 16) + ((byArray[n5 + 3] & 0xFF) << 24);
            n6 *= 1540483477;
            n6 ^= n6 >>> 24;
            n3 *= 1540483477;
            n3 ^= (n6 *= 1540483477);
        }
        switch (n % 4) {
            case 3: {
                n3 ^= (byArray[(n & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                n3 ^= (byArray[(n & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                n3 ^= byArray[n & 0xFFFFFFFC] & 0xFF;
                n3 *= 1540483477;
            }
        }
        n3 ^= n3 >>> 13;
        n3 *= 1540483477;
        n3 ^= n3 >>> 15;
        return n3;
    }

    public static int hash32(byte[] byArray, int n) {
        return MurmurHash.hash32(byArray, n, -1756908916);
    }

    public static int hash32(String string) {
        byte[] byArray = string.getBytes();
        return MurmurHash.hash32(byArray, byArray.length);
    }

    public static int hash32(String string, int n, int n2) {
        return MurmurHash.hash32(string.substring(n, n + n2));
    }

    public static long hash64(byte[] byArray, int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL ^ (long)n * -4132994306676758123L;
        int n3 = n / 8;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * 8;
            long l2 = ((long)byArray[n4 + 0] & 0xFFL) + (((long)byArray[n4 + 1] & 0xFFL) << 8) + (((long)byArray[n4 + 2] & 0xFFL) << 16) + (((long)byArray[n4 + 3] & 0xFFL) << 24) + (((long)byArray[n4 + 4] & 0xFFL) << 32) + (((long)byArray[n4 + 5] & 0xFFL) << 40) + (((long)byArray[n4 + 6] & 0xFFL) << 48) + (((long)byArray[n4 + 7] & 0xFFL) << 56);
            l2 *= -4132994306676758123L;
            l2 ^= l2 >>> 47;
            l ^= (l2 *= -4132994306676758123L);
            l *= -4132994306676758123L;
        }
        switch (n % 8) {
            case 7: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                l ^= (long)(byArray[(n & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                l ^= (long)(byArray[n & 0xFFFFFFF8] & 0xFF);
                l *= -4132994306676758123L;
            }
        }
        l ^= l >>> 47;
        l *= -4132994306676758123L;
        l ^= l >>> 47;
        return l;
    }

    public static long hash64(byte[] byArray, int n) {
        return MurmurHash.hash64(byArray, n, -512093083);
    }

    public static long hash64(String string) {
        byte[] byArray = string.getBytes();
        return MurmurHash.hash64(byArray, byArray.length);
    }

    public static long hash64(String string, int n, int n2) {
        return MurmurHash.hash64(string.substring(n, n + n2));
    }
}

