/*
 * Decompiled with CFR 0.152.
 */
package plumbing;

import clojure.lang.AFn;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.Util;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SaneExecutorService
extends ThreadPoolExecutor {
    public SaneExecutorService(int n, int n2, long l, BlockingQueue blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, TimeUnit.MILLISECONDS, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new WeightedFutureTask((AFn)callable);
    }

    protected RunnableFuture newTaskFor(Runnable runnable, Object object) {
        throw new UnsupportedOperationException("please come back with Callable");
    }

    public static class WeightedFutureTask
    extends FutureTask
    implements Comparable<WeightedFutureTask> {
        private AFn callback;
        public final double priority;

        public WeightedFutureTask(AFn aFn) {
            super(aFn);
            IPersistentMap iPersistentMap = ((IMeta)aFn).meta();
            if (iPersistentMap != null) {
                this.callback = (AFn)iPersistentMap.valAt((Object)Keyword.intern((String)"callback"));
                this.priority = (Double)iPersistentMap.valAt((Object)Keyword.intern((String)"priority"), (Object)Double.NaN);
            } else {
                this.priority = Double.NaN;
            }
        }

        @Override
        protected void done() {
            try {
                if (!this.isCancelled() && this.callback != null) {
                    this.callback.invoke(this.get());
                }
            }
            catch (Throwable throwable) {
                Util.sneakyThrow((Throwable)throwable);
            }
        }

        @Override
        public int compareTo(WeightedFutureTask weightedFutureTask) {
            if (weightedFutureTask.priority > this.priority) {
                return 1;
            }
            if (weightedFutureTask.priority < this.priority) {
                return -1;
            }
            if (weightedFutureTask.priority == this.priority) {
                return 0;
            }
            throw new UnsupportedOperationException("attempted to compare when no comparison was valid:" + weightedFutureTask.priority + ", " + this.priority);
        }
    }
}

