/*
 * Decompiled with CFR 0.152.
 */
package plumbing;

import clojure.lang.ISeq;
import java.io.InputStream;

public class SeqInputStream
extends InputStream {
    public ISeq byteArraySeq;
    public int offset;

    private void advance() {
        while (this.byteArraySeq != null && this.offset == ((byte[])this.byteArraySeq.first()).length) {
            this.byteArraySeq = this.byteArraySeq.next();
            this.offset = 0;
        }
    }

    public SeqInputStream(ISeq iSeq) {
        this.byteArraySeq = iSeq;
        this.offset = 0;
        this.advance();
    }

    @Override
    public int read() {
        if (this.byteArraySeq == null) {
            return -1;
        }
        byte[] byArray = (byte[])this.byteArraySeq.first();
        byte by = byArray[this.offset];
        ++this.offset;
        this.advance();
        return by;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (this.byteArraySeq == null) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2 && this.byteArraySeq != null) {
            byte[] byArray2 = (byte[])this.byteArraySeq.first();
            int n4 = Math.min(n2 - n3, byArray2.length - this.offset);
            System.arraycopy(byArray2, this.offset, byArray, n + n3, n4);
            n3 += n4;
            this.offset += n4;
            this.advance();
        }
        return n3;
    }
}

