/*
 * Decompiled with CFR 0.152.
 */
package plumbing;

import clojure.lang.ArraySeq;
import clojure.lang.BigInt;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Seqable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class Serializer {
    private static final byte KEYWORD_TYPE = 0;
    private static final byte STRING_TYPE = 1;
    private static final byte INTEGER_TYPE = 2;
    private static final byte LONG_TYPE = 3;
    private static final byte BIG_INTEGER_TYPE = 4;
    private static final byte DOUBLE_TYPE = 5;
    private static final byte BOOLEAN_TYPE = 6;
    private static final byte CHAR_TYPE = 7;
    private static final byte NIL_TYPE = 8;
    private static final byte BINARY_TYPE = 9;
    private static final byte MAP_TYPE = 10;
    private static final byte VECTOR_TYPE = 11;
    private static final byte LIST_TYPE = 12;
    private static final byte SET_TYPE = 13;
    private static final byte FLOAT_TYPE = 14;
    private static final byte SERIALIZABLE_TYPE = 15;
    private static final byte BIG_INT_TYPE = 16;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] objectToBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object bytesToObject(byte[] byArray) throws Exception {
        return new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
    }

    public static void serialize(DataOutput dataOutput, Object object) throws IOException {
        if (object instanceof Keyword) {
            Keyword keyword = (Keyword)object;
            String string = keyword.getNamespace();
            byte[] byArray = string != null ? string.getBytes(UTF_8) : null;
            int n = string != null ? byArray.length + 1 : 0;
            byte[] byArray2 = keyword.getName().getBytes(UTF_8);
            dataOutput.writeByte(0);
            dataOutput.writeInt(n += byArray2.length);
            if (string != null) {
                dataOutput.write(byArray, 0, byArray.length);
                dataOutput.writeByte(47);
            }
            dataOutput.write(byArray2, 0, byArray2.length);
        } else if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = string.getBytes(UTF_8);
            int n = byArray.length;
            dataOutput.writeByte(1);
            dataOutput.writeInt(n);
            dataOutput.write(byArray, 0, n);
        } else if (object instanceof Integer) {
            dataOutput.writeByte(2);
            dataOutput.writeInt((Integer)object);
        } else if (object instanceof Long) {
            dataOutput.writeByte(3);
            dataOutput.writeLong((Long)object);
        } else if (object instanceof BigInteger) {
            byte[] byArray = ((BigInteger)object).toByteArray();
            int n = byArray.length;
            dataOutput.writeByte(4);
            dataOutput.writeInt(n);
            dataOutput.write(byArray, 0, n);
        } else if (object instanceof BigInt) {
            dataOutput.writeByte(16);
            BigInt bigInt = (BigInt)object;
            Serializer.serialize(dataOutput, bigInt.toBigInteger());
        } else if (object instanceof Float) {
            dataOutput.writeByte(14);
            dataOutput.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            dataOutput.writeByte(5);
            dataOutput.writeDouble((Double)object);
        } else if (object instanceof Boolean) {
            dataOutput.writeByte(6);
            dataOutput.writeBoolean((Boolean)object);
        } else if (object == null) {
            dataOutput.writeByte(8);
        } else if (object instanceof IPersistentMap) {
            IPersistentMap iPersistentMap = (IPersistentMap)object;
            dataOutput.writeByte(10);
            dataOutput.writeInt(iPersistentMap.count());
            for (ISeq iSeq = iPersistentMap.seq(); iSeq != null; iSeq = iSeq.next()) {
                IMapEntry iMapEntry = (IMapEntry)iSeq.first();
                Serializer.serialize(dataOutput, iMapEntry.key());
                Serializer.serialize(dataOutput, iMapEntry.val());
            }
        } else if (object instanceof IPersistentSet) {
            IPersistentSet iPersistentSet = (IPersistentSet)object;
            dataOutput.writeByte(13);
            dataOutput.writeInt(iPersistentSet.count());
            for (ISeq iSeq = iPersistentSet.seq(); iSeq != null; iSeq = iSeq.next()) {
                Serializer.serialize(dataOutput, iSeq.first());
            }
        } else if (object instanceof IPersistentVector) {
            IPersistentVector iPersistentVector = (IPersistentVector)object;
            int n = iPersistentVector.count();
            dataOutput.writeByte(11);
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Serializer.serialize(dataOutput, iPersistentVector.nth(i));
            }
        } else if (object instanceof IPersistentList || object instanceof ISeq) {
            ISeq iSeq = ((Seqable)object).seq();
            int n = iSeq == null ? 0 : iSeq.count();
            dataOutput.writeByte(12);
            dataOutput.writeInt(n);
            while (iSeq != null) {
                Serializer.serialize(dataOutput, iSeq.first());
                iSeq = iSeq.next();
            }
        } else if (object instanceof Serializable) {
            byte[] byArray = Serializer.objectToBytes(object);
            dataOutput.writeByte(15);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        } else {
            throw new IOException("Cannot serialize " + object);
        }
    }

    public static Object deserialize(DataInput dataInput) throws Exception {
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray, 0, n);
                String string = new String(byArray, UTF_8);
                Keyword keyword = Keyword.find(null, (String)string);
                return keyword != null ? keyword : Keyword.intern((String)string);
            }
            case 1: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray, 0, n);
                return new String(byArray, UTF_8);
            }
            case 2: {
                return dataInput.readInt();
            }
            case 3: {
                return dataInput.readLong();
            }
            case 4: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray, 0, n);
                return new BigInteger(byArray);
            }
            case 16: {
                BigInteger bigInteger = (BigInteger)Serializer.deserialize(dataInput);
                return BigInt.fromBigInteger((BigInteger)bigInteger);
            }
            case 14: {
                return Float.valueOf(dataInput.readFloat());
            }
            case 5: {
                return dataInput.readDouble();
            }
            case 6: {
                return dataInput.readBoolean();
            }
            case 8: {
                return null;
            }
            case 10: {
                int n = dataInput.readInt() * 2;
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Serializer.deserialize(dataInput);
                }
                return RT.map((Object[])objectArray);
            }
            case 11: {
                int n = dataInput.readInt();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Serializer.deserialize(dataInput);
                }
                return LazilyPersistentVector.createOwning((Object[])objectArray);
            }
            case 13: {
                int n = dataInput.readInt();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Serializer.deserialize(dataInput);
                }
                return RT.set((Object[])objectArray);
            }
            case 12: {
                int n = dataInput.readInt();
                if (n == 0) {
                    return PersistentList.EMPTY;
                }
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Serializer.deserialize(dataInput);
                }
                return ArraySeq.create((Object[])objectArray);
            }
            case 15: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                return Serializer.bytesToObject(byArray);
            }
        }
        throw new IOException("Cannot deserialize " + by);
    }
}

