/*
 * Decompiled with CFR 0.152.
 */
package web;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class GlobalTimeoutHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    final Timer timer;
    final long timeoutMillis;
    volatile Timeout timeout;
    private volatile ReadTimeoutTask task;
    volatile long lastReadTime;

    public GlobalTimeoutHandler(Timer timer, int n) {
        this(timer, n, TimeUnit.SECONDS);
    }

    public GlobalTimeoutHandler(Timer timer, long l, TimeUnit timeUnit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.timeoutMillis = l <= 0L ? 0L : Math.max(timeUnit.toMillis(l), 1L);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    public void beforeAdd(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.getPipeline().isAttached()) {
            this.initialize(channelHandlerContext);
        }
    }

    public void afterAdd(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.destroy();
    }

    public void afterRemove(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void channelOpen(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.initialize(channelHandlerContext);
        channelHandlerContext.sendUpstream((ChannelEvent)channelStateEvent);
    }

    private void initialize(ChannelHandlerContext channelHandlerContext) {
        this.task = new ReadTimeoutTask(channelHandlerContext);
        if (this.timeoutMillis > 0L) {
            this.timeout = this.timer.newTimeout((TimerTask)this.task, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void destroy() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.timeout = null;
        this.task = null;
    }

    private final class ReadTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        ReadTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            Channels.fireExceptionCaught((ChannelHandlerContext)this.ctx, (Throwable)new RuntimeException("Global timeout"));
        }
    }
}

