/*
 * Decompiled with CFR 0.152.
 */
package web;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.util.CharsetUtil;

public class HTTPBoundedChunkAggregator
extends SimpleChannelUpstreamHandler {
    private static final ChannelBuffer CONTINUE = ChannelBuffers.copiedBuffer((CharSequence)"HTTP/1.1 100 Continue\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private final int maxContentLength;
    private HttpMessage currentMessage;
    private boolean stoppedEarly = false;

    public HTTPBoundedChunkAggregator(int n) {
        this.maxContentLength = n;
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        Object object = messageEvent.getMessage();
        HttpMessage httpMessage = this.currentMessage;
        if (object instanceof HttpMessage) {
            HttpMessage httpMessage2 = (HttpMessage)object;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)httpMessage2)) {
                Channels.write((ChannelHandlerContext)channelHandlerContext, (ChannelFuture)Channels.succeededFuture((Channel)channelHandlerContext.getChannel()), (Object)CONTINUE.duplicate());
            }
            if (httpMessage2.isChunked()) {
                List list = httpMessage2.getHeaders("Transfer-Encoding");
                list.remove("chunked");
                if (list.isEmpty()) {
                    httpMessage2.removeHeader("Transfer-Encoding");
                }
                httpMessage2.setChunked(false);
                httpMessage2.setContent(ChannelBuffers.dynamicBuffer((ChannelBufferFactory)messageEvent.getChannel().getConfig().getBufferFactory()));
                this.currentMessage = httpMessage2;
            } else {
                this.currentMessage = null;
                channelHandlerContext.sendUpstream((ChannelEvent)messageEvent);
            }
        } else if (object instanceof HttpChunk) {
            if (this.stoppedEarly) {
                return;
            }
            if (httpMessage == null) {
                throw new IllegalStateException("received " + HttpChunk.class.getSimpleName() + " without " + HttpMessage.class.getSimpleName());
            }
            HttpChunk httpChunk = (HttpChunk)object;
            ChannelBuffer channelBuffer = httpMessage.getContent();
            channelBuffer.writeBytes(httpChunk.getContent());
            boolean bl = this.stoppedEarly = this.maxContentLength >= 0 && channelBuffer.readableBytes() >= this.maxContentLength;
            if (httpChunk.isLast() || this.stoppedEarly) {
                this.currentMessage = null;
                if (httpChunk instanceof HttpChunkTrailer) {
                    HttpChunkTrailer httpChunkTrailer = (HttpChunkTrailer)httpChunk;
                    for (Map.Entry entry : httpChunkTrailer.getHeaders()) {
                        httpMessage.setHeader((String)entry.getKey(), entry.getValue());
                    }
                }
                httpMessage.setHeader("Content-Length", (Object)String.valueOf(channelBuffer.readableBytes()));
                Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)httpMessage, (SocketAddress)messageEvent.getRemoteAddress());
                if (this.stoppedEarly) {
                    messageEvent.getChannel().close();
                }
            }
        } else {
            channelHandlerContext.sendUpstream((ChannelEvent)messageEvent);
        }
    }
}

