/*
 * Decompiled with CFR 0.152.
 */
package franklin;

import SimpleOpenNI.ContextWrapper;
import SimpleOpenNI.SimpleOpenNIConstants;
import SimpleOpenNI.StrVector;
import SimpleOpenNI.XnPoint3D;
import SimpleOpenNI.XnSkeletonJointOrientation;
import SimpleOpenNI.XnSkeletonJointPosition;
import SimpleOpenNI.XnVector3D;
import clojure.lang.IFn;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class Ben
extends ContextWrapper
implements SimpleOpenNIConstants {
    protected IFn _newUserFn;
    protected IFn _lostUserFn;
    protected IFn _startCalibrationFn;
    protected IFn _endCalibrationFn;
    protected IFn _startPoseFn;
    protected IFn _endPoseFn;
    protected IFn _createHandsFn;
    protected IFn _updateHandsFn;
    protected IFn _destroyHandsFn;
    protected IFn _recognizeGestureFn;
    protected IFn _progressGestureFn;
    protected IFn _startSessionFn;
    protected IFn _endSessionFn;
    protected IFn _focusSessionFn;
    protected String _filename;
    protected PImage _depthImage;
    protected int[] _depthRaw;
    protected PVector[] _depthMapRealWorld;
    protected XnPoint3D[] _depthMapRealWorldXn;
    protected PImage _rgbImage;
    protected PImage _irImage;
    protected PImage _sceneImage;
    protected int[] _sceneRaw;
    protected int[] _userRaw;
    protected long _depthMapTimeStamp;
    protected long _depthImageTimeStamp;
    protected long _depthRealWorldTimeStamp;
    protected long _rgbTimeStamp;
    protected long _irImageTimeStamp;
    protected long _sceneMapTimeStamp;
    protected long _sceneImageTimeStamp;
    protected static boolean _initFlag;

    public static void start() {
        if (_initFlag) {
            return;
        }
        _initFlag = true;
        Ben.initContext();
    }

    public static int deviceCount() {
        Ben.start();
        return ContextWrapper.deviceCount();
    }

    public static int deviceNames(StrVector strVector) {
        Ben.start();
        return ContextWrapper.deviceNames((StrVector)strVector);
    }

    public Ben() {
        this.initVars();
        this.init();
    }

    public Ben(int n) {
        this.initVars();
        this.init(n, RUN_MODE_SINGLE_THREADED);
    }

    protected void initVars() {
        this._depthMapTimeStamp = -1L;
        this._depthImageTimeStamp = -1L;
        this._depthRealWorldTimeStamp = -1L;
        this._rgbTimeStamp = -1L;
        this._irImageTimeStamp = -1L;
        this._sceneMapTimeStamp = -1L;
        this._sceneImageTimeStamp = -1L;
        this._newUserFn = null;
        this._lostUserFn = null;
        this._startCalibrationFn = null;
        this._endCalibrationFn = null;
        this._startPoseFn = null;
        this._endPoseFn = null;
        this._createHandsFn = null;
        this._updateHandsFn = null;
        this._destroyHandsFn = null;
    }

    public void dispose() {
        this.close();
    }

    public void finalize() {
        this.close();
    }

    private void setupDepth() {
        this._depthImage = new PImage(this.depthWidth(), this.depthHeight(), 1);
        this._depthRaw = new int[this.depthMapSize()];
        this._depthMapRealWorld = new PVector[this.depthMapSize()];
        this._depthMapRealWorldXn = new XnPoint3D[this.depthMapSize()];
        for (int i = 0; i < this.depthMapSize(); ++i) {
            this._depthMapRealWorld[i] = new PVector();
            this._depthMapRealWorldXn[i] = new XnPoint3D();
        }
    }

    public boolean enableDepth() {
        if (super.enableDepth()) {
            this.setupDepth();
            return true;
        }
        return false;
    }

    public boolean enableDepth(int n, int n2, int n3) {
        if (super.enableDepth(n, n2, n3)) {
            this.setupDepth();
            return true;
        }
        return false;
    }

    public PImage depthImage() {
        this.updateDepthImage();
        return this._depthImage;
    }

    public int[] depthMap() {
        this.updateDepthRaw();
        return this._depthRaw;
    }

    public PVector[] depthMapRealWorld() {
        this.updateDepthRealWorld();
        return this._depthMapRealWorld;
    }

    private void setupRGB() {
        this._rgbImage = new PImage(this.rgbWidth(), this.rgbHeight(), 1);
    }

    public boolean enableRGB() {
        if (super.enableRGB()) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    public boolean enableRGB(int n, int n2, int n3) {
        if (super.enableRGB(n, n2, n3)) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    public PImage rgbImage() {
        this.updateImage();
        return this._rgbImage;
    }

    private void setupIR() {
        this._irImage = new PImage(this.irWidth(), this.irHeight(), 1);
    }

    public boolean enableIR() {
        if (super.enableIR()) {
            this.setupIR();
            return true;
        }
        return false;
    }

    public boolean enableIR(int n, int n2, int n3) {
        if (super.enableIR(n, n2, n3)) {
            this.setupIR();
            return true;
        }
        return false;
    }

    public PImage irImage() {
        this.updateIrImage();
        return this._irImage;
    }

    private void setupScene() {
        this._sceneImage = new PImage(this.sceneWidth(), this.sceneHeight(), 1);
        this._sceneRaw = new int[this.sceneWidth() * this.sceneHeight()];
    }

    public boolean enableScene() {
        if (super.enableScene()) {
            this.setupScene();
            return true;
        }
        return false;
    }

    public boolean enableScene(int n, int n2, int n3) {
        if (super.enableScene(n, n2, n3)) {
            this.setupScene();
            return true;
        }
        return false;
    }

    public PImage sceneImage() {
        this.updateSceneImage();
        return this._sceneImage;
    }

    public int[] sceneMap() {
        this.updateSceneRaw();
        return this._sceneRaw;
    }

    public void getSceneFloor(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        super.getSceneFloor(xnVector3D, xnVector3D2);
        pVector.set(xnVector3D.getX(), xnVector3D.getY(), xnVector3D.getZ());
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    public void onNewUser(IFn iFn) {
        this._newUserFn = iFn;
    }

    public void onLostUser(IFn iFn) {
        this._lostUserFn = iFn;
    }

    public void onStartCalibration(IFn iFn) {
        this._startCalibrationFn = iFn;
    }

    public void onEndCalibration(IFn iFn) {
        this._endCalibrationFn = iFn;
    }

    public void onStartPose(IFn iFn) {
        this._startPoseFn = iFn;
    }

    public void onEndPose(IFn iFn) {
        this._endPoseFn = iFn;
    }

    public boolean enableUser(int n) {
        if (super.enableUser(n)) {
            this._userRaw = new int[this.userWidth() * this.userHeight()];
            return true;
        }
        return false;
    }

    public int[] getUsersPixels(int n) {
        int n2 = this.userWidth() * this.userHeight();
        if (n2 == 0) {
            return this._userRaw;
        }
        if (this._userRaw.length != this.userWidth() * this.userHeight()) {
            this._userRaw = new int[this.userWidth() * this.userHeight()];
        }
        super.getUserPixels(n, this._userRaw);
        return this._userRaw;
    }

    public boolean getCoM(int n, PVector pVector) {
        XnPoint3D xnPoint3D = new XnPoint3D();
        boolean bl = super.getCoM(n, xnPoint3D);
        pVector.set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
        return bl;
    }

    public void onCreateHands(IFn iFn) {
        this._createHandsFn = iFn;
    }

    public void onUpdateHands(IFn iFn) {
        this._updateHandsFn = iFn;
    }

    public void onDestroyHands(IFn iFn) {
        this._destroyHandsFn = iFn;
    }

    public boolean enableHands() {
        return super.enableHands();
    }

    public void startTrackingHands(PVector pVector) {
        XnVector3D xnVector3D = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        super.startTrackingHands(xnVector3D);
    }

    public void onRecognizeGesture(IFn iFn) {
        this._recognizeGestureFn = iFn;
    }

    public void onProgressGesture(IFn iFn) {
        this._progressGestureFn = iFn;
    }

    public boolean enableGesture() {
        return super.enableGesture();
    }

    protected void updateDepthRaw() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthMapTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMap(this._depthRaw);
        this._depthMapTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthImage() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._depthImage.loadPixels();
        this.depthImage(this._depthImage.pixels);
        this._depthImage.updatePixels();
        this._depthImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthRealWorld() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthRealWorldTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMapRealWorld(this._depthMapRealWorldXn);
        for (int i = 0; i < this._depthMapRealWorldXn.length; ++i) {
            XnPoint3D xnPoint3D = this._depthMapRealWorldXn[i];
            this._depthMapRealWorld[i].set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
        }
        this._depthRealWorldTimeStamp = this.updateTimeStamp();
    }

    protected void updateImage() {
        if ((this.nodes() & NODE_IMAGE) == 0) {
            return;
        }
        if (this._rgbTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._rgbImage.loadPixels();
        this.rgbImage(this._rgbImage.pixels);
        this._rgbImage.updatePixels();
        this._rgbTimeStamp = this.updateTimeStamp();
    }

    protected void updateIrImage() {
        if ((this.nodes() & NODE_IR) == 0) {
            return;
        }
        if (this._irImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._irImage.loadPixels();
        this.irImage(this._irImage.pixels);
        this._irImage.updatePixels();
        this._irImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateSceneRaw() {
        if ((this.nodes() & NODE_SCENE) == 0) {
            return;
        }
        if (this._sceneMapTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.sceneMap(this._sceneRaw);
        this._sceneMapTimeStamp = this.updateTimeStamp();
    }

    protected void updateSceneImage() {
        if ((this.nodes() & NODE_SCENE) == 0) {
            return;
        }
        if (this._sceneImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._sceneImage.loadPixels();
        this.sceneImage(this._sceneImage.pixels);
        this._sceneImage.updatePixels();
        this._sceneImageTimeStamp = this.updateTimeStamp();
    }

    public void update() {
        super.update();
    }

    public void drawLimb(PApplet pApplet, int n, int n2, int n3) {
        if (!this.isCalibratedSkeleton(n)) {
            return;
        }
        if (!this.isTrackingSkeleton(n)) {
            return;
        }
        XnSkeletonJointPosition xnSkeletonJointPosition = new XnSkeletonJointPosition();
        XnSkeletonJointPosition xnSkeletonJointPosition2 = new XnSkeletonJointPosition();
        this.getJointPositionSkeleton(n, n2, xnSkeletonJointPosition);
        this.getJointPositionSkeleton(n, n3, xnSkeletonJointPosition2);
        if ((double)xnSkeletonJointPosition.getFConfidence() < 0.5 || (double)xnSkeletonJointPosition2.getFConfidence() < 0.5) {
            return;
        }
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        this.convertRealWorldToProjective(xnSkeletonJointPosition.getPosition(), xnVector3D);
        this.convertRealWorldToProjective(xnSkeletonJointPosition2.getPosition(), xnVector3D2);
        pApplet.line(xnVector3D.getX(), xnVector3D.getY(), xnVector3D2.getX(), xnVector3D2.getY());
    }

    public float getJointPositionSkeleton(int n, int n2, PVector pVector) {
        if (!this.isCalibratedSkeleton(n)) {
            return 0.0f;
        }
        if (!this.isTrackingSkeleton(n)) {
            return 0.0f;
        }
        XnSkeletonJointPosition xnSkeletonJointPosition = new XnSkeletonJointPosition();
        this.getJointPositionSkeleton(n, n2, xnSkeletonJointPosition);
        pVector.set(xnSkeletonJointPosition.getPosition().getX(), xnSkeletonJointPosition.getPosition().getY(), xnSkeletonJointPosition.getPosition().getZ());
        return xnSkeletonJointPosition.getFConfidence();
    }

    public float getJointOrientationSkeleton(int n, int n2, PMatrix3D pMatrix3D) {
        if (!this.isCalibratedSkeleton(n)) {
            return 0.0f;
        }
        if (!this.isTrackingSkeleton(n)) {
            return 0.0f;
        }
        XnSkeletonJointOrientation xnSkeletonJointOrientation = new XnSkeletonJointOrientation();
        this.getJointOrientationSkeleton(n, n2, xnSkeletonJointOrientation);
        float[] fArray = xnSkeletonJointOrientation.getOrientation().getElements();
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        return xnSkeletonJointOrientation.getFConfidence();
    }

    public void convertRealWorldToProjective(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        this.convertRealWorldToProjective(xnVector3D, xnVector3D2);
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    public void convertProjectiveToRealWorld(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        this.convertProjectiveToRealWorld(xnVector3D, xnVector3D2);
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    public void drawCamFrustum(PApplet pApplet) {
        pApplet.g.pushStyle();
        pApplet.stroke(200.0f, 200.0f, 0.0f);
        pApplet.noFill();
        pApplet.g.beginShape();
        pApplet.g.vertex(135.0f, 20.0f, 0.0f);
        pApplet.g.vertex(-135.0f, 20.0f, 0.0f);
        pApplet.g.vertex(-135.0f, -20.0f, 0.0f);
        pApplet.g.vertex(135.0f, -20.0f, 0.0f);
        pApplet.g.endShape(2);
        pApplet.g.beginShape();
        pApplet.g.vertex(110.0f, 20.0f, -50.0f);
        pApplet.g.vertex(-110.0f, 20.0f, -50.0f);
        pApplet.g.vertex(-110.0f, -20.0f, -50.0f);
        pApplet.g.vertex(110.0f, -20.0f, -50.0f);
        pApplet.g.endShape(2);
        pApplet.g.beginShape(4);
        pApplet.g.vertex(135.0f, 20.0f, 0.0f);
        pApplet.g.vertex(110.0f, 20.0f, -50.0f);
        pApplet.g.vertex(-135.0f, 20.0f, 0.0f);
        pApplet.g.vertex(-110.0f, 20.0f, -50.0f);
        pApplet.g.vertex(-135.0f, -20.0f, 0.0f);
        pApplet.g.vertex(-110.0f, -20.0f, -50.0f);
        pApplet.g.vertex(135.0f, -20.0f, 0.0f);
        pApplet.g.vertex(110.0f, -20.0f, -50.0f);
        pApplet.g.endShape();
        pApplet.stroke(200.0f, 200.0f, 0.0f, 50.0f);
        pApplet.g.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f);
        float f = 10000.0f;
        float f2 = f * PApplet.tan((float)(this.hFieldOfView() * 0.5f));
        float f3 = f * PApplet.tan((float)(this.vFieldOfView() * 0.5f));
        pApplet.stroke(200.0f, 200.0f, 0.0f, 100.0f);
        pApplet.g.line(0.0f, 0.0f, 0.0f, f2, f3, f);
        pApplet.g.line(0.0f, 0.0f, 0.0f, -f2, f3, f);
        pApplet.g.line(0.0f, 0.0f, 0.0f, f2, -f3, f);
        pApplet.g.line(0.0f, 0.0f, 0.0f, -f2, -f3, f);
        pApplet.g.beginShape();
        pApplet.g.vertex(f2, f3, f);
        pApplet.g.vertex(-f2, f3, f);
        pApplet.g.vertex(-f2, -f3, f);
        pApplet.g.vertex(f2, -f3, f);
        pApplet.g.endShape(2);
        pApplet.g.popStyle();
    }

    protected void onNewUserCb(long l) {
        if (this._newUserFn != null) {
            this._newUserFn.invoke((Object)this, (Object)((int)l));
        }
    }

    protected void onLostUserCb(long l) {
        if (this._lostUserFn != null) {
            this._lostUserFn.invoke((Object)this, (Object)((int)l));
        }
    }

    protected void onStartCalibrationCb(long l) {
        if (this._startCalibrationFn != null) {
            this._startCalibrationFn.invoke((Object)this, (Object)((int)l));
        }
    }

    protected void onEndCalibrationCb(long l, boolean bl) {
        if (this._endCalibrationFn != null) {
            this._endCalibrationFn.invoke((Object)this, (Object)((int)l), (Object)bl);
        }
    }

    protected void onStartPoseCb(String string, long l) {
        if (this._startPoseFn != null) {
            this._startPoseFn.invoke((Object)this, (Object)string, (Object)((int)l));
        }
    }

    protected void onEndPoseCb(String string, long l) {
        if (this._endPoseFn != null) {
            this._endPoseFn.invoke((Object)this, (Object)string, (Object)((int)l));
        }
    }

    protected void onCreateHandsCb(long l, XnPoint3D xnPoint3D, float f) {
        if (this._createHandsFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            this._createHandsFn.invoke((Object)this, (Object)((int)l), (Object)pVector, (Object)Float.valueOf(f));
        }
    }

    protected void onUpdateHandsCb(long l, XnPoint3D xnPoint3D, float f) {
        if (this._updateHandsFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            this._updateHandsFn.invoke((Object)this, (Object)((int)l), (Object)pVector, (Object)Float.valueOf(f));
        }
    }

    protected void onDestroyHandsCb(long l, float f) {
        if (this._destroyHandsFn != null) {
            this._destroyHandsFn.invoke((Object)this, (Object)((int)l), (Object)Float.valueOf(f));
        }
    }

    protected void onRecognizeGestureCb(String string, XnPoint3D xnPoint3D, XnPoint3D xnPoint3D2) {
        if (this._recognizeGestureFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            PVector pVector2 = new PVector(xnPoint3D2.getX(), xnPoint3D2.getY(), xnPoint3D2.getZ());
            this._recognizeGestureFn.invoke((Object)this, (Object)string, (Object)pVector, (Object)pVector2);
        }
    }

    protected void onProgressGestureCb(String string, XnPoint3D xnPoint3D, float f) {
        if (this._recognizeGestureFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            this._recognizeGestureFn.invoke((Object)this, (Object)string, (Object)pVector, (Object)Float.valueOf(f));
        }
    }

    protected void onStartSessionCb(XnPoint3D xnPoint3D) {
        if (this._startSessionFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            this._startSessionFn.invoke((Object)this, (Object)pVector);
        }
    }

    protected void onEndSessionCb() {
        if (this._endSessionFn != null) {
            this._endSessionFn.invoke((Object)this);
        }
    }

    protected void onFocusSessionCb(String string, XnPoint3D xnPoint3D, float f) {
        if (this._focusSessionFn != null) {
            PVector pVector = new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
            this._focusSessionFn.invoke((Object)this, (Object)string, (Object)pVector, (Object)Float.valueOf(f));
        }
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "SimpleOpenNI";
        String string3 = System.getProperty("os.arch").toLowerCase();
        if (string.indexOf("win") >= 0) {
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32";
            } else if (string3.indexOf("64") >= 0) {
                string2 = string2 + "64";
            }
        } else if (string.indexOf("nix") >= 0 || string.indexOf("linux") >= 0) {
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32";
            } else if (string3.indexOf("64") >= 0) {
                System.out.println("----");
                string2 = string2 + "64";
            }
        } else if (string.indexOf("mac") >= 0) {
            // empty if block
        }
        try {
            System.loadLibrary(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Can't find the SimpleOpenNI library (" + string2 + ") : " + unsatisfiedLinkError);
        }
        _initFlag = false;
    }
}

