(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "A template for building microservices with Ring, Compojure, and
  friends"
  :url "https://github.com/FIXME/{{name}}"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:name "git"
        :url "https://github.com/FIXME/{{name}}"}
  :min-lein-version "2.5.0"
  :jvm-opts ["-Xms768m" "-Xmx768m"]
  :global-vars {*warn-on-reflection* false *assert* false}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [ring/ring-core "1.3.2"]
                 [ring/ring-defaults "0.1.3"]
                 [ring/ring-headers "0.1.1"]
                 [ring/ring-json "0.3.1"]
                 [fogus/ring-edn "0.2.0"]
                 [ring-cors "0.1.6"]
                 [compojure "1.3.1"]
                 [http-kit "2.1.18"]
                 [prone "0.8.0"]
                 [environ "1.0.0"]]
  :profiles {:dev {:dependencies [[ring-mock "0.1.5"]
                                  [ring/ring-devel "1.3.1"]]
                   :env {:is-dev true}}
             :uberjar {:env {:production true}
                       :omit-source true
                       :aot :all}}
  :plugins [[lein-ring "0.9.1"]
            [lein-environ "1.0.0"]
            [lein-kibit "0.0.8"]
            [lein-pprint "1.1.1"]
            [lein-pdo "0.1.1"]
            [lein-cljfmt "0.1.7"]
            [jonase/eastwood "0.2.1"]]
  :aliases {"dev" ["ring" "server"]
            "analyze" ["pdo" "kibit," "eastwood"]
            "format" ["cljfmt" "check"]
            "prod" ["pdo" "clean," "uberjar"]}
  :ring {:handler {{name}}.server/app}
  :main ^:skip-aot {{name}}.server
  :uberjar-name "{{name}}.jar")
