Ring Microservices
==================

A Leiningen template for building microservices in Ring and curated middleware, with an emphasis on deploying on PaaS containers.

## Features

- Focus on Microservices and PaaS
- Sane project structure
- Async HTTP and Websockets server with [http-kit](http://www.http-kit.org)
- Curated Ring [middleware](https://github.com/ring-clojure/ring-defaults)
- Static Code Analyzers with [kibit](https://github.com/jonase/kibit) and [eastwood](https://github.com/jonase/eastwood) 
- Visual _debugger_ with [prone](https://github.com/magnars/prone)
- Sourcecode formatting with [cljfmt](https://github.com/weavejester/cljfmt)
- Environment variables with [environ](https://github.com/weavejester/environ)

## Quickstart

    lein new ring-micro tinyapi
 
Start a Ring server at `localhost:3000`:

	lein dev

Start http-kit sever at `localhost:8000`:

	lein run

Ready to deploy? Generate an uberjar:

    lein prod

Preview staging with [foreman](https://github.com/ddollar/foreman) at `http://localhost:5000/`

    foreman start

## Documentation

A guide with best practices is under [doc](/doc/index.md).

## Contributing

Leiningen templates are just maven artifacts. Make changes to the template and test local deployment by running:

    ./test.sh

This uploads the artifacts to your local mvn repo, creates a new template 'example' and starts the server.

If things look good, send a pull request.

## Status

[![Clojars Project](http://clojars.org/priyatam/ring-micro/latest-version.svg)](http://clojars.org/priyatam/ring-micro)

## License

Copyright © 2015 Priyatam Mudivarti.

Released under the Eclipse Public License, same as Clojure.
