Ring Microservices
==================

A Leiningen template for building Microservices in Ring, curated middleware, with an emphasis on deploying uberjars on Container platforms.

## Features

- Sane project structure
- Curated Ring [middleware](https://github.com/ring-clojure/ring-defaults)
- Async HTTP and Websockets server with [http-kit](http://www.http-kit.org)
- Environment variables with [environ](https://github.com/weavejester/environ)
- Static Code Analyzers with [kibit](https://github.com/jonase/kibit) and [eastwood](https://github.com/jonase/eastwood) 
- Visual _debugger_ with [prone](https://github.com/magnars/prone)
- Sourcecode formatting with [cljfmt](https://github.com/weavejester/cljfmt)
- Deploy with Procfile on Heroku
- Dockerize your ubjerjar (script included)

## Quickstart

Create a new Microservice:

    lein new ring-micro tinyapi

### Dev

Start a Ring server at `localhost:3000`:

	lein dev

Start http-kit sever at `localhost:8000`:

	lein run

Ready to deploy? Generate an uberjar:

	lein prod

### Heroku

First, preview with [foreman](https://github.com/ddollar/foreman) at `http://localhost:5000/`

	foreman start

Assuming Heroku [CLI](https://devcenter.heroku.com/articles/heroku-command) is installed.

	heroku apps:create
    git push heroku master
    heroku ps:scale web=1
    heroku open

### Docker

The following steps are optimized for OSX, using [brew](http://brew.sh).

Install Docker

	brew install docker

Install [VirtualBox](https://www.virtualbox.org), the VM required to host a Docker container.

	brew cask install virtualbox

Install Boot2Docker:

	brew install boot2docker
	boot2docker init

After every reboot, run the docker daemon:

	boot2docker up

All ok? Check

	docker version

Now run [dockerize](https://github.com/priyatam/ring-micro/blob/master/src/leiningen/new/ring_micro/dockerize) to convert our uberjar into a Docker container!

	chmod +x dockerize
	dockerize

Copy the image-id and run Docker locally

	docker run -p 8080:8000 <7b00689ab4fd>

Test Docker container via the VM's IP.

	curl $(boot2docker ip):8080

If you got so far, congrats ... you just created an immutable container with Docker!

## Contributing

Leiningen templates are just maven artifacts. Make changes to the template and test local deployment by running:

    ./test.sh

This uploads the artifacts to your local mvn repo, creates a new template 'example' and starts the server.

If things look good, send a pull request.

## Status

[![Clojars Project](http://clojars.org/priyatam/ring-micro/latest-version.svg)](http://clojars.org/priyatam/ring-micro)

## License

Copyright © 2015 Priyatam Mudivarti.

Released under the Eclipse Public License, same as Clojure.
