(ns leiningen.new.ring-micro
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "ring-micro"))

(defn ring-micro [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh ring-micro template.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/db.clj" (render "db.clj" data)]
             ["src/{{sanitized}}/router.clj" (render "router.clj" data)]
             ["src/{{sanitized}}/server.clj" (render "server.clj" data)]
             ["src/{{sanitized}}/utils.clj" (render "utils.clj" data)]
             ["dockerize" (render "dockerize" data)]
             ["README.md" (render "README.md" data)]
             ["LICENSE" (render "LICENSE" data)]
             ["Procfile" (render "Procfile" data)]
             ["system.properties" (render "system.properties" data)]
             [".gitignore" (render "gitignore" data)])))
