(ns {{name}}.server
    (:require [clojure.java.io :as io]
              [clojure.tools.logging :as log]
              [ring.middleware.cors :refer :all]
              [ring.middleware.defaults :refer :all]
              [ring.middleware.edn :refer :all]
              [ring.middleware.json :refer [wrap-json-response wrap-json-body]]
              [ring.middleware.session :as session]
              [ring.middleware.params :as params]
              [ring.middleware.keyword-params :as keyword-params]
              [ring.middleware.nested-params :as nested-params]
              [compojure.handler :refer [site] :as handler]
              [prone.debug :refer [debug]]
              [org.httpkit.server :as server]
              [environ.core :refer [env]]
              [{{name}}.router :as router])
    (:gen-class))

(def app
  (->
   (handler/site router/routes)
   (wrap-json-body)
   (wrap-json-response)
   (wrap-edn-params)
   (wrap-defaults api-defaults)
   (wrap-cors
    :access-control-allow-origin #".+"
    :access-control-allow-methods [:get :post :put :delete :head]
    :access-control-allow-headers ["Content-Type" "X-Requested-With"])))

(defn -main [& _]
  (let [port (Integer. (or (System/getenv "SERVER_PORT") 8000))]
    (server/run-server app {:port port :join? false})
    (log/info "Server started and listening at port..." port)))
