/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.DualTransport;
import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.IPromise;
import com.aphyr.riemann.client.MsgTooLargeException;
import com.aphyr.riemann.client.RiemannScheduler;
import com.aphyr.riemann.client.ServerError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRiemannClient
implements DualTransport {
    protected volatile RiemannScheduler scheduler = null;

    public static Proto.Msg validate(Proto.Msg message) throws ServerError {
        if (message.hasOk() && !message.getOk()) {
            throw new ServerError(message.getError());
        }
        return message;
    }

    @Override
    public abstract Proto.Msg sendRecvMessage(Proto.Msg var1) throws IOException;

    @Override
    public abstract Proto.Msg sendMaybeRecvMessage(Proto.Msg var1) throws IOException;

    @Override
    public abstract IPromise<Proto.Msg> aSendRecvMessage(Proto.Msg var1);

    @Override
    public abstract IPromise<Proto.Msg> aSendMaybeRecvMessage(Proto.Msg var1);

    @Override
    public abstract void connect() throws IOException;

    @Override
    public abstract boolean isConnected();

    @Override
    public abstract void disconnect() throws IOException;

    @Override
    public abstract void reconnect() throws IOException;

    @Override
    public abstract void flush() throws IOException;

    public EventDSL event() {
        return new EventDSL(this);
    }

    public Boolean sendEventsWithAck(List<Proto.Event> events) throws IOException, MsgTooLargeException {
        AbstractRiemannClient.validate(this.sendRecvMessage(Proto.Msg.newBuilder().addAllEvents(events).build()));
        return true;
    }

    public IPromise<Boolean> aSendEventsWithAck(List<Proto.Event> events) {
        final IPromise<Proto.Msg> p = this.aSendRecvMessage(Proto.Msg.newBuilder().addAllEvents(events).build());
        return new IPromise<Boolean>(){

            @Override
            public void deliver(Object value) {
            }

            @Override
            public Boolean deref() throws IOException {
                AbstractRiemannClient.validate((Proto.Msg)p.deref());
                return true;
            }

            @Override
            public Boolean deref(long time, TimeUnit unit) throws IOException {
                AbstractRiemannClient.validate((Proto.Msg)p.deref(time, unit));
                return true;
            }

            @Override
            public Boolean deref(long time, TimeUnit unit, Boolean timeoutValue) throws IOException {
                Proto.Msg message = p.deref(time, unit, null);
                if (message != null && AbstractRiemannClient.validate(message) != null) {
                    return true;
                }
                return false;
            }
        };
    }

    public Boolean sendEventsWithAck(Proto.Event ... events) throws IOException, ServerError, MsgTooLargeException {
        return this.sendEventsWithAck(Arrays.asList(events));
    }

    public IPromise<Boolean> aSendEventsWithAck(Proto.Event ... events) {
        return this.aSendEventsWithAck(Arrays.asList(events));
    }

    public void sendEvents(List<Proto.Event> events) {
        try {
            this.sendMaybeRecvMessage(Proto.Msg.newBuilder().addAllEvents(events).build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendEvents(Proto.Event ... events) {
        this.sendEvents(Arrays.asList(events));
    }

    public void sendException(String service, Throwable t) {
        StringBuilder desc = new StringBuilder();
        desc.append(t.toString());
        desc.append("\n\n");
        for (StackTraceElement e : t.getStackTrace()) {
            desc.append(e);
            desc.append("\n");
        }
        this.event().service(service).state("error").tag("exception").tag(t.getClass().getSimpleName()).description(desc.toString()).send();
    }

    public List<Proto.Event> query(String q) throws IOException, ServerError, MsgTooLargeException {
        Proto.Msg m = this.sendRecvMessage(Proto.Msg.newBuilder().setQuery(Proto.Query.newBuilder().setString(q).build()).build());
        AbstractRiemannClient.validate(m);
        return Collections.unmodifiableList(m.getEventsList());
    }

    public synchronized RiemannScheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = new RiemannScheduler(this);
        }
        return this.scheduler;
    }

    public ScheduledFuture every(long interval, Runnable f) {
        return this.scheduler().every(interval, f);
    }

    public ScheduledFuture every(long interval, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, f);
    }

    public ScheduledFuture every(long interval, TimeUnit unit, Runnable f) {
        return this.scheduler().every(interval, unit, f);
    }

    public ScheduledFuture every(long interval, TimeUnit unit, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, unit, f);
    }

    public ScheduledFuture every(long interval, long delay, Runnable f) {
        return this.scheduler().every(interval, delay, f);
    }

    public ScheduledFuture every(long interval, long delay, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, delay, f);
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, Runnable f) {
        return this.scheduler().every(interval, delay, unit, f);
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, delay, unit, f);
    }
}

