/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.IPromise;
import com.aphyr.riemann.client.MsgTooLargeException;
import com.aphyr.riemann.client.Null;
import com.aphyr.riemann.client.ServerError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventDSL {
    public final AbstractRiemannClient client;
    public final Proto.Event.Builder builder;
    public final Map<String, String> attributes = new HashMap<String, String>();

    public EventDSL(AbstractRiemannClient client) {
        this.client = client;
        this.builder = Proto.Event.newBuilder();
        try {
            this.builder.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public EventDSL host(String host) {
        if (null == host) {
            this.builder.clearHost();
        } else {
            this.builder.setHost(host);
        }
        return this;
    }

    public EventDSL service(String service) {
        if (null == service) {
            this.builder.clearService();
        } else {
            this.builder.setService(service);
        }
        return this;
    }

    public EventDSL state(String state) {
        if (null == state) {
            this.builder.clearState();
        } else {
            this.builder.setState(state);
        }
        return this;
    }

    public EventDSL description(String description) {
        if (null == description) {
            this.builder.clearDescription();
        } else {
            this.builder.setDescription(description);
        }
        return this;
    }

    public EventDSL time(Null n) {
        this.builder.clearMetricF();
        return this;
    }

    public EventDSL time(float time) {
        this.builder.setTime((long)time);
        return this;
    }

    public EventDSL time(double time) {
        this.builder.setTime((long)time);
        return this;
    }

    public EventDSL time(long time) {
        this.builder.setTime(time);
        return this;
    }

    public EventDSL metric(Null n) {
        this.builder.clearMetricF();
        this.builder.clearMetricD();
        this.builder.clearMetricSint64();
        return this;
    }

    public EventDSL metric(byte metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventDSL metric(short metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventDSL metric(int metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventDSL metric(long metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventDSL metric(float metric) {
        this.builder.setMetricF(metric);
        return this;
    }

    public EventDSL metric(double metric) {
        this.builder.setMetricD(metric);
        this.builder.setMetricF((float)metric);
        return this;
    }

    public EventDSL tag(String tag) {
        this.builder.addTags(tag);
        return this;
    }

    public EventDSL tags(List<String> tags) {
        this.builder.addAllTags(tags);
        return this;
    }

    public EventDSL tags(String ... tags) {
        this.builder.addAllTags(Arrays.asList(tags));
        return this;
    }

    public EventDSL ttl(Null n) {
        this.builder.clearTtl();
        return this;
    }

    public EventDSL ttl(float ttl) {
        this.builder.setTtl(ttl);
        return this;
    }

    public EventDSL attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public EventDSL attributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public Proto.Event build() {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            Proto.Attribute.Builder attribBuilder = Proto.Attribute.newBuilder();
            attribBuilder.setKey(entry.getKey());
            attribBuilder.setValue(entry.getValue());
            this.builder.addAttributes(attribBuilder);
        }
        return this.builder.build();
    }

    public Boolean sendWithAck() throws IOException, ServerError, MsgTooLargeException {
        return this.client.sendEventsWithAck(this.build());
    }

    public IPromise send() {
        return this.client.aSendEventsWithAck(this.build());
    }
}

