/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.AsynchronizeTransport;
import com.aphyr.riemann.client.AsynchronousTransport;
import com.aphyr.riemann.client.DualTransport;
import com.aphyr.riemann.client.IPromise;
import com.aphyr.riemann.client.SynchronizeTransport;
import com.aphyr.riemann.client.SynchronousTransport;
import com.aphyr.riemann.client.TcpTransport;
import com.aphyr.riemann.client.UdpTransport;
import java.io.IOException;
import java.net.InetSocketAddress;

public class RiemannClient
extends AbstractRiemannClient
implements DualTransport {
    public final DualTransport transport;

    public static RiemannClient wrap(SynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient wrap(AsynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient tcp(InetSocketAddress address) throws IOException {
        return RiemannClient.wrap(new TcpTransport(address));
    }

    public static RiemannClient tcp(String host, int port) throws IOException {
        return RiemannClient.wrap(new TcpTransport(host, port));
    }

    public static RiemannClient tcp(String host) throws IOException {
        return RiemannClient.wrap(new TcpTransport(host));
    }

    public static RiemannClient tcp(int port) throws IOException {
        return RiemannClient.wrap(new TcpTransport(port));
    }

    public static RiemannClient udp(InetSocketAddress address) throws IOException {
        return RiemannClient.wrap(new UdpTransport(address));
    }

    public static RiemannClient udp(String host, int port) throws IOException {
        return RiemannClient.wrap(new UdpTransport(host, port));
    }

    public static RiemannClient udp(String host) throws IOException {
        return RiemannClient.wrap(new UdpTransport(host));
    }

    public static RiemannClient udp(int port) throws IOException {
        return RiemannClient.wrap(new UdpTransport(port));
    }

    public RiemannClient(SynchronousTransport t) {
        this(new AsynchronizeTransport(t));
    }

    public RiemannClient(AsynchronousTransport t) {
        this(new SynchronizeTransport(t));
    }

    public RiemannClient(DualTransport t) {
        this.transport = t;
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg m) throws IOException {
        return this.transport.sendRecvMessage(m);
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg m) throws IOException {
        return this.transport.sendMaybeRecvMessage(m);
    }

    @Override
    public IPromise<Proto.Msg> aSendRecvMessage(Proto.Msg m) {
        return this.transport.aSendRecvMessage(m);
    }

    @Override
    public IPromise<Proto.Msg> aSendMaybeRecvMessage(Proto.Msg m) {
        return this.transport.aSendMaybeRecvMessage(m);
    }

    @Override
    public void connect() throws IOException {
        this.transport.connect();
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        this.transport.disconnect();
    }

    @Override
    public void reconnect() throws IOException {
        this.transport.reconnect();
    }

    @Override
    public void flush() throws IOException {
        this.transport.flush();
    }
}

