(ns pulley.usage
  (:require [pulley.ring        :as ring]
            [pulley.store.mysql :as mysql-store]
            [pulley.publish     :as publish]
            [ring.adapter.jetty :as jetty]
            [clojure.java.jdbc  :as jdbc]))

;;--------------------------------------------------------------------
;; Initialize an event store
;;

(def mysql-db {:subprotocol "mysql"
               :subname "//127.0.0.1:3306/events_test"
               :user "root"})

(def mysql-store (mysql-store/make-event-store mysql-db "switch_events4"))


;;--------------------------------------------------------------------
;; Publishing API
;;

(jdbc/with-connection mysql-db
  (publish/with-store mysql-store

    (publish/publish! {:event           :uswitch/received
                       :created-at      #inst "2013-05-01T17:48"
                       :received-at     #inst "2013-05-01T17:49"})

    (publish/publish! {:event           :uswitch/delivered
                       :delivered-at    #inst "2013-05-02T05:01"})

    (publish/publish! {:event           :supplier/acknowledged
                       :acknowledged-at #inst "2013-05-02T10:03"})
    ))





;;--------------------------------------------------------------------
;; Feed API
;;

(defn wrap-connection
  [handler connection]
  (fn [req]
    (jdbc/with-connection connection
      (handler req))))

;; generate a ring handler exposing all events in the supplied store
(def handler (wrap-connection (ring/handler mysql-store 10) mysql-db))

(comment

  (def server (jetty/run-jetty #'handler
                               {:join? false
                                :port 8001}))

  (.stop server)

  )

(defn demo
  [& args]
  (future
    (while true
      (jdbc/with-connection mysql-db
        (publish/with-store mysql-store

          (publish/publish! {:event           :uswitch/received
                             :created-at      #inst "2013-05-01T17:48"
                             :received-at     #inst "2013-05-01T17:49"})

          (publish/publish! {:event           :uswitch/delivered
                             :delivered-at    #inst "2013-05-02T05:01"})

          (publish/publish! {:event           :supplier/acknowledged
                             :acknowledged-at #inst "2013-05-02T10:03"}))
        (Thread/sleep 15000))))
  (jetty/run-jetty #'handler
                   {:join? true
                    :port 8001}))
