/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.certificate_authority.CertificateAuthority;
import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.HttpResponse;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    private static RequestOptions configureSslFromContext(RequestOptions requestOptions) {
        requestOptions.setSslEngine(requestOptions.getSslContext().createSSLEngine());
        requestOptions.setSslContext(null);
        return requestOptions;
    }

    private static RequestOptions configureSsl(RequestOptions requestOptions) {
        if (requestOptions.getSslEngine() != null) {
            return requestOptions;
        }
        if (requestOptions.getSslContext() != null) {
            return SyncHttpClient.configureSslFromContext(requestOptions);
        }
        if (requestOptions.getSslCert() != null && requestOptions.getSslKey() != null && requestOptions.getSslCaCert() != null) {
            try {
                requestOptions.setSslContext(CertificateAuthority.pemsToSSLContext((Reader)new FileReader(requestOptions.getSslCert()), (Reader)new FileReader(requestOptions.getSslKey()), (Reader)new FileReader(requestOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", unrecoverableKeyException);
            }
            requestOptions.setSslCert(null);
            requestOptions.setSslKey(null);
            requestOptions.setSslCaCert(null);
            return SyncHttpClient.configureSslFromContext(requestOptions);
        }
        if (requestOptions.getSslCaCert() != null) {
            try {
                requestOptions.setSslContext(CertificateAuthority.caCertPemToSSLContext((Reader)new FileReader(requestOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SyncHttpClient.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            requestOptions.setSslCaCert(null);
            return SyncHttpClient.configureSslFromContext(requestOptions);
        }
        return requestOptions;
    }

    public static HttpResponse request(RequestOptions requestOptions) {
        requestOptions = SyncHttpClient.configureSsl(requestOptions);
        Promise<HttpResponse> promise = null;
        try {
            promise = JavaClient.request(requestOptions, null);
        }
        catch (IOException iOException) {
            SyncHttpClient.logAndRethrow("Error submitting http request", iOException);
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = promise.deref();
        }
        catch (InterruptedException interruptedException) {
            SyncHttpClient.logAndRethrow("Error while waiting for http response", interruptedException);
        }
        if (httpResponse.getError() != null) {
            SyncHttpClient.logAndRethrow("Error executing http request", httpResponse.getError());
        }
        return httpResponse;
    }

    public static HttpResponse get(String string) {
        return SyncHttpClient.get(new RequestOptions(string));
    }

    public static HttpResponse get(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.GET));
    }

    public static HttpResponse post(String string) {
        return SyncHttpClient.post(new RequestOptions(string));
    }

    public static HttpResponse post(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.POST));
    }
}

