/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.HttpResponse;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.impl.BasicAuth;
import com.puppetlabs.http.client.impl.CoercedRequestOptions;
import com.puppetlabs.http.client.impl.IResponseCallback;
import com.puppetlabs.http.client.impl.Promise;
import com.puppetlabs.http.client.impl.ResponseHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.xml.bind.DatatypeConverter;
import org.httpkit.HttpMethod;
import org.httpkit.client.HttpClient;
import org.httpkit.client.IRespListener;
import org.httpkit.client.IResponseHandler;
import org.httpkit.client.MultipartEntity;
import org.httpkit.client.RequestConfig;
import org.httpkit.client.RespListener;
import org.httpkit.client.SslContextFactory;

public class JavaClient {
    private static HttpClient defaultClient = null;

    private static HttpClient getDefaultClient() throws IOException {
        if (defaultClient == null) {
            defaultClient = new HttpClient();
        }
        return defaultClient;
    }

    private static String buildQueryString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append("&");
            }
            bl = false;
            try {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), "utf8"));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), "utf8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Error while url-encoding query string", unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    private static String getBasicAuthValue(BasicAuth basicAuth) {
        String string = basicAuth.getUser() + ":" + basicAuth.getPassword();
        try {
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])string.getBytes("utf8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Error while attmempting to encode basic auth", unsupportedEncodingException);
        }
    }

    private static Map<String, Object> prepareHeaders(RequestOptions requestOptions) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (requestOptions.getHeaders() != null) {
            for (Map.Entry<String, Object> entry : requestOptions.getHeaders().entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (requestOptions.getFormParams() != null) {
            hashMap.put("Content-Type", "application/x-www-form-urlencoded");
        }
        if (requestOptions.getBasicAuth() != null) {
            hashMap.put("Authorization", JavaClient.getBasicAuthValue(requestOptions.getBasicAuth()));
        }
        if (requestOptions.getOAuthToken() != null) {
            hashMap.put("Authorization", "Bearer " + requestOptions.getOAuthToken());
        }
        if (requestOptions.getUserAgent() != null) {
            hashMap.put("User-Agent", requestOptions.getUserAgent());
        }
        return hashMap;
    }

    private static CoercedRequestOptions coerceRequestOptions(RequestOptions requestOptions) throws IOException {
        String string = requestOptions.getQueryParams() != null ? (requestOptions.getUrl().indexOf(63) == -1 ? requestOptions.getUrl() + "?" + JavaClient.buildQueryString(requestOptions.getQueryParams()) : requestOptions.getUrl() + "&" + JavaClient.buildQueryString(requestOptions.getQueryParams())) : requestOptions.getUrl();
        SSLEngine sSLEngine = null;
        if (requestOptions.getSslEngine() != null) {
            sSLEngine = requestOptions.getSslEngine();
        } else if (requestOptions.getInsecure()) {
            sSLEngine = SslContextFactory.trustAnybody();
        }
        HttpMethod httpMethod = requestOptions.getMethod().getValue();
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        Map<String, Object> map = JavaClient.prepareHeaders(requestOptions);
        Object object = requestOptions.getFormParams() != null ? JavaClient.buildQueryString(requestOptions.getFormParams()) : requestOptions.getBody();
        if (requestOptions.getMultipartEntities() != null) {
            String string2 = MultipartEntity.genBoundary(requestOptions.getMultipartEntities());
            map = requestOptions.getHeaders();
            map.put("Content-Type", "multipart/form-data; boundary=" + string2);
            object = MultipartEntity.encode((String)string2, requestOptions.getMultipartEntities());
        }
        return new CoercedRequestOptions(string, httpMethod, map, object, sSLEngine);
    }

    public static Promise<HttpResponse> request(RequestOptions requestOptions, IResponseCallback iResponseCallback) throws IOException {
        HttpClient httpClient = requestOptions.getClient();
        if (httpClient == null) {
            httpClient = JavaClient.getDefaultClient();
        }
        CoercedRequestOptions coercedRequestOptions = JavaClient.coerceRequestOptions(requestOptions);
        RequestConfig requestConfig = new RequestConfig(coercedRequestOptions.getMethod(), coercedRequestOptions.getHeaders(), coercedRequestOptions.getBody(), requestOptions.getTimeout(), requestOptions.getKeepalive());
        RespListener respListener = new RespListener((IResponseHandler)new ResponseHandler(requestOptions, coercedRequestOptions, iResponseCallback), requestOptions.getFilter(), requestOptions.getWorkerPool(), requestOptions.getAs().getValue());
        httpClient.exec(requestOptions.getUrl(), requestConfig, coercedRequestOptions.getSslEngine(), (IRespListener)respListener);
        return requestOptions.getPromise();
    }
}

