/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.HttpResponse;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.impl.CoercedRequestOptions;
import com.puppetlabs.http.client.impl.IResponseCallback;
import com.puppetlabs.http.client.impl.JavaClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.httpkit.HttpUtils;
import org.httpkit.client.IResponseHandler;

public class ResponseHandler
implements IResponseHandler {
    private static final Set<Integer> REDIRECT_STATUS_CODES = new HashSet<Integer>(Arrays.asList(301, 302, 303, 307, 308));
    private final RequestOptions options;
    private final CoercedRequestOptions coercedOptions;
    private final IResponseCallback callback;

    public ResponseHandler(RequestOptions requestOptions, CoercedRequestOptions coercedRequestOptions, IResponseCallback iResponseCallback) {
        this.options = requestOptions;
        this.coercedOptions = coercedRequestOptions;
        this.callback = iResponseCallback;
    }

    private HttpMethod getNewMethod(int n) {
        if (n == 301 || n == 302 || n == 303) {
            return HttpMethod.GET;
        }
        return this.options.getMethod();
    }

    private void deliverResponse(HttpResponse httpResponse) {
        HttpResponse httpResponse2 = httpResponse;
        try {
            if (this.callback != null) {
                httpResponse2 = this.callback.handleResponse(httpResponse);
            }
        }
        catch (Exception exception) {
            HttpUtils.printError((String)(this.coercedOptions.getMethod() + " " + this.coercedOptions.getUrl() + "'s callback"), (Throwable)exception);
            this.options.getPromise().deliver(new HttpResponse(this.options, exception));
        }
        this.options.getPromise().deliver(httpResponse2);
    }

    public void onSuccess(int n, Map<String, Object> map, Object object) {
        if (this.options.getFollowRedirects() && REDIRECT_STATUS_CODES.contains(n)) {
            if (this.options.getMaxRedirects() >= this.options.getTraceRedirects().size()) {
                try {
                    JavaClient.request(this.options.setUrl(new URI(this.coercedOptions.getUrl()).resolve((String)map.get("location")).toString()).setMethod(this.getNewMethod(n)).addTraceRedirect(this.coercedOptions.getUrl()), this.callback);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Error when attempting redirect", iOException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException("Error when attempting redirect", uRISyntaxException);
                }
            } else {
                this.deliverResponse(new HttpResponse(this.options, new Exception("too many redirects: " + this.options.getTraceRedirects().size())));
            }
        } else {
            this.deliverResponse(new HttpResponse(this.options, object, map, n));
        }
    }

    public void onThrowable(Throwable throwable) {
        this.deliverResponse(new HttpResponse(this.options, throwable));
    }
}

