/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.SyncHttpClient;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import com.puppetlabs.http.client.impl.SslUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    public static Promise<Response> request(RequestOptions requestOptions) {
        requestOptions = SslUtils.configureSsl(requestOptions);
        return JavaClient.request(requestOptions, null);
    }

    public static Promise<Response> get(String string) {
        return AsyncHttpClient.get(new RequestOptions(string));
    }

    public static Promise<Response> get(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.GET));
    }

    public static Promise<Response> head(String string) {
        return AsyncHttpClient.head(new RequestOptions(string));
    }

    public static Promise<Response> head(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.HEAD));
    }

    public static Promise<Response> post(String string) {
        return AsyncHttpClient.post(new RequestOptions(string));
    }

    public static Promise<Response> post(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.POST));
    }

    public static Promise<Response> put(String string) {
        return AsyncHttpClient.put(new RequestOptions(string));
    }

    public static Promise<Response> put(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.PUT));
    }

    public static Promise<Response> delete(String string) {
        return AsyncHttpClient.delete(new RequestOptions(string));
    }

    public static Promise<Response> delete(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.DELETE));
    }

    public static Promise<Response> trace(String string) {
        return AsyncHttpClient.trace(new RequestOptions(string));
    }

    public static Promise<Response> trace(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.TRACE));
    }

    public static Promise<Response> options(String string) {
        return AsyncHttpClient.options(new RequestOptions(string));
    }

    public static Promise<Response> options(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.OPTIONS));
    }

    public static Promise<Response> patch(String string) {
        return AsyncHttpClient.patch(new RequestOptions(string));
    }

    public static Promise<Response> patch(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.PATCH));
    }
}

