/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.ResponseBodyType;
import com.puppetlabs.http.client.impl.CoercedRequestOptions;
import com.puppetlabs.http.client.impl.Compression;
import com.puppetlabs.http.client.impl.IResponseCallback;
import com.puppetlabs.http.client.impl.Promise;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;

public class JavaClient {
    private static final String PROTOCOL = "TLS";

    private static Header[] prepareHeaders(RequestOptions requestOptions) {
        HashMap<String, BasicHeader> hashMap = new HashMap<String, BasicHeader>();
        Map<String, String> map = requestOptions.getHeaders();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getKey().toLowerCase(), new BasicHeader(entry.getKey(), entry.getValue()));
        }
        if (requestOptions.getDecompressBody() && !map.containsKey("accept-encoding")) {
            hashMap.put("accept-encoding", new BasicHeader("Accept-Encoding", "gzip, deflate"));
        }
        return hashMap.values().toArray(new Header[hashMap.size()]);
    }

    private static CoercedRequestOptions coerceRequestOptions(RequestOptions requestOptions) {
        String string = requestOptions.getUrl();
        SSLContext sSLContext = null;
        if (requestOptions.getSslContext() != null) {
            sSLContext = requestOptions.getSslContext();
        } else if (requestOptions.getInsecure()) {
            sSLContext = JavaClient.getInsecureSslContext();
        }
        HttpMethod httpMethod = requestOptions.getMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        Header[] headerArray = JavaClient.prepareHeaders(requestOptions);
        NStringEntity nStringEntity = null;
        if (requestOptions.getBody() instanceof String) {
            try {
                nStringEntity = new NStringEntity((String)requestOptions.getBody());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new HttpClientException("Unable to create request body", unsupportedEncodingException);
            }
        } else if (requestOptions.getBody() instanceof InputStream) {
            nStringEntity = new InputStreamEntity((InputStream)requestOptions.getBody());
        }
        return new CoercedRequestOptions(string, httpMethod, headerArray, (HttpEntity)nStringEntity, sSLContext);
    }

    private static SSLContext getInsecureSslContext() {
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance(PROTOCOL);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HttpClientException("Unable to construct HTTP context", noSuchAlgorithmException);
        }
        try {
            sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }
            }}, null);
        }
        catch (KeyManagementException keyManagementException) {
            throw new HttpClientException("Unable to initialize insecure SSL context", keyManagementException);
        }
        return sSLContext;
    }

    public static Promise<Response> request(final RequestOptions requestOptions, final IResponseCallback iResponseCallback) {
        CoercedRequestOptions coercedRequestOptions = JavaClient.coerceRequestOptions(requestOptions);
        final CloseableHttpAsyncClient closeableHttpAsyncClient = JavaClient.createClient(coercedRequestOptions);
        HttpRequestBase httpRequestBase = JavaClient.constructRequest(coercedRequestOptions.getMethod(), coercedRequestOptions.getUrl(), coercedRequestOptions.getBody());
        httpRequestBase.setHeaders(coercedRequestOptions.getHeaders());
        final Promise<Response> promise = new Promise<Response>();
        closeableHttpAsyncClient.execute((HttpUriRequest)httpRequestBase, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                try {
                    Object object = null;
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        object = httpEntity.getContent();
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (Header header : httpResponse.getAllHeaders()) {
                        hashMap.put(header.getName().toLowerCase(), header.getValue());
                    }
                    String string = (String)hashMap.get("content-encoding");
                    if (requestOptions.getDecompressBody()) {
                        object = JavaClient.decompress((InputStream)object, hashMap);
                    }
                    ContentType contentType = null;
                    if (hashMap.get("content-type") != null) {
                        contentType = ContentType.parse((String)((String)hashMap.get("content-type")));
                    }
                    if (requestOptions.getAs() != ResponseBodyType.STREAM) {
                        object = JavaClient.coerceBodyType((InputStream)object, requestOptions.getAs(), contentType);
                    }
                    JavaClient.deliverResponse(closeableHttpAsyncClient, requestOptions, new Response(requestOptions, string, object, hashMap, httpResponse.getStatusLine().getStatusCode(), contentType), iResponseCallback, promise);
                }
                catch (Exception exception) {
                    JavaClient.deliverResponse(closeableHttpAsyncClient, requestOptions, new Response(requestOptions, exception), iResponseCallback, promise);
                }
            }

            public void failed(Exception exception) {
                JavaClient.deliverResponse(closeableHttpAsyncClient, requestOptions, new Response(requestOptions, exception), iResponseCallback, promise);
            }

            public void cancelled() {
                JavaClient.deliverResponse(closeableHttpAsyncClient, requestOptions, new Response(requestOptions, new HttpClientException("Request cancelled", null)), iResponseCallback, promise);
            }
        });
        return promise;
    }

    private static CloseableHttpAsyncClient createClient(CoercedRequestOptions coercedRequestOptions) {
        CloseableHttpAsyncClient closeableHttpAsyncClient = coercedRequestOptions.getSslContext() != null ? HttpAsyncClients.custom().setSSLContext(coercedRequestOptions.getSslContext()).build() : HttpAsyncClients.createDefault();
        closeableHttpAsyncClient.start();
        return closeableHttpAsyncClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deliverResponse(CloseableHttpAsyncClient closeableHttpAsyncClient, RequestOptions requestOptions, Response response, IResponseCallback iResponseCallback, Promise<Response> promise) {
        try {
            if (iResponseCallback != null) {
                try {
                    promise.deliver(iResponseCallback.handleResponse(response));
                }
                catch (Exception exception) {
                    promise.deliver(new Response(requestOptions, exception));
                }
            } else {
                promise.deliver(response);
            }
        }
        finally {
            try {
                closeableHttpAsyncClient.close();
            }
            catch (IOException iOException) {
                throw new HttpClientException("Unable to close client", iOException);
            }
        }
    }

    private static HttpRequestBase constructRequest(HttpMethod httpMethod, String string, HttpEntity httpEntity) {
        switch (httpMethod) {
            case GET: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpGet(string), httpEntity, httpMethod);
            }
            case HEAD: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpHead(string), httpEntity, httpMethod);
            }
            case POST: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPost(string), httpEntity);
            }
            case PUT: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPut(string), httpEntity);
            }
            case DELETE: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpDelete(string), httpEntity, httpMethod);
            }
            case TRACE: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpTrace(string), httpEntity, httpMethod);
            }
            case OPTIONS: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpOptions(string), httpEntity, httpMethod);
            }
            case PATCH: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPatch(string), httpEntity);
            }
        }
        throw new HttpClientException("Unable to construct request for:" + (Object)((Object)httpMethod) + ", " + string, null);
    }

    private static HttpRequestBase requestWithBody(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    private static HttpRequestBase requestWithNoBody(HttpRequestBase httpRequestBase, Object object, HttpMethod httpMethod) {
        if (object != null) {
            throw new HttpClientException("Request of type " + (Object)((Object)httpMethod) + " does not support 'body'!");
        }
        return httpRequestBase;
    }

    public static InputStream decompress(InputStream inputStream, Map<String, String> map) {
        String string = map.get("content-encoding");
        if (string == null) {
            return inputStream;
        }
        switch (string) {
            case "gzip": {
                map.remove("content-encoding");
                return Compression.gunzip(inputStream);
            }
            case "deflate": {
                map.remove("content-encoding");
                return Compression.inflate(inputStream);
            }
        }
        return inputStream;
    }

    private static Object coerceBodyType(InputStream inputStream, ResponseBodyType responseBodyType, ContentType contentType) {
        switch (responseBodyType) {
            case TEXT: {
                String string = "UTF-8";
                if (contentType != null) {
                    string = contentType.getCharset().name();
                }
                try {
                    return IOUtils.toString((InputStream)inputStream, (String)string);
                }
                catch (IOException iOException) {
                    throw new HttpClientException("Unable to read body as string", iOException);
                }
            }
        }
        throw new HttpClientException("Unsupported body type: " + (Object)((Object)responseBodyType));
    }
}

