/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.certificate_authority.CertificateAuthority;
import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.SyncHttpClient;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    public static RequestOptions configureSsl(RequestOptions requestOptions) {
        if (requestOptions.getSslContext() != null) {
            return requestOptions;
        }
        if (requestOptions.getSslCert() != null && requestOptions.getSslKey() != null && requestOptions.getSslCaCert() != null) {
            try {
                requestOptions.setSslContext(CertificateAuthority.pemsToSSLContext((Reader)new FileReader(requestOptions.getSslCert()), (Reader)new FileReader(requestOptions.getSslKey()), (Reader)new FileReader(requestOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SslUtils.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SslUtils.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SslUtils.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                SslUtils.logAndRethrow("Error while configuring SSL", unrecoverableKeyException);
            }
            requestOptions.setSslCert(null);
            requestOptions.setSslKey(null);
            requestOptions.setSslCaCert(null);
            return requestOptions;
        }
        if (requestOptions.getSslCaCert() != null) {
            try {
                requestOptions.setSslContext(CertificateAuthority.caCertPemToSSLContext((Reader)new FileReader(requestOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SslUtils.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SslUtils.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SslUtils.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            requestOptions.setSslCaCert(null);
            return requestOptions;
        }
        return requestOptions;
    }
}

