/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.SyncHttpClient;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import com.puppetlabs.http.client.impl.SslUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    public static Promise<Response> request(RequestOptions requestOptions) {
        requestOptions = SslUtils.configureSsl(requestOptions);
        return JavaClient.request(requestOptions, null);
    }

    public static Promise<Response> get(String string) throws URISyntaxException {
        return AsyncHttpClient.get(new URI(string));
    }

    public static Promise<Response> get(URI uRI) {
        return AsyncHttpClient.get(new RequestOptions(uRI));
    }

    public static Promise<Response> get(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.GET));
    }

    public static Promise<Response> head(String string) throws URISyntaxException {
        return AsyncHttpClient.head(new URI(string));
    }

    public static Promise<Response> head(URI uRI) {
        return AsyncHttpClient.head(new RequestOptions(uRI));
    }

    public static Promise<Response> head(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.HEAD));
    }

    public static Promise<Response> post(String string) throws URISyntaxException {
        return AsyncHttpClient.post(new URI(string));
    }

    public static Promise<Response> post(URI uRI) {
        return AsyncHttpClient.post(new RequestOptions(uRI));
    }

    public static Promise<Response> post(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.POST));
    }

    public static Promise<Response> put(String string) throws URISyntaxException {
        return AsyncHttpClient.put(new URI(string));
    }

    public static Promise<Response> put(URI uRI) {
        return AsyncHttpClient.put(new RequestOptions(uRI));
    }

    public static Promise<Response> put(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.PUT));
    }

    public static Promise<Response> delete(String string) throws URISyntaxException {
        return AsyncHttpClient.delete(new URI(string));
    }

    public static Promise<Response> delete(URI uRI) {
        return AsyncHttpClient.delete(new RequestOptions(uRI));
    }

    public static Promise<Response> delete(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.DELETE));
    }

    public static Promise<Response> trace(String string) throws URISyntaxException {
        return AsyncHttpClient.trace(new URI(string));
    }

    public static Promise<Response> trace(URI uRI) {
        return AsyncHttpClient.trace(new RequestOptions(uRI));
    }

    public static Promise<Response> trace(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.TRACE));
    }

    public static Promise<Response> options(String string) throws URISyntaxException {
        return AsyncHttpClient.options(new URI(string));
    }

    public static Promise<Response> options(URI uRI) {
        return AsyncHttpClient.options(new RequestOptions(uRI));
    }

    public static Promise<Response> options(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.OPTIONS));
    }

    public static Promise<Response> patch(String string) throws URISyntaxException {
        return AsyncHttpClient.patch(new URI(string));
    }

    public static Promise<Response> patch(URI uRI) {
        return AsyncHttpClient.patch(new RequestOptions(uRI));
    }

    public static Promise<Response> patch(RequestOptions requestOptions) {
        return AsyncHttpClient.request(requestOptions.setMethod(HttpMethod.PATCH));
    }
}

