/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import com.puppetlabs.http.client.impl.SslUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    public static Response request(RequestOptions requestOptions) {
        requestOptions = SslUtils.configureSsl(requestOptions);
        Promise<Response> promise = JavaClient.request(requestOptions, null);
        Response response = null;
        try {
            response = promise.deref();
        }
        catch (InterruptedException interruptedException) {
            SyncHttpClient.logAndRethrow("Error while waiting for http response", interruptedException);
        }
        if (response.getError() != null) {
            SyncHttpClient.logAndRethrow("Error executing http request", response.getError());
        }
        return response;
    }

    public static Response get(String string) throws URISyntaxException {
        return SyncHttpClient.get(new URI(string));
    }

    public static Response get(URI uRI) {
        return SyncHttpClient.get(new RequestOptions(uRI));
    }

    public static Response get(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.GET));
    }

    public static Response head(String string) throws URISyntaxException {
        return SyncHttpClient.head(new URI(string));
    }

    public static Response head(URI uRI) {
        return SyncHttpClient.head(new RequestOptions(uRI));
    }

    public static Response head(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.HEAD));
    }

    public static Response post(String string) throws URISyntaxException {
        return SyncHttpClient.post(new URI(string));
    }

    public static Response post(URI uRI) {
        return SyncHttpClient.post(new RequestOptions(uRI));
    }

    public static Response post(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.POST));
    }

    public static Response put(String string) throws URISyntaxException {
        return SyncHttpClient.put(new URI(string));
    }

    public static Response put(URI uRI) {
        return SyncHttpClient.put(new RequestOptions(uRI));
    }

    public static Response put(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.PUT));
    }

    public static Response delete(String string) throws URISyntaxException {
        return SyncHttpClient.delete(new URI(string));
    }

    public static Response delete(URI uRI) {
        return SyncHttpClient.delete(new RequestOptions(uRI));
    }

    public static Response delete(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.DELETE));
    }

    public static Response trace(String string) throws URISyntaxException {
        return SyncHttpClient.trace(new URI(string));
    }

    public static Response trace(URI uRI) {
        return SyncHttpClient.trace(new RequestOptions(uRI));
    }

    public static Response trace(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.TRACE));
    }

    public static Response options(String string) throws URISyntaxException {
        return SyncHttpClient.options(new URI(string));
    }

    public static Response options(URI uRI) {
        return SyncHttpClient.options(new RequestOptions(uRI));
    }

    public static Response options(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.OPTIONS));
    }

    public static Response patch(String string) throws URISyntaxException {
        return SyncHttpClient.patch(new URI(string));
    }

    public static Response patch(URI uRI) {
        return SyncHttpClient.patch(new RequestOptions(uRI));
    }

    public static Response patch(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.PATCH));
    }
}

