/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.codahale.metrics.MetricRegistry;
import com.puppetlabs.http.client.ClientOptions;
import com.puppetlabs.http.client.CompressType;
import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.ResponseBodyType;
import com.puppetlabs.http.client.impl.CoercedClientOptions;
import com.puppetlabs.http.client.impl.CoercedRequestOptions;
import com.puppetlabs.http.client.impl.Deliverable;
import com.puppetlabs.http.client.impl.IResponseCallback;
import com.puppetlabs.http.client.impl.ResponseDeliveryDelegate;
import com.puppetlabs.http.client.impl.SslUtils;
import com.puppetlabs.http.client.impl.StreamingAsyncResponseConsumer;
import com.puppetlabs.http.client.impl.TimedFutureCallback;
import com.puppetlabs.http.client.impl.metrics.TimerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClient {
    private static final String PROTOCOL = "TLS";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaClient.class);
    private static int GZIP_BUFFER_SIZE = 4096;

    private static Header[] prepareHeaders(RequestOptions requestOptions, ContentType contentType) {
        HashMap<String, BasicHeader> hashMap = new HashMap<String, BasicHeader>();
        Map<String, String> map = requestOptions.getHeaders();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getKey().toLowerCase(), new BasicHeader(entry.getKey(), entry.getValue()));
        }
        if (requestOptions.getDecompressBody() && !hashMap.containsKey("accept-encoding")) {
            hashMap.put("accept-encoding", new BasicHeader("Accept-Encoding", "gzip, deflate"));
        }
        if (requestOptions.getCompressRequestBody() == CompressType.GZIP && !hashMap.containsKey("content-encoding")) {
            hashMap.put("content-encoding", new BasicHeader("Content-Encoding", "gzip"));
        }
        if (contentType != null) {
            hashMap.put("content-type", new BasicHeader("Content-Type", contentType.toString()));
        }
        return hashMap.values().toArray(new Header[hashMap.size()]);
    }

    public static ContentType getContentType(Object object, RequestOptions requestOptions) {
        ContentType contentType = null;
        Map<String, String> map = requestOptions.getHeaders();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string;
                if (!entry.getKey().toLowerCase().equals("content-type") || (string = entry.getValue()) == null || string.isEmpty()) continue;
                try {
                    contentType = ContentType.parse((String)string);
                }
                catch (ParseException parseException) {
                    throw new HttpClientException("Unable to parse request content type", parseException);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new HttpClientException("Unsupported content type charset", unsupportedCharsetException);
                }
                if (contentType.getCharset() != null || !(object instanceof String)) continue;
                contentType = ContentType.create((String)contentType.getMimeType(), (Charset)Consts.UTF_8);
            }
        }
        return contentType;
    }

    private static void throwUnsupportedBodyException(Object object) {
        throw new HttpClientException("Unsupported body type for request: " + object.getClass() + ". Only InputStream and String are supported.");
    }

    private static CoercedRequestOptions coerceRequestOptions(RequestOptions requestOptions, HttpMethod httpMethod) {
        URI uRI = requestOptions.getUri();
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        ContentType contentType = JavaClient.getContentType(requestOptions.getBody(), requestOptions);
        Header[] headerArray = JavaClient.prepareHeaders(requestOptions, contentType);
        InputStreamEntity inputStreamEntity = null;
        GZIPOutputStream gZIPOutputStream = null;
        Object object = requestOptions.getBody();
        byte[] byArray = null;
        if (object instanceof String || object instanceof InputStream) {
            if (requestOptions.getCompressRequestBody() == CompressType.GZIP) {
                PipedInputStream pipedInputStream = new PipedInputStream(GZIP_BUFFER_SIZE);
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                try {
                    pipedOutputStream.connect(pipedInputStream);
                    gZIPOutputStream = new GZIPOutputStream((OutputStream)pipedOutputStream, GZIP_BUFFER_SIZE);
                    inputStreamEntity = new InputStreamEntity((InputStream)pipedInputStream);
                }
                catch (IOException iOException) {
                    throw new HttpClientException("Error setting up gzip stream for request", iOException);
                }
                if (object instanceof String) {
                    String string = (String)object;
                    byArray = contentType != null ? string.getBytes(contentType.getCharset()) : string.getBytes();
                }
            } else if (object instanceof String) {
                String string = (String)object;
                if (contentType != null) {
                    inputStreamEntity = new NStringEntity(string, contentType);
                } else {
                    try {
                        inputStreamEntity = new NStringEntity(string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new HttpClientException("Unable to create request body", unsupportedEncodingException);
                    }
                }
            } else {
                inputStreamEntity = new InputStreamEntity((InputStream)object);
            }
        } else if (object != null) {
            JavaClient.throwUnsupportedBodyException(object);
        }
        return new CoercedRequestOptions(uRI, httpMethod, headerArray, (HttpEntity)inputStreamEntity, gZIPOutputStream, byArray);
    }

    public static CoercedClientOptions coerceClientOptions(ClientOptions clientOptions) {
        SSLContext sSLContext = null;
        if (clientOptions.getSslContext() != null) {
            sSLContext = clientOptions.getSslContext();
        } else if (clientOptions.getInsecure()) {
            sSLContext = JavaClient.getInsecureSslContext();
        }
        String[] stringArray = null;
        stringArray = clientOptions.getSslProtocols() != null ? clientOptions.getSslProtocols() : ClientOptions.DEFAULT_SSL_PROTOCOLS;
        String[] stringArray2 = null;
        if (clientOptions.getSslCipherSuites() != null) {
            stringArray2 = clientOptions.getSslCipherSuites();
        }
        boolean bl = clientOptions.getForceRedirects();
        boolean bl2 = clientOptions.getFollowRedirects();
        int n = clientOptions.getConnectTimeoutMilliseconds();
        int n2 = clientOptions.getSocketTimeoutMilliseconds();
        return new CoercedClientOptions(sSLContext, stringArray, stringArray2, bl, bl2, n, n2);
    }

    private static SSLContext getInsecureSslContext() {
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance(PROTOCOL);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HttpClientException("Unable to construct HTTP context", noSuchAlgorithmException);
        }
        try {
            sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }
            }}, null);
        }
        catch (KeyManagementException keyManagementException) {
            throw new HttpClientException("Unable to initialize insecure SSL context", keyManagementException);
        }
        return sSLContext;
    }

    private static void completeResponse(ResponseDeliveryDelegate responseDeliveryDelegate, RequestOptions requestOptions, IResponseCallback iResponseCallback, HttpResponse httpResponse, HttpContext httpContext) {
        try {
            Header header2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Header header2 : httpResponse.getAllHeaders()) {
                hashMap.put(header2.getName().toLowerCase(), header2.getValue());
            }
            String string = (String)hashMap.get("content-encoding");
            if (requestOptions.getDecompressBody()) {
                new ResponseContentEncoding().process(httpResponse, httpContext);
            }
            Object object = null;
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                object = httpEntity.getContent();
            }
            header2 = null;
            String string2 = (String)hashMap.get("content-type");
            if (string2 != null && !string2.isEmpty()) {
                try {
                    header2 = ContentType.parse((String)string2);
                }
                catch (ParseException parseException) {
                    LOGGER.error("Unable to parse response content-type", (Throwable)parseException);
                }
            }
            if (requestOptions.getAs() == ResponseBodyType.TEXT) {
                object = JavaClient.coerceBodyType((InputStream)object, requestOptions.getAs(), (ContentType)header2);
            }
            responseDeliveryDelegate.deliverResponse(requestOptions, string, object, hashMap, httpResponse.getStatusLine().getStatusCode(), (ContentType)header2, iResponseCallback);
        }
        catch (Exception exception) {
            responseDeliveryDelegate.deliverResponse(requestOptions, exception, iResponseCallback);
        }
    }

    private static void executeWithConsumer(CloseableHttpAsyncClient closeableHttpAsyncClient, final FutureCallback<HttpResponse> futureCallback, HttpRequestBase httpRequestBase, MetricRegistry metricRegistry, String[] stringArray, String string, boolean bl) {
        final StreamingAsyncResponseConsumer streamingAsyncResponseConsumer = new StreamingAsyncResponseConsumer(new Deliverable<HttpResponse>(){

            @Override
            public void deliver(HttpResponse httpResponse) {
                futureCallback.completed((Object)httpResponse);
            }
        });
        FutureCallback<HttpResponse> futureCallback2 = new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                streamingAsyncResponseConsumer.setFinalResult(null);
                futureCallback.completed((Object)httpResponse);
            }

            public void failed(Exception exception) {
                if (exception instanceof IOException) {
                    streamingAsyncResponseConsumer.setFinalResult((IOException)exception);
                } else {
                    streamingAsyncResponseConsumer.setFinalResult(new IOException(exception));
                }
                futureCallback.failed(exception);
            }

            public void cancelled() {
                streamingAsyncResponseConsumer.setFinalResult(null);
                futureCallback.cancelled();
            }
        };
        TimedFutureCallback<HttpResponse> timedFutureCallback = new TimedFutureCallback<HttpResponse>(futureCallback2, TimerUtils.startFullResponseTimers(metricRegistry, (HttpRequest)httpRequestBase, stringArray, string, bl));
        closeableHttpAsyncClient.execute(HttpAsyncMethods.create((HttpUriRequest)httpRequestBase), (HttpAsyncResponseConsumer)streamingAsyncResponseConsumer, timedFutureCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipRequestPayload(GZIPOutputStream gZIPOutputStream, byte[] byArray, Object object) {
        block16: {
            try {
                if (byArray != null) {
                    gZIPOutputStream.write(byArray);
                    break block16;
                }
                if (object instanceof InputStream) {
                    byte[] byArray2 = new byte[GZIP_BUFFER_SIZE];
                    try (InputStream inputStream = (InputStream)object;){
                        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)gZIPOutputStream, (byte[])byArray2);
                        break block16;
                    }
                }
                JavaClient.throwUnsupportedBodyException(object);
            }
            catch (IOException iOException) {
                LOGGER.debug("Error writing gzip request body", (Throwable)iOException);
            }
            finally {
                try {
                    gZIPOutputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.debug("Error closing gzip request stream", (Throwable)iOException);
                }
            }
        }
    }

    public static void requestWithClient(final RequestOptions requestOptions, HttpMethod httpMethod, final IResponseCallback iResponseCallback, CloseableHttpAsyncClient closeableHttpAsyncClient, final ResponseDeliveryDelegate responseDeliveryDelegate, MetricRegistry metricRegistry, String string, boolean bl) {
        Object object;
        CoercedRequestOptions coercedRequestOptions = JavaClient.coerceRequestOptions(requestOptions, httpMethod);
        HttpRequestBase httpRequestBase = JavaClient.constructRequest(coercedRequestOptions.getMethod(), coercedRequestOptions.getUri(), coercedRequestOptions.getBody());
        httpRequestBase.setHeaders(coercedRequestOptions.getHeaders());
        HttpClientContext httpClientContext = HttpClientContext.create();
        FutureCallback<HttpResponse> futureCallback = new FutureCallback<HttpResponse>((HttpContext)httpClientContext){
            final /* synthetic */ HttpContext val$httpContext;
            {
                this.val$httpContext = httpContext;
            }

            public void completed(HttpResponse httpResponse) {
                JavaClient.completeResponse(responseDeliveryDelegate, requestOptions, iResponseCallback, httpResponse, this.val$httpContext);
            }

            public void failed(Exception exception) {
                responseDeliveryDelegate.deliverResponse(requestOptions, exception, iResponseCallback);
            }

            public void cancelled() {
                responseDeliveryDelegate.deliverResponse(requestOptions, new HttpClientException("Request cancelled"), iResponseCallback);
            }
        };
        String[] stringArray = requestOptions.getMetricId();
        if (requestOptions.getAs() == ResponseBodyType.UNBUFFERED_STREAM) {
            JavaClient.executeWithConsumer(closeableHttpAsyncClient, futureCallback, httpRequestBase, metricRegistry, stringArray, string, bl);
        } else {
            object = new TimedFutureCallback<HttpResponse>(futureCallback, TimerUtils.startFullResponseTimers(metricRegistry, (HttpRequest)httpRequestBase, stringArray, string, bl));
            closeableHttpAsyncClient.execute((HttpUriRequest)httpRequestBase, (FutureCallback)object);
        }
        object = coercedRequestOptions.getGzipOutputStream();
        if (object != null) {
            JavaClient.gzipRequestPayload((GZIPOutputStream)object, coercedRequestOptions.getBytesToGzip(), requestOptions.getBody());
        }
    }

    public static CloseableHttpAsyncClient createClient(ClientOptions clientOptions) {
        CoercedClientOptions coercedClientOptions = JavaClient.coerceClientOptions(SslUtils.configureSsl(clientOptions));
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom();
        httpAsyncClientBuilder.setMaxConnPerRoute(clientOptions.getMaxConnectionsPerRoute());
        httpAsyncClientBuilder.setMaxConnTotal(clientOptions.getMaxConnectionsTotal());
        if (coercedClientOptions.getSslContext() != null) {
            httpAsyncClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(coercedClientOptions.getSslContext(), coercedClientOptions.getSslProtocols(), coercedClientOptions.getSslCipherSuites(), SSLIOSessionStrategy.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER));
        }
        Object object = !coercedClientOptions.getFollowRedirects() ? new RedirectStrategy(){

            public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
                return null;
            }
        } : (coercedClientOptions.getForceRedirects() ? new LaxRedirectStrategy() : new DefaultRedirectStrategy());
        httpAsyncClientBuilder.setRedirectStrategy(object);
        RequestConfig requestConfig = JavaClient.getRequestConfig(coercedClientOptions);
        if (requestConfig != null) {
            httpAsyncClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        CloseableHttpAsyncClient closeableHttpAsyncClient = httpAsyncClientBuilder.build();
        closeableHttpAsyncClient.start();
        return closeableHttpAsyncClient;
    }

    private static RequestConfig getRequestConfig(CoercedClientOptions coercedClientOptions) {
        RequestConfig requestConfig = null;
        int n = coercedClientOptions.getConnectTimeoutMilliseconds();
        int n2 = coercedClientOptions.getSocketTimeoutMilliseconds();
        if (n >= 0 || n2 >= 0) {
            RequestConfig.Builder builder = RequestConfig.custom();
            if (n >= 0) {
                builder.setConnectTimeout(n);
            }
            if (n2 >= 0) {
                builder.setSocketTimeout(n2);
            }
            requestConfig = builder.build();
        }
        return requestConfig;
    }

    private static HttpRequestBase constructRequest(HttpMethod httpMethod, URI uRI, HttpEntity httpEntity) {
        switch (httpMethod) {
            case GET: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpGet(uRI), httpEntity, httpMethod);
            }
            case HEAD: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpHead(uRI), httpEntity, httpMethod);
            }
            case POST: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPost(uRI), httpEntity);
            }
            case PUT: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPut(uRI), httpEntity);
            }
            case DELETE: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpDelete(uRI), httpEntity, httpMethod);
            }
            case TRACE: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpTrace(uRI), httpEntity, httpMethod);
            }
            case OPTIONS: {
                return JavaClient.requestWithNoBody((HttpRequestBase)new HttpOptions(uRI), httpEntity, httpMethod);
            }
            case PATCH: {
                return JavaClient.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPatch(uRI), httpEntity);
            }
        }
        throw new HttpClientException("Unable to construct request for:" + (Object)((Object)httpMethod) + ", " + uRI.toString(), null);
    }

    private static HttpRequestBase requestWithBody(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    private static HttpRequestBase requestWithNoBody(HttpRequestBase httpRequestBase, Object object, HttpMethod httpMethod) {
        if (object != null) {
            throw new HttpClientException("Request of type " + (Object)((Object)httpMethod) + " does not support 'body'!");
        }
        return httpRequestBase;
    }

    public static Object coerceBodyType(InputStream inputStream, ResponseBodyType responseBodyType, ContentType contentType) {
        String string = null;
        switch (responseBodyType) {
            case TEXT: {
                String string2 = "UTF-8";
                if (contentType != null && contentType.getCharset() != null) {
                    string2 = contentType.getCharset().name();
                }
                try {
                    string = inputStream == null ? "" : IOUtils.toString((InputStream)inputStream, (String)string2);
                }
                catch (IOException iOException) {
                    throw new HttpClientException("Unable to read body as string", iOException);
                }
                try {
                    if (inputStream == null) break;
                    inputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new HttpClientException("Unable to close response stream", iOException);
                }
            }
            default: {
                throw new HttpClientException("Unsupported body type: " + (Object)((Object)responseBodyType));
            }
        }
        return string;
    }
}

