/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import org.apache.http.concurrent.FutureCallback;

public final class TimedFutureCallback<T>
implements FutureCallback<T> {
    private final FutureCallback<T> delegate;
    private final ArrayList<Timer.Context> timerContexts;

    public TimedFutureCallback(FutureCallback<T> futureCallback, ArrayList<Timer.Context> arrayList) {
        this.delegate = futureCallback;
        this.timerContexts = arrayList;
    }

    public void completed(T t) {
        this.stopTimerContexts();
        this.delegate.completed(t);
    }

    public void failed(Exception exception) {
        this.stopTimerContexts();
        this.delegate.failed(exception);
    }

    public void cancelled() {
        this.stopTimerContexts();
        this.delegate.cancelled();
    }

    private void stopTimerContexts() {
        if (this.timerContexts != null) {
            for (Timer.Context context : this.timerContexts) {
                context.stop();
            }
        }
    }
}

