/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.puppetlabs.http.client.metrics.ClientTimer;
import com.puppetlabs.http.client.metrics.MetricIdClientTimer;
import com.puppetlabs.http.client.metrics.Metrics;
import com.puppetlabs.http.client.metrics.UrlAndMethodClientTimer;
import com.puppetlabs.http.client.metrics.UrlClientTimer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerUtils.class);

    private static ClientTimer getOrAddTimer(MetricRegistry metricRegistry, String string, ClientTimer clientTimer) {
        block4: {
            Map map = metricRegistry.getMetrics();
            Metric metric = (Metric)map.get(string);
            if (metric instanceof ClientTimer) {
                return (ClientTimer)metric;
            }
            if (metric == null) {
                try {
                    return (ClientTimer)metricRegistry.register(string, (Metric)clientTimer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Metric metric2 = (Metric)metricRegistry.getMetrics().get(string);
                    if (!(metric2 instanceof ClientTimer)) break block4;
                    return (ClientTimer)metric2;
                }
            }
        }
        throw new IllegalArgumentException(string + " is already used for a different type of metric");
    }

    private static ArrayList<Timer.Context> startFullResponseMetricIdTimers(MetricRegistry metricRegistry, String[] stringArray, String string) {
        ArrayList<Timer.Context> arrayList = new ArrayList<Timer.Context>();
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int j = 0; j <= i; ++j) {
                arrayList2.add(stringArray[j]);
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add("with-metric-id");
            arrayList3.addAll(arrayList2);
            arrayList3.add("full-response");
            String string2 = MetricRegistry.name((String)string, (String[])arrayList3.toArray(new String[arrayList3.size()]));
            MetricIdClientTimer metricIdClientTimer = new MetricIdClientTimer(string2, arrayList2, Metrics.MetricType.FULL_RESPONSE);
            arrayList.add(TimerUtils.getOrAddTimer(metricRegistry, string2, metricIdClientTimer).time());
        }
        return arrayList;
    }

    private static ArrayList<Timer.Context> startFullResponseUrlTimers(MetricRegistry metricRegistry, HttpRequest httpRequest, String string, boolean bl) {
        ArrayList<Timer.Context> arrayList = new ArrayList<Timer.Context>();
        if (bl) {
            try {
                RequestLine requestLine = httpRequest.getRequestLine();
                String string2 = Metrics.urlToMetricUrl(requestLine.getUri());
                String string3 = requestLine.getMethod();
                String string4 = MetricRegistry.name((String)string, (String[])new String[]{"with-url", string2, "full-response"});
                String string5 = MetricRegistry.name((String)string, (String[])new String[]{"with-url-and-method", string2, string3, "full-response"});
                UrlClientTimer urlClientTimer = new UrlClientTimer(string4, string2, Metrics.MetricType.FULL_RESPONSE);
                arrayList.add(TimerUtils.getOrAddTimer(metricRegistry, string4, urlClientTimer).time());
                UrlAndMethodClientTimer urlAndMethodClientTimer = new UrlAndMethodClientTimer(string5, string2, string3, Metrics.MetricType.FULL_RESPONSE);
                arrayList.add(TimerUtils.getOrAddTimer(metricRegistry, string5, urlAndMethodClientTimer).time());
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Could not build URI out of the request URI. Will not create URI timers. We recommend you read http://www.stilldrinking.com/programming-sucks. 'now all your snowflakes are urine and you can't even find the cat.'");
            }
        }
        return arrayList;
    }

    public static ArrayList<Timer.Context> startFullResponseTimers(MetricRegistry metricRegistry, HttpRequest httpRequest, String[] stringArray, String string, boolean bl) {
        if (metricRegistry != null) {
            ArrayList<Timer.Context> arrayList = TimerUtils.startFullResponseUrlTimers(metricRegistry, httpRequest, string, bl);
            ArrayList<Timer.Context> arrayList2 = new ArrayList<Timer.Context>(arrayList);
            if (stringArray != null) {
                ArrayList<Timer.Context> arrayList3 = TimerUtils.startFullResponseMetricIdTimers(metricRegistry, stringArray, string);
                arrayList2.addAll(arrayList3);
            }
            return arrayList2;
        }
        return null;
    }
}

