/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.impl.SafeRedirectedRequest;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class CreateRedirectUtil {
    public static final int SC_PERMANENT_REDIRECT = 308;
    public static final List<String> SECURITY_RELATED_HEADERS = Arrays.asList("X-Authorization", "Authorization", "Cookie", "Set-Cookie", "WWW-Authenticate", "Proxy-Authorization", "Proxy-Authenticate");

    public static HttpUriRequest getRedirect(DefaultRedirectStrategy defaultRedirectStrategy, HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        boolean bl;
        URI uRI = defaultRedirectStrategy.getLocationURI(httpRequest, httpResponse, httpContext);
        String string = httpRequest.getRequestLine().getMethod();
        HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)httpContext);
        HttpHost httpHost = httpClientContext.getTargetHost();
        boolean bl2 = bl = httpHost.getHostName().equals(uRI.getHost()) && httpHost.getPort() == uRI.getPort() && httpHost.getSchemeName().equals(uRI.getScheme());
        if (string.equalsIgnoreCase("HEAD")) {
            return bl ? new HttpHead(uRI) : SafeRedirectedRequest.wrap((HttpUriRequest)new HttpHead(uRI));
        }
        if (string.equalsIgnoreCase("GET")) {
            return bl ? new HttpGet(uRI) : SafeRedirectedRequest.wrap((HttpUriRequest)new HttpGet(uRI));
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n == 307 || n == 308) {
            if (!bl) {
                RequestBuilder requestBuilder = RequestBuilder.copy((HttpRequest)httpRequest).setUri(uRI);
                for (String string2 : SECURITY_RELATED_HEADERS) {
                    requestBuilder.removeHeaders(string2);
                }
                return SafeRedirectedRequest.wrap(requestBuilder.build());
            }
            return RequestBuilder.copy((HttpRequest)httpRequest).setUri(uRI).build();
        }
        return bl ? new HttpGet(uRI) : SafeRedirectedRequest.wrap((HttpUriRequest)new HttpGet(uRI));
    }
}

