/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.impl.CreateRedirectUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class SafeRedirectedRequest
extends HttpGet
implements HttpUriRequest,
InvocationHandler {
    private final HttpUriRequest delegate;

    public SafeRedirectedRequest(HttpUriRequest httpUriRequest) {
        this.delegate = httpUriRequest;
    }

    public static HttpUriRequest wrap(HttpUriRequest httpUriRequest) {
        return (HttpUriRequest)Proxy.newProxyInstance(HttpUriRequest.class.getClassLoader(), new Class[]{HttpUriRequest.class}, (InvocationHandler)new SafeRedirectedRequest(httpUriRequest));
    }

    public void setHeaders(Header[] headerArray) {
        Header[] headerArray2 = (Header[])Arrays.stream(headerArray).filter(header -> CreateRedirectUtil.SECURITY_RELATED_HEADERS.stream().noneMatch(string -> string.equalsIgnoreCase(header.getName()))).toArray(Header[]::new);
        this.delegate.setHeaders(headerArray2);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Method method2 = this.findMethod(this.getClass(), method);
        if (method2 != null) {
            return method2.invoke((Object)this, objectArray);
        }
        return method.invoke((Object)this.delegate, objectArray);
    }

    private Method findMethod(Class<?> clazz, Method method) throws Throwable {
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

