/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.ssl_utils;

import com.puppetlabs.ssl_utils.ExtensionsUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v2CRLBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.joda.time.DateTime;

public class SSLUtils {
    public static final int DEFAULT_KEY_LENGTH = 4096;

    public static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        return SSLUtils.generateKeyPair(4096);
    }

    public static KeyPair generateKeyPair(int n) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n);
        return keyPairGenerator.generateKeyPair();
    }

    public static String getCommonNameFromX500Name(String string) {
        return new X500Name(string).getRDNs(BCStyle.CN)[0].getFirst().getValue().toString();
    }

    public static PKCS10CertificationRequest generateCertificateRequest(KeyPair keyPair, String string, List<Map<String, Object>> list) throws IOException, OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder jcaPKCS10CertificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(string), keyPair.getPublic());
        if (list != null && list.size() > 0) {
            Extensions extensions = ExtensionsUtils.getExtensionsObjFromMap(list);
            jcaPKCS10CertificationRequestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensions);
        }
        return jcaPKCS10CertificationRequestBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").build(keyPair.getPrivate()));
    }

    public static X509Certificate signCertificate(String string, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2, String string2, PublicKey publicKey, List<Map<String, Object>> list) throws IOException, OperatorCreationException, CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(bigInteger);
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string2));
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string));
        x509V3CertificateGenerator.setNotBefore(date);
        x509V3CertificateGenerator.setNotAfter(date2);
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("SHA256WithRSA");
        Extensions extensions = ExtensionsUtils.getExtensionsObjFromMap(list);
        if (extensions != null) {
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getNonCriticalExtensionOIDs()) {
                x509V3CertificateGenerator.addExtension(aSN1ObjectIdentifier.getId(), false, extensions.getExtension(aSN1ObjectIdentifier).getExtnValue().getOctets());
            }
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
                x509V3CertificateGenerator.addExtension(aSN1ObjectIdentifier.getId(), true, extensions.getExtension(aSN1ObjectIdentifier).getExtnValue().getOctets());
            }
        }
        return x509V3CertificateGenerator.generate(privateKey);
    }

    public static X509CRL generateCRL(X500Principal x500Principal, PrivateKey privateKey, PublicKey publicKey) throws CRLException, IOException, OperatorCreationException, InvalidKeyException {
        DateTime dateTime = DateTime.now();
        Date date = dateTime.toDate();
        Date date2 = dateTime.plusYears(5).toDate();
        JcaX509v2CRLBuilder jcaX509v2CRLBuilder = new JcaX509v2CRLBuilder(x500Principal, date);
        jcaX509v2CRLBuilder.setNextUpdate(date2);
        jcaX509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(publicKey));
        jcaX509v2CRLBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(BigInteger.ZERO));
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withRSA").build(privateKey);
        return new JcaX509CRLConverter().getCRL(jcaX509v2CRLBuilder.build(contentSigner));
    }

    public static boolean isRevoked(X509CRL x509CRL, X509Certificate x509Certificate) {
        return x509CRL.isRevoked(x509Certificate);
    }

    public static X509CRL revoke(X509CRL x509CRL, PrivateKey privateKey, PublicKey publicKey, BigInteger bigInteger) throws CRLException, IOException, CertIOException, OperatorCreationException, InvalidKeyException {
        DateTime dateTime = DateTime.now();
        Date date = dateTime.minusSeconds(1).toDate();
        Date date2 = dateTime.plusYears(5).toDate();
        JcaX509v2CRLBuilder jcaX509v2CRLBuilder = new JcaX509v2CRLBuilder(x509CRL.getIssuerX500Principal(), date);
        jcaX509v2CRLBuilder.setNextUpdate(date2);
        jcaX509v2CRLBuilder.addCRL((X509CRLHolder)new JcaX509CRLHolder(x509CRL));
        jcaX509v2CRLBuilder.addCRLEntry(bigInteger, dateTime.toDate(), 1);
        BigInteger bigInteger2 = (BigInteger)ExtensionsUtils.getExtensionValue(x509CRL, ExtensionsUtils.CRL_NUMBER_OID);
        bigInteger2 = bigInteger2 == null ? BigInteger.ZERO : bigInteger2;
        jcaX509v2CRLBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(bigInteger2.add(BigInteger.ONE)));
        jcaX509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(publicKey));
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withRSA").build(privateKey);
        return new JcaX509CRLConverter().getCRL(jcaX509v2CRLBuilder.build(contentSigner));
    }

    public static X509CRL pemToCRL(Reader reader) throws IOException, CRLException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        return jcaX509CRLConverter.getCRL((X509CRLHolder)list.get(0));
    }

    public static List<X509CRL> pemToCRLs(Reader reader) throws IOException, CRLException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>(list.size());
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        for (Object object : list) {
            arrayList.add(jcaX509CRLConverter.getCRL((X509CRLHolder)object));
        }
        return arrayList;
    }

    public static PKCS10CertificationRequest pemToCertificateRequest(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        return (PKCS10CertificationRequest)list.get(0);
    }

    public static KeyStore createKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        return keyStore;
    }

    public static List<Object> pemToObjects(Reader reader) throws IOException {
        PEMParser pEMParser = new PEMParser(reader);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = pEMParser.readObject();
        while (object != null) {
            arrayList.add(object);
            object = pEMParser.readObject();
        }
        return arrayList;
    }

    public static void writeToPEM(Object object, Writer writer) throws IOException {
        PEMWriter pEMWriter = new PEMWriter(writer);
        pEMWriter.writeObject(object);
        pEMWriter.flush();
    }

    public static List<X509Certificate> pemToCerts(Reader reader) throws CertificateException, IOException {
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (Object object : list) {
            arrayList.add(jcaX509CertificateConverter.getCertificate((X509CertificateHolder)object));
        }
        return arrayList;
    }

    public static X509Certificate pemToCert(Reader reader) throws CertificateException, IOException {
        List<X509Certificate> list = SSLUtils.pemToCerts(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly 1 certificate");
        }
        return list.get(0);
    }

    public static PrivateKey objectToPrivateKey(Object object) throws PEMException {
        if (object instanceof PrivateKeyInfo) {
            return new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)object);
        }
        if (object instanceof PEMKeyPair) {
            return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)object).getPrivate();
        }
        throw new IllegalArgumentException("Expected a KeyPair or PrivateKey, got " + object);
    }

    public static List<PrivateKey> pemToPrivateKeys(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<PrivateKey> arrayList = new ArrayList<PrivateKey>(list.size());
        for (Object object : list) {
            arrayList.add(SSLUtils.objectToPrivateKey(object));
        }
        return arrayList;
    }

    public static PrivateKey pemToPrivateKey(Reader reader) throws IOException {
        List<PrivateKey> list = SSLUtils.pemToPrivateKeys(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one private key");
        }
        return list.get(0);
    }

    public static PublicKey pemToPublicKey(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one public key");
        }
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        return jcaPEMKeyConverter.getPublicKey((SubjectPublicKeyInfo)list.get(0));
    }

    public static KeyStore associateCert(KeyStore keyStore, String string, X509Certificate x509Certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(string, x509Certificate);
        return keyStore;
    }

    public static KeyStore associateCertsFromReader(KeyStore keyStore, String string, Reader reader) throws CertificateException, KeyStoreException, IOException {
        List<X509Certificate> list = SSLUtils.pemToCerts(reader);
        ListIterator<X509Certificate> listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            SSLUtils.associateCert(keyStore, string + "-" + n, listIterator.next());
            ++n;
        }
        return keyStore;
    }

    public static KeyStore associatePrivateKey(KeyStore keyStore, String string, PrivateKey privateKey, String string2, X509Certificate x509Certificate) throws KeyStoreException {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("associatePrivateKey requires a value for a cert");
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(1);
        arrayList.add(x509Certificate);
        SSLUtils.associatePrivateKey(keyStore, string, privateKey, string2, arrayList);
        return keyStore;
    }

    public static KeyStore associatePrivateKey(KeyStore keyStore, String string, PrivateKey privateKey, String string2, List<X509Certificate> list) throws KeyStoreException {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("associatePrivateKey requires at least one cert");
        }
        Certificate[] certificateArray = new X509Certificate[list.size()];
        list.toArray(certificateArray);
        keyStore.setKeyEntry(string, privateKey, string2.toCharArray(), certificateArray);
        return keyStore;
    }

    public static KeyStore associatePrivateKeyFromReader(KeyStore keyStore, String string, Reader reader, String string2, Reader reader2) throws CertificateException, KeyStoreException, IOException {
        PrivateKey privateKey = SSLUtils.pemToPrivateKey(reader);
        List<X509Certificate> list = SSLUtils.pemToCerts(reader2);
        if (list.size() < 1) {
            throw new IllegalArgumentException("The PEM stream contains no certificates");
        }
        return SSLUtils.associatePrivateKey(keyStore, string, privateKey, string2, list);
    }

    public static Map<String, Object> pemsToKeyAndTrustStores(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SSLUtils.createKeyStore();
        SSLUtils.associateCertsFromReader(keyStore, "CA Certificate", reader3);
        KeyStore keyStore2 = SSLUtils.createKeyStore();
        String string = UUID.randomUUID().toString();
        SSLUtils.associatePrivateKeyFromReader(keyStore2, "Private Key", reader2, string, reader);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("truststore", keyStore);
        hashMap.put("keystore", keyStore2);
        hashMap.put("keystore-pw", string);
        return hashMap;
    }

    public static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string.toCharArray());
        return keyManagerFactory;
    }

    private static KeyManagerFactory getKeyManagerFactory(Map<String, Object> map) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = (KeyStore)map.get("keystore");
        String string = (String)map.get("keystore-pw");
        return SSLUtils.getKeyManagerFactory(keyStore, string);
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, Reader reader) throws NoSuchAlgorithmException, KeyStoreException, IOException, CRLException, InvalidAlgorithmParameterException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (reader != null) {
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
            pKIXBuilderParameters.setRevocationEnabled(true);
            List<X509CRL> list = SSLUtils.pemToCRLs(reader);
            pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(list)));
            trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
        } else {
            trustManagerFactory.init(keyStore);
        }
        return trustManagerFactory;
    }

    private static SSLContext managerFactoriesToSSLContext(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public static SSLContext pemsToSSLContext(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        Map<String, Object> map = SSLUtils.pemsToKeyAndTrustStores(reader, reader2, reader3);
        KeyStore keyStore = (KeyStore)map.get("truststore");
        KeyManagerFactory keyManagerFactory = SSLUtils.getKeyManagerFactory(map);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore);
        return SSLUtils.managerFactoriesToSSLContext(keyManagerFactory, trustManagerFactory);
    }

    public static SSLContext pemsToSSLContext(Reader reader, Reader reader2, Reader reader3, Reader reader4) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CRLException, InvalidAlgorithmParameterException {
        Map<String, Object> map = SSLUtils.pemsToKeyAndTrustStores(reader, reader2, reader3);
        KeyStore keyStore = (KeyStore)map.get("truststore");
        KeyManagerFactory keyManagerFactory = SSLUtils.getKeyManagerFactory(map);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore, reader4);
        return SSLUtils.managerFactoriesToSSLContext(keyManagerFactory, trustManagerFactory);
    }

    private static KeyStore caCertPemToTrustStore(Reader reader) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = SSLUtils.createKeyStore();
        return SSLUtils.associateCertsFromReader(keyStore, "CA Certificate", reader);
    }

    public static SSLContext caCertPemToSSLContext(Reader reader) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        KeyStore keyStore = SSLUtils.caCertPemToTrustStore(reader);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore);
        return SSLUtils.managerFactoriesToSSLContext(null, trustManagerFactory);
    }

    public static SSLContext caCertAndCrlPemsToSSLContext(Reader reader, Reader reader2) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, CRLException, InvalidAlgorithmParameterException {
        KeyStore keyStore = SSLUtils.caCertPemToTrustStore(reader);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore, reader2);
        return SSLUtils.managerFactoriesToSSLContext(null, trustManagerFactory);
    }

    public static String getCnFromX500Principal(X500Principal x500Principal) {
        return SSLUtils.getCommonNameFromX500Name(x500Principal.getName());
    }

    public static PublicKey getPublicKey(PKCS10CertificationRequest pKCS10CertificationRequest) throws IOException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        return jcaPEMKeyConverter.getPublicKey(pKCS10CertificationRequest.getSubjectPublicKeyInfo());
    }

    public static PublicKey getPublicKey(KeyPair keyPair) {
        return keyPair.getPublic();
    }

    public static PrivateKey getPrivateKey(KeyPair keyPair) {
        return keyPair.getPrivate();
    }

    public static BigInteger getSerialNumber(X509Certificate x509Certificate) {
        return x509Certificate.getSerialNumber();
    }

    public static String x500Name(List<String> list) {
        if (list.size() % 2 != 0) {
            throw new IllegalArgumentException("The RDN pairs list must contain an even number of elements.");
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            String string2 = list.get(++i);
            x500NameBuilder.addRDN(BCStyle.INSTANCE.attrNameToOID(string), string2);
        }
        return x500NameBuilder.build().toString();
    }

    public static String x500NameCn(String string) {
        return new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, string).build().toString();
    }

    public static boolean isSignatureValid(PKCS10CertificationRequest pKCS10CertificationRequest) throws OperatorCreationException, PKCSException {
        JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder().setProvider((Provider)new BouncyCastleProvider());
        return pKCS10CertificationRequest.isSignatureValid(jcaContentVerifierProviderBuilder.build(pKCS10CertificationRequest.getSubjectPublicKeyInfo()));
    }

    public static String getFingerprint(X509Certificate x509Certificate, String string) throws CertificateEncodingException {
        return SSLUtils.getFingerprint(x509Certificate.getEncoded(), string);
    }

    public static String getFingerprint(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        return SSLUtils.getFingerprint(pKCS10CertificationRequest.getEncoded(), string);
    }

    private static String getFingerprint(byte[] byArray, String string) {
        MessageDigest messageDigest = DigestUtils.getDigest((String)string);
        return Hex.encodeHexString((byte[])messageDigest.digest(byArray));
    }
}

