/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.ssl_utils;

import com.puppetlabs.ssl_utils.ExtensionsUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v2CRLBuilder;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.joda.time.DateTime;

public class SSLUtils {
    public static final int DEFAULT_KEY_LENGTH = 4096;
    public static final String FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    public static final String NON_FIPS_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String BOUNCYCASTLE_FIPS_KEYSTORE = "BCFKS";
    public static final String JAVA_KEYSTORE = "JKS";
    public static final String PKIX_KEYMANAGER_ALGO = "PKIX";
    public static final String BOUNCYCASTLE_FIPS_PROVIDER = "BCFIPS";
    public static final String BOUNCYCASTLE_JSSE_PROVIDER = "BCJSSE";
    public static final String TLS_PROTOCOL = "TLS";
    private static int crlLifetimeSeconds = 157680000;

    public static boolean isFIPS() {
        try {
            return SSLUtils.getProviderClass().getCanonicalName().equals(FIPS_PROVIDER_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class getProviderClass() throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(FIPS_PROVIDER_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(NON_FIPS_PROVIDER_CLASS);
        }
        return clazz;
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return SSLUtils.generateKeyPair(4096);
    }

    public static KeyPair generateKeyPair(int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n);
        return keyPairGenerator.generateKeyPair();
    }

    public static String getCommonNameFromX500Name(String string) {
        AttributeTypeAndValue attributeTypeAndValue;
        RDN[] rDNArray = new X500Name(BCStyle.INSTANCE, string).getRDNs(BCStyle.CN);
        String string2 = "";
        if (rDNArray.length > 0 && (attributeTypeAndValue = rDNArray[0].getFirst()) != null) {
            string2 = attributeTypeAndValue.getValue().toString();
        }
        return string2;
    }

    public static PKCS10CertificationRequest generateCertificateRequest(KeyPair keyPair, String string, List<Map<String, Object>> list, List<Map<String, Object>> list2) throws IOException, OperatorCreationException, CertificateEncodingException {
        Object object;
        JcaPKCS10CertificationRequestBuilder jcaPKCS10CertificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(BCStyle.INSTANCE, string), keyPair.getPublic());
        if (list != null && list.size() > 0) {
            object = ExtensionsUtils.getExtensionsObjFromMap(list);
            jcaPKCS10CertificationRequestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)object);
        }
        if (list2 != null && list2.size() > 0) {
            ASN1Encodable[] aSN1EncodableArray;
            Object object2;
            String string2;
            object = new HashMap();
            for (Map<String, Object> object3 : list2) {
                string2 = (String)object3.get("oid");
                object2 = object3.get("value").toString();
                aSN1EncodableArray = new DEROctetString((ASN1Encodable)new DERUTF8String((String)object2));
                if (((HashMap)object).containsKey(string2)) {
                    ((ArrayList)((HashMap)object).get(string2)).add(aSN1EncodableArray);
                    continue;
                }
                ArrayList<ASN1Encodable[]> arrayList = new ArrayList<ASN1Encodable[]>();
                arrayList.add(aSN1EncodableArray);
                ((HashMap)object).put(string2, arrayList);
            }
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                string2 = new ASN1ObjectIdentifier((String)entry.getKey());
                object2 = (ArrayList)entry.getValue();
                aSN1EncodableArray = new ASN1Encodable[((ArrayList)entry.getValue()).size()];
                ((ArrayList)object2).toArray(aSN1EncodableArray);
                jcaPKCS10CertificationRequestBuilder.addAttribute((ASN1ObjectIdentifier)string2, aSN1EncodableArray);
            }
        }
        return jcaPKCS10CertificationRequestBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").build(keyPair.getPrivate()));
    }

    public static X509Certificate signCertificate(String string, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2, String string2, PublicKey publicKey, List<Map<String, Object>> list) throws IOException, OperatorCreationException, CertificateException {
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(new X500Name(BCStyle.INSTANCE, string), bigInteger, date, date2, new X500Name(BCStyle.INSTANCE, string2), SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
        Extensions extensions = ExtensionsUtils.getExtensionsObjFromMap(list);
        if (extensions != null) {
            for (AlgorithmIdentifier algorithmIdentifier2 : extensions.getNonCriticalExtensionOIDs()) {
                x509v3CertificateBuilder.addExtension((ASN1ObjectIdentifier)algorithmIdentifier2, false, extensions.getExtension((ASN1ObjectIdentifier)algorithmIdentifier2).getParsedValue());
            }
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
                x509v3CertificateBuilder.addExtension(aSN1ObjectIdentifier, true, extensions.getExtension(aSN1ObjectIdentifier).getParsedValue());
            }
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier algorithmIdentifier3 = new DefaultDigestAlgorithmIdentifierFinder().find((AlgorithmIdentifier)aSN1ObjectIdentifierArray);
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
        ContentSigner contentSigner = jcaContentSignerBuilder.build(privateKey);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        return jcaX509CertificateConverter.getCertificate(x509v3CertificateBuilder.build(contentSigner));
    }

    public static X509CRL generateCRL(X500Principal x500Principal, PrivateKey privateKey, PublicKey publicKey, Date date, Date date2, BigInteger bigInteger, List<Map<String, Object>> list) throws CRLException, IOException, OperatorCreationException, NoSuchAlgorithmException, CertificateEncodingException {
        JcaX509v2CRLBuilder jcaX509v2CRLBuilder = new JcaX509v2CRLBuilder(x500Principal, date);
        jcaX509v2CRLBuilder.setNextUpdate(date2);
        jcaX509v2CRLBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(bigInteger));
        Extensions extensions = ExtensionsUtils.getExtensionsObjFromMap(list);
        if (extensions != null) {
            for (ContentSigner contentSigner : extensions.getNonCriticalExtensionOIDs()) {
                jcaX509v2CRLBuilder.addExtension((ASN1ObjectIdentifier)contentSigner, false, extensions.getExtension((ASN1ObjectIdentifier)contentSigner).getParsedValue());
            }
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
                jcaX509v2CRLBuilder.addExtension(aSN1ObjectIdentifier, true, extensions.getExtension(aSN1ObjectIdentifier).getParsedValue());
            }
        }
        if (!jcaX509v2CRLBuilder.hasExtension(Extension.authorityKeyIdentifier)) {
            jcaX509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(publicKey));
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new JcaContentSignerBuilder("SHA256withRSA").build(privateKey);
        return new JcaX509CRLConverter().getCRL(jcaX509v2CRLBuilder.build((ContentSigner)aSN1ObjectIdentifierArray));
    }

    public static X509CRL generateCRL(X500Principal x500Principal, PrivateKey privateKey, PublicKey publicKey) throws CRLException, IOException, OperatorCreationException, NoSuchAlgorithmException, CertificateEncodingException {
        DateTime dateTime = DateTime.now();
        Date date = dateTime.toDate();
        Date date2 = dateTime.plusSeconds(crlLifetimeSeconds).toDate();
        return SSLUtils.generateCRL(x500Principal, privateKey, publicKey, date, date2, BigInteger.ZERO, null);
    }

    public static boolean isRevoked(X509CRL x509CRL, X509Certificate x509Certificate) {
        return x509CRL.isRevoked(x509Certificate);
    }

    private static X509v2CRLBuilder crlBuilder(X509CRL x509CRL) throws CRLException {
        DateTime dateTime = DateTime.now();
        Date date = dateTime.minusSeconds(1).toDate();
        Date date2 = dateTime.plusYears(5).toDate();
        JcaX509v2CRLBuilder jcaX509v2CRLBuilder = new JcaX509v2CRLBuilder(x509CRL.getIssuerX500Principal(), date);
        jcaX509v2CRLBuilder.setNextUpdate(date2);
        jcaX509v2CRLBuilder.addCRL((X509CRLHolder)new JcaX509CRLHolder(x509CRL));
        return jcaX509v2CRLBuilder;
    }

    private static X509CRL buildCRL(X509CRL x509CRL, PrivateKey privateKey, PublicKey publicKey, X509v2CRLBuilder x509v2CRLBuilder) throws IOException, CRLException, NoSuchAlgorithmException, OperatorCreationException {
        BigInteger bigInteger = (BigInteger)ExtensionsUtils.getExtensionValue(x509CRL, ExtensionsUtils.CRL_NUMBER_OID);
        bigInteger = bigInteger == null ? BigInteger.ZERO : bigInteger;
        x509v2CRLBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(bigInteger.add(BigInteger.ONE)));
        JcaX509CRLHolder jcaX509CRLHolder = new JcaX509CRLHolder(x509CRL);
        Extension extension = jcaX509CRLHolder.getExtension(Extension.authorityKeyIdentifier);
        if (extension == null) {
            x509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(publicKey));
        } else {
            x509v2CRLBuilder.addExtension(Extension.authorityKeyIdentifier, false, extension.getParsedValue());
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withRSA").build(privateKey);
        return new JcaX509CRLConverter().getCRL(x509v2CRLBuilder.build(contentSigner));
    }

    public static X509CRL revoke(X509CRL x509CRL, PrivateKey privateKey, PublicKey publicKey, BigInteger bigInteger) throws CRLException, IOException, NoSuchAlgorithmException, OperatorCreationException {
        X509v2CRLBuilder x509v2CRLBuilder = SSLUtils.crlBuilder(x509CRL);
        x509v2CRLBuilder.addCRLEntry(bigInteger, DateTime.now().toDate(), 1);
        return SSLUtils.buildCRL(x509CRL, privateKey, publicKey, x509v2CRLBuilder);
    }

    public static X509CRL revokeMultiple(X509CRL x509CRL, PrivateKey privateKey, PublicKey publicKey, List<BigInteger> list) throws CRLException, IOException, NoSuchAlgorithmException, OperatorCreationException {
        X509v2CRLBuilder x509v2CRLBuilder = SSLUtils.crlBuilder(x509CRL);
        for (BigInteger bigInteger : list) {
            x509v2CRLBuilder.addCRLEntry(bigInteger, DateTime.now().toDate(), 1);
        }
        return SSLUtils.buildCRL(x509CRL, privateKey, publicKey, x509v2CRLBuilder);
    }

    public static void validateCertChain(List<X509Certificate> list, List<X509CRL> list2) throws CertificateException, CertPathValidatorException, IOException, InvalidAlgorithmParameterException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        CertStore certStore;
        CertPathValidator certPathValidator;
        CertificateFactory certificateFactory;
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(list2);
        if (SSLUtils.isFIPS()) {
            certificateFactory = CertificateFactory.getInstance("X.509", BOUNCYCASTLE_FIPS_PROVIDER);
            certPathValidator = CertPathValidator.getInstance(PKIX_KEYMANAGER_ALGO, BOUNCYCASTLE_FIPS_PROVIDER);
            certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, BOUNCYCASTLE_FIPS_PROVIDER);
        } else {
            certificateFactory = CertificateFactory.getInstance("X.509");
            certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
        }
        CertPath certPath = certificateFactory.generateCertPath(list);
        KeyStore keyStore = SSLUtils.certsToTrustStore(list);
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
        pKIXBuilderParameters.addCertStore(certStore);
        certPathValidator.validate(certPath, pKIXBuilderParameters);
    }

    public static X509CRL pemToCRL(Reader reader) throws IOException, CRLException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        return jcaX509CRLConverter.getCRL((X509CRLHolder)list.get(0));
    }

    public static List<X509CRL> pemToCRLs(Reader reader) throws IOException, CRLException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>(list.size());
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        for (Object object : list) {
            arrayList.add(jcaX509CRLConverter.getCRL((X509CRLHolder)object));
        }
        return arrayList;
    }

    public static PKCS10CertificationRequest pemToCertificateRequest(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        return (PKCS10CertificationRequest)list.get(0);
    }

    public static KeyStore createKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String string = SSLUtils.isFIPS() ? BOUNCYCASTLE_FIPS_KEYSTORE : JAVA_KEYSTORE;
        KeyStore keyStore = KeyStore.getInstance(string);
        keyStore.load(null, null);
        return keyStore;
    }

    public static List<Object> pemToObjects(Reader reader) throws IOException {
        PEMParser pEMParser = new PEMParser(reader);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = pEMParser.readObject();
        while (object != null) {
            arrayList.add(object);
            object = pEMParser.readObject();
        }
        return arrayList;
    }

    public static void writeToPEM(Object object, Writer writer) throws IOException {
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter(writer);
        jcaPEMWriter.writeObject(object);
        jcaPEMWriter.flush();
    }

    public static List<X509Certificate> pemToCerts(Reader reader) throws CertificateException, IOException {
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (Object object : list) {
            arrayList.add(jcaX509CertificateConverter.getCertificate((X509CertificateHolder)object));
        }
        return arrayList;
    }

    public static boolean certMatchesPubKey(X509Certificate x509Certificate, PublicKey publicKey) {
        PublicKey publicKey2 = x509Certificate.getPublicKey();
        return publicKey2.getFormat().equals(publicKey.getFormat()) && publicKey2.getAlgorithm().equals(publicKey.getAlgorithm()) && Arrays.equals(publicKey2.getEncoded(), publicKey.getEncoded());
    }

    public static X509Certificate pemToCaCert(Reader reader, Reader reader2) throws CertificateException, IOException {
        List<X509Certificate> list = SSLUtils.pemToCerts(reader);
        if (list.size() < 1) {
            throw new IllegalArgumentException("The certificate PEM stream must contain at least 1 certificate");
        }
        PublicKey publicKey = SSLUtils.pemToPublicKey(reader2);
        Optional<X509Certificate> optional = list.stream().filter(x509Certificate -> SSLUtils.certMatchesPubKey(x509Certificate, publicKey)).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("The certificate chain does not contain a certificate that matches the expected public key"));
    }

    public static X509Certificate pemToCert(Reader reader) throws CertificateException, IOException {
        List<X509Certificate> list = SSLUtils.pemToCerts(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly 1 certificate");
        }
        return list.get(0);
    }

    public static PrivateKey objectToPrivateKey(Object object) throws PEMException {
        if (object instanceof PrivateKeyInfo) {
            return new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)object);
        }
        if (object instanceof PEMKeyPair) {
            return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)object).getPrivate();
        }
        throw new IllegalArgumentException("Expected a KeyPair or PrivateKey, got " + object);
    }

    public static List<PrivateKey> pemToPrivateKeys(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<PrivateKey> arrayList = new ArrayList<PrivateKey>(list.size());
        for (Object object : list) {
            if (object instanceof ASN1ObjectIdentifier) continue;
            arrayList.add(SSLUtils.objectToPrivateKey(object));
        }
        return arrayList;
    }

    public static PrivateKey pemToPrivateKey(Reader reader) throws IOException {
        List<PrivateKey> list = SSLUtils.pemToPrivateKeys(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one private key");
        }
        return list.get(0);
    }

    public static PublicKey pemToPublicKey(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one object");
        }
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        Object object = list.get(0);
        if (object instanceof SubjectPublicKeyInfo) {
            return jcaPEMKeyConverter.getPublicKey((SubjectPublicKeyInfo)object);
        }
        if (object instanceof PEMKeyPair) {
            return jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object).getPublic();
        }
        if (object instanceof PrivateKeyInfo) {
            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            RSAPublicKey rSAPublicKey = new RSAPublicKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent());
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, (ASN1Encodable)rSAPublicKey);
            return jcaPEMKeyConverter.getPublicKey(subjectPublicKeyInfo);
        }
        throw new IllegalArgumentException("Could not recognize object in PEM stream");
    }

    public static List<KeyPair> pemToKeyPairs(Reader reader) throws IOException {
        List<Object> list = SSLUtils.pemToObjects(reader);
        ArrayList<KeyPair> arrayList = new ArrayList<KeyPair>(list.size());
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        for (Object object : list) {
            if (object instanceof PEMKeyPair) {
                arrayList.add(jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object));
                continue;
            }
            throw new IllegalArgumentException("Expected a KeyPair, got " + object);
        }
        return arrayList;
    }

    public static KeyPair pemToKeyPair(Reader reader) throws IOException {
        List<KeyPair> list = SSLUtils.pemToKeyPairs(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one key pair");
        }
        return list.get(0);
    }

    public static KeyStore associateCert(KeyStore keyStore, String string, X509Certificate x509Certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(string, x509Certificate);
        return keyStore;
    }

    public static KeyStore associateCertsFromList(KeyStore keyStore, String string, List<X509Certificate> list) throws KeyStoreException {
        ListIterator<X509Certificate> listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            SSLUtils.associateCert(keyStore, string + "-" + n, listIterator.next());
            ++n;
        }
        return keyStore;
    }

    public static KeyStore associateCertsFromReader(KeyStore keyStore, String string, Reader reader) throws CertificateException, KeyStoreException, IOException {
        List<X509Certificate> list = SSLUtils.pemToCerts(reader);
        return SSLUtils.associateCertsFromList(keyStore, string, list);
    }

    public static KeyStore associatePrivateKey(KeyStore keyStore, String string, PrivateKey privateKey, String string2, X509Certificate x509Certificate) throws KeyStoreException {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("associatePrivateKey requires a value for a cert");
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(1);
        arrayList.add(x509Certificate);
        SSLUtils.associatePrivateKey(keyStore, string, privateKey, string2, arrayList);
        return keyStore;
    }

    public static KeyStore associatePrivateKey(KeyStore keyStore, String string, PrivateKey privateKey, String string2, List<X509Certificate> list) throws KeyStoreException {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("associatePrivateKey requires at least one cert");
        }
        Certificate[] certificateArray = new X509Certificate[list.size()];
        list.toArray(certificateArray);
        keyStore.setKeyEntry(string, privateKey, string2.toCharArray(), certificateArray);
        return keyStore;
    }

    public static KeyStore associatePrivateKeyFromReader(KeyStore keyStore, String string, Reader reader, String string2, Reader reader2) throws CertificateException, KeyStoreException, IOException {
        PrivateKey privateKey = SSLUtils.pemToPrivateKey(reader);
        List<X509Certificate> list = SSLUtils.pemToCerts(reader2);
        if (list.size() < 1) {
            throw new IllegalArgumentException("The PEM stream contains no certificates");
        }
        return SSLUtils.associatePrivateKey(keyStore, string, privateKey, string2, list);
    }

    public static Map<String, Object> pemsToKeyAndTrustStores(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SSLUtils.createKeyStore();
        SSLUtils.associateCertsFromReader(keyStore, "CA Certificate", reader3);
        KeyStore keyStore2 = SSLUtils.createKeyStore();
        String string = UUID.randomUUID().toString();
        SSLUtils.associatePrivateKeyFromReader(keyStore2, "Private Key", reader2, string, reader);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("truststore", keyStore);
        hashMap.put("keystore", keyStore2);
        hashMap.put("keystore-pw", string);
        return hashMap;
    }

    public static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, NoSuchProviderException {
        KeyManagerFactory keyManagerFactory = SSLUtils.isFIPS() ? KeyManagerFactory.getInstance(PKIX_KEYMANAGER_ALGO, BOUNCYCASTLE_JSSE_PROVIDER) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string.toCharArray());
        return keyManagerFactory;
    }

    private static KeyManagerFactory getKeyManagerFactory(Map<String, Object> map) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, NoSuchProviderException {
        KeyStore keyStore = (KeyStore)map.get("keystore");
        String string = (String)map.get("keystore-pw");
        return SSLUtils.getKeyManagerFactory(keyStore, string);
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException {
        TrustManagerFactory trustManagerFactory = SSLUtils.isFIPS() ? TrustManagerFactory.getInstance(PKIX_KEYMANAGER_ALGO, BOUNCYCASTLE_JSSE_PROVIDER) : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, Reader reader) throws NoSuchAlgorithmException, KeyStoreException, IOException, CRLException, InvalidAlgorithmParameterException, NoSuchProviderException {
        TrustManagerFactory trustManagerFactory = SSLUtils.isFIPS() ? TrustManagerFactory.getInstance(PKIX_KEYMANAGER_ALGO, BOUNCYCASTLE_JSSE_PROVIDER) : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (reader != null) {
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
            pKIXBuilderParameters.setRevocationEnabled(true);
            List<X509CRL> list = SSLUtils.pemToCRLs(reader);
            pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(list)));
            trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
        } else {
            trustManagerFactory.init(keyStore);
        }
        return trustManagerFactory;
    }

    public static SSLContext managerFactoriesToSSLContext(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException {
        SSLContext sSLContext = SSLUtils.isFIPS() ? SSLContext.getInstance(TLS_PROTOCOL, BOUNCYCASTLE_JSSE_PROVIDER) : SSLContext.getInstance(TLS_PROTOCOL);
        sSLContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public static SSLContext pemsToSSLContext(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, NoSuchProviderException {
        Map<String, Object> map = SSLUtils.pemsToKeyAndTrustStores(reader, reader2, reader3);
        KeyStore keyStore = (KeyStore)map.get("truststore");
        KeyManagerFactory keyManagerFactory = SSLUtils.getKeyManagerFactory(map);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore);
        return SSLUtils.managerFactoriesToSSLContext(keyManagerFactory, trustManagerFactory);
    }

    public static SSLContext pemsToSSLContext(Reader reader, Reader reader2, Reader reader3, Reader reader4) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CRLException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Map<String, Object> map = SSLUtils.pemsToKeyAndTrustStores(reader, reader2, reader3);
        KeyStore keyStore = (KeyStore)map.get("truststore");
        KeyManagerFactory keyManagerFactory = SSLUtils.getKeyManagerFactory(map);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore, reader4);
        return SSLUtils.managerFactoriesToSSLContext(keyManagerFactory, trustManagerFactory);
    }

    private static KeyStore certsToTrustStore(List<X509Certificate> list) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore keyStore = SSLUtils.createKeyStore();
        return SSLUtils.associateCertsFromList(keyStore, "CA Certificate", list);
    }

    private static KeyStore caCertPemToTrustStore(Reader reader) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = SSLUtils.createKeyStore();
        return SSLUtils.associateCertsFromReader(keyStore, "CA Certificate", reader);
    }

    public static SSLContext caCertPemToSSLContext(Reader reader) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, NoSuchProviderException {
        KeyStore keyStore = SSLUtils.caCertPemToTrustStore(reader);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore);
        return SSLUtils.managerFactoriesToSSLContext(null, trustManagerFactory);
    }

    public static SSLContext caCertAndCrlPemsToSSLContext(Reader reader, Reader reader2) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, CRLException, InvalidAlgorithmParameterException, NoSuchProviderException {
        KeyStore keyStore = SSLUtils.caCertPemToTrustStore(reader);
        TrustManagerFactory trustManagerFactory = SSLUtils.getTrustManagerFactory(keyStore, reader2);
        return SSLUtils.managerFactoriesToSSLContext(null, trustManagerFactory);
    }

    public static String getCnFromX500Principal(X500Principal x500Principal) {
        return SSLUtils.getCommonNameFromX500Name(x500Principal.getName());
    }

    public static String getSubjectFromX509Certificate(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getSubjectX500Principal().getEncoded();
        X500Name x500Name = X500Name.getInstance((Object)byArray);
        return BCStyle.INSTANCE.toString(x500Name);
    }

    public static PublicKey getPublicKey(PKCS10CertificationRequest pKCS10CertificationRequest) throws IOException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        return jcaPEMKeyConverter.getPublicKey(pKCS10CertificationRequest.getSubjectPublicKeyInfo());
    }

    public static PublicKey getPublicKey(KeyPair keyPair) {
        return keyPair.getPublic();
    }

    public static PrivateKey getPrivateKey(KeyPair keyPair) {
        return keyPair.getPrivate();
    }

    public static BigInteger getSerialNumber(X509Certificate x509Certificate) {
        return x509Certificate.getSerialNumber();
    }

    public static String x500Name(List<String> list) {
        if (list.size() % 2 != 0) {
            throw new IllegalArgumentException("The RDN pairs list must contain an even number of elements.");
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            String string2 = list.get(++i);
            x500NameBuilder.addRDN(BCStyle.INSTANCE.attrNameToOID(string), string2);
        }
        return x500NameBuilder.build().toString();
    }

    public static String x500NameCn(String string) {
        return new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, string).build().toString();
    }

    public static boolean isSignatureValid(PKCS10CertificationRequest pKCS10CertificationRequest) throws OperatorCreationException, PKCSException {
        JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder;
        Object object;
        try {
            Class clazz = SSLUtils.getProviderClass();
            object = clazz.getConstructor(new Class[0]);
            jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder().setProvider((Provider)((Constructor)object).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new OperatorCreationException("unable to find suitable provider!", (Throwable)reflectiveOperationException);
        }
        try {
            return pKCS10CertificationRequest.isSignatureValid(jcaContentVerifierProviderBuilder.build(pKCS10CertificationRequest.getSubjectPublicKeyInfo()));
        }
        catch (RuntimeOperatorException runtimeOperatorException) {
            object = runtimeOperatorException.getCause();
            if (object != null && object.getClass().isAssignableFrom(SignatureException.class)) {
                return false;
            }
            throw runtimeOperatorException;
        }
    }

    public static String getFingerprint(X509Certificate x509Certificate, String string) throws CertificateEncodingException {
        return SSLUtils.getFingerprint(x509Certificate.getEncoded(), string);
    }

    public static String getFingerprint(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        return SSLUtils.getFingerprint(pKCS10CertificationRequest.getEncoded(), string);
    }

    private static String getFingerprint(byte[] byArray, String string) {
        MessageDigest messageDigest = DigestUtils.getDigest((String)string);
        return Hex.encodeHexString((byte[])messageDigest.digest(byArray));
    }

    public static int getCrlLifetimeSeconds() {
        return crlLifetimeSeconds;
    }

    public static void setCrlLifetimeSeconds(int n) {
        crlLifetimeSeconds = n;
    }
}

