(ns keras.callbacks
  "Callbacks: utilities called at certain points during model training.
"
  (:require [libpython-clj.python
             :refer [import-module
                     get-item
                     get-attr
                     python-type
                     call-attr
                     call-attr-kw]:as py]))

(py/initialize!)
(defonce callbacks (import-module "keras.callbacks"))

(defn standardize-input-data 
  "Normalizes inputs and targets provided by users.

    Users may pass data as a list of arrays, dictionary of arrays,
    or as a single array. We normalize this to an ordered list of
    arrays (same order as `names`), while checking that the provided
    arrays have shapes that match the network's expectations.

    # Arguments
        data: User-provided input data (polymorphic).
        names: List of expected array names.
        shapes: Optional list of expected array shapes.
        check_batch_axis: Boolean; whether to check that
            the batch axis of the arrays matches the expected
            value found in `shapes`.
        exception_prefix: String prefix used for exception formatting.

    # Returns
        List of standardized input arrays (one array per model input).

    # Raises
        ValueError: in case of improperly formatted user-provided data.
    "
  [ & {:keys [data names shapes check_batch_axis exception_prefix]
       :or {check_batch_axis true exception_prefix ""}} ]
  
   (py/call-attr-kw callbacks "standardize_input_data" [] {:data data :names names :shapes shapes :check_batch_axis check_batch_axis :exception_prefix exception_prefix }))
