#!/bin/sh
set -e

PREFIX=${PREFIX:-/opt/{{name}}}
LOGDIR=${LOGDIR:-/var/log/{{name}}}
RUN_AS_USER=www-data

mkdir -p "$LOGDIR"
# touch /var/log/{{name}}/uwsgi.touch
if [ "$RUN_AS_USER" != root ]; then
	chown -R "$RUN_AS_USER":"$RUN_AS_USER" "$LOGDIR"
fi

cd "$PREFIX"
make bootstrap
# make install

# install crontab, systemd service, nginx site file, logrotate config etc

# if you enable logrotate.conf, remember to choose a good rotate interval and
# set how many copies to keep.

# install -m 644 "$PREFIX/conf/logrotate.conf" /etc/logrotate.d/{{name}}
# install -m 644 "$PREFIX/conf/web.upstart" /etc/init/{{name}}.conf
# install -m 644 "$PREFIX/conf/web.service" /etc/systemd/system/{{name}}.service
# service {{name}} start || true

# SITE_FILE=/etc/nginx/conf.d/{{name}}.conf
# if [ -e "$SITE_FILE" ]; then
# 	echo "warning: not overwriting existing nginx site file $SITE_FILE"
# else
# 	install "$PREFIX/conf/http.site" "$SITE_FILE"
# 	service nginx reload
# fi
