#!/usr/bin/env python
# coding=utf-8

"""
python distribute file
"""

from __future__ import (absolute_import, division, print_function,
                        unicode_literals, with_statement)

from setuptools import setup, find_packages
from utils.versionutils import get_version_from_init_file


def requirements_file_to_list(fn="requirements.txt"):
    """read a requirements file and create a list that can be used in setup.

    """
    with open(fn, 'r') as f:
        return [x.rstrip() for x in list(f) if x and not x.startswith('#')]


setup(
    name="{{name}}",
    version=get_version_from_init_file(),
    packages=find_packages(exclude=("utils",)),
    install_requires=requirements_file_to_list(),
    entry_points={
        # 'console_scripts': [
        #     'main = {{python-pkg-name}}.main:main',
        # ]
    },
    package_data={
        '{{python-pkg-name}}': ['logger.conf']
    },
    author="Yuanle Song",
    author_email="sylecn@gmail.com",
    maintainer="Yuanle Song",
    maintainer_email="sylecn@gmail.com",
    description="FIXME add description",
    long_description=open('README.rst').read(),
    long_description_content_type='text/x-rst',
    license="GPLv3+",
    url="https://pypi.org/project/{{name}}/",
    classifiers=[
        'Development Status :: 3 - Alpha',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        # 'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.4',
    ]
)
