(ns casyn.bench
  (:require
   [criterium.core :as cr]
   [casyn.core :as c]
   [lamina.core :as lc]))

(def ks "casyn_bench_ks")
(def cf "bench_cf")
(def ccf "bench_counter_cf")

(def row "1")
(def col-name "col-name")
(def col-value "col-value")

(try
  @(c/add-keyspace (c/make-client)
                   ks
                   "SimpleStrategy"
                   [[cf]
                    [ccf
                     :default-validation-class :counter
                     :replicate-on-write true]]
                   :strategy-options {"replication_factor" "1"})

  (catch Exception e nil)  )


(def cl (c/make-cluster "localhost" 9160 ks
                        :failover :try-all
                        ;; :pool {:max-active 12 :max-idle 12 :max-total 12}
                        ))

(def client-x (c/client-fn cl))


(defn bench-insert-non-blocking
  []

  (client-x c/insert-column cf row col-name col-value))

(defn bench-get-non-blocking
  []

  (client-x c/insert-column cf row col-name col-value))


(defn bench-insert
  []

  @(bench-insert-non-blocking))

(defn bench-get
  []

  @(bench-get-non-blocking))


;; (cr/bench (bench-insert-non-blocking))
;; (cr/bench (bench-get-non-blocking))
(cr/bench (bench-get))
;; (cr/bench (bench-insert))