(ns leiningen.new.qu
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "qu"))

(defn qu
  "FIXME: write documentation"
  [name & args]
  (let [args (set args)
        data {:name name
              :sanitized (name-to-path name)}
        files [["README.md" (render "README.md" data)]
               ["LICENSE" (render "LICENSE" data)]
               ["project.clj" (render "project.clj" data)]
               ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
               [".gitignore" (render ".gitignore")]
               "resources/datasets"]
        templates (when (contains? args "templates")
                    (map (fn [template]
                           (let [filename (str "resources/templates/" template ".mustache")]
                             [filename (render filename)]))
                         ["404" "500" "concept" "dataset" "index" "layout" "pagination" "slice-metadata" "slice"]))
        files (concat files templates)]
    (main/info "Generating fresh 'lein new' qu project.")
    (apply ->files data files)))
