# Qu Leiningen template

This is a template for creating new data APIs using [Qu][]. By creating a new Leiningen project using this template, you can create and customize an instance of a Qu data API.

## Usage

To create a new project, run at your shell:

```sh
lein new qu <project-name>
```

where `<project-name>` is the name of your project.

This will create a new directory for your project, with the same name as `project-name`. Inside this directory, you will see a set of files. If I ran `lein new qu cfpb-data-api`, I would see the following set of files:

```
cfpb-data-api/
├── LICENSE
├── README.md
├── project.clj
├── resources
│   └── datasets
└── src
    └── cfpb_data_api
        └── core.clj
```

`project.clj` is where you declare your dependencies and set up your Leiningen project. `qu` is already included here.

`src/<project-name>/core.clj` is the entry point into your Qu instance and where you set up default configuration. Edit the `qu-config` function in this file to change your default configuration.

## Templates

If you want to edit the default templates Qu uses for rendering HTML views, run the following command:

```sh
lein run -m qu.generate.templates
```

This will add a set of templates under `resources/qu/templates/` that you can edit. You can alternatively specify a directory you want to output the templates into.

## Static files

If you want to edit the static files Qu uses with HTML views, run the following command:

```sh
lein run -m qu.generate.static
```

This will add all the static files under `resources/static/`. You can alternatively specify a directory you want to output the static files into.

[Qu]: https://github.com/cfpb/qu/

## License

As a work of the United States Government, this package is in the public domain within the United States. Additionally, we waive copyright and related rights in the work worldwide through the CC0 1.0 Universal public domain dedication.
