/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.opengl.util;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.util.Gamma;
import com.jogamp.opengl.util.PNGPixelRect;
import java.net.URLConnection;
import java.util.ArrayList;
import jogamp.newt.driver.PNGIcon;

public class NEWTDemoListener
extends WindowAdapter
implements KeyListener,
MouseListener {
    protected final GLWindow glWindow;
    final Display.PointerIcon[] pointerIcons;
    int pointerIconIdx = 0;
    float gamma = 1.0f;
    float brightness = 0.0f;
    float contrast = 1.0f;
    boolean confinedFixedCenter = false;
    private boolean quitAdapterShouldQuit = false;
    private boolean quitAdapterEnabled = false;
    private boolean quitAdapterEnabled2 = true;

    public NEWTDemoListener(GLWindow gLWindow, Display.PointerIcon[] pointerIconArray) {
        this.glWindow = gLWindow;
        this.pointerIcons = pointerIconArray;
    }

    public NEWTDemoListener(GLWindow gLWindow) {
        this(gLWindow, NEWTDemoListener.createPointerIcons(gLWindow.getScreen().getDisplay()));
    }

    protected void printlnState(String string) {
        System.err.println(string + ": " + this.glWindow.getX() + "/" + this.glWindow.getY() + " " + this.glWindow.getSurfaceWidth() + "x" + this.glWindow.getSurfaceHeight() + ", f " + this.glWindow.isFullscreen() + ", a " + this.glWindow.isAlwaysOnTop() + ", " + this.glWindow.getInsets() + ", state " + this.glWindow.getStateMaskString());
    }

    protected void printlnState(String string, String string2) {
        System.err.println(string + ": " + this.glWindow.getX() + "/" + this.glWindow.getY() + " " + this.glWindow.getSurfaceWidth() + "x" + this.glWindow.getSurfaceHeight() + ", f " + this.glWindow.isFullscreen() + ", a " + this.glWindow.isAlwaysOnTop() + ", " + this.glWindow.getInsets() + ", state " + this.glWindow.getStateMaskString() + ", " + string2);
    }

    @Override
    public void keyPressed(final KeyEvent keyEvent) {
        if (keyEvent.isAutoRepeat() || keyEvent.isConsumed()) {
            return;
        }
        short s = keyEvent.getKeySymbol();
        switch (s) {
            case 32: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnCurrentThread(new Runnable(){

                    @Override
                    public void run() {
                        GLAnimatorControl gLAnimatorControl = NEWTDemoListener.this.glWindow.getAnimator();
                        if (null != gLAnimatorControl) {
                            if (gLAnimatorControl.isPaused()) {
                                gLAnimatorControl.resume();
                            } else {
                                gLAnimatorControl.pause();
                            }
                        }
                    }
                });
                break;
            }
            case 65: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set alwaysontop pre]");
                        NEWTDemoListener.this.glWindow.setAlwaysOnTop(!NEWTDemoListener.this.glWindow.isAlwaysOnTop());
                        NEWTDemoListener.this.printlnState("[set alwaysontop post]");
                    }
                });
                break;
            }
            case 66: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set alwaysonbottom pre]");
                        NEWTDemoListener.this.glWindow.setAlwaysOnBottom(!NEWTDemoListener.this.glWindow.isAlwaysOnBottom());
                        NEWTDemoListener.this.printlnState("[set alwaysonbottom post]");
                    }
                });
                break;
            }
            case 67: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        if (null != NEWTDemoListener.this.pointerIcons) {
                            Display.PointerIcon pointerIcon;
                            NEWTDemoListener.this.printlnState("[set pointer-icon pre]");
                            Display.PointerIcon pointerIcon2 = NEWTDemoListener.this.glWindow.getPointerIcon();
                            if (NEWTDemoListener.this.pointerIconIdx >= NEWTDemoListener.this.pointerIcons.length) {
                                pointerIcon = null;
                                NEWTDemoListener.this.pointerIconIdx = 0;
                            } else {
                                pointerIcon = NEWTDemoListener.this.pointerIcons[NEWTDemoListener.this.pointerIconIdx++];
                            }
                            NEWTDemoListener.this.glWindow.setPointerIcon(pointerIcon);
                            NEWTDemoListener.this.printlnState("[set pointer-icon post]", pointerIcon2 + " -> " + NEWTDemoListener.this.glWindow.getPointerIcon());
                        }
                    }
                });
                break;
            }
            case 68: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set undecorated pre]");
                        NEWTDemoListener.this.glWindow.setUndecorated(!NEWTDemoListener.this.glWindow.isUndecorated());
                        NEWTDemoListener.this.printlnState("[set undecorated post]");
                    }
                });
                break;
            }
            case 70: {
                keyEvent.setConsumed(true);
                this.quitAdapterOff();
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set fullscreen pre]");
                        if (NEWTDemoListener.this.glWindow.isFullscreen()) {
                            NEWTDemoListener.this.glWindow.setFullscreen(false);
                        } else if (keyEvent.isAltDown()) {
                            NEWTDemoListener.this.glWindow.setFullscreen(null);
                        } else {
                            NEWTDemoListener.this.glWindow.setFullscreen(true);
                        }
                        NEWTDemoListener.this.printlnState("[set fullscreen post]");
                        NEWTDemoListener.this.quitAdapterOn();
                    }
                });
                break;
            }
            case 71: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        float f = NEWTDemoListener.this.gamma + (keyEvent.isShiftDown() ? -0.1f : 0.1f);
                        System.err.println("[set gamma]: " + NEWTDemoListener.this.gamma + " -> " + f);
                        if (Gamma.setDisplayGamma(NEWTDemoListener.this.glWindow, f, NEWTDemoListener.this.brightness, NEWTDemoListener.this.contrast)) {
                            NEWTDemoListener.this.gamma = f;
                        }
                    }
                });
                break;
            }
            case 73: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set pointer-visible pre]");
                        NEWTDemoListener.this.glWindow.setPointerVisible(!NEWTDemoListener.this.glWindow.isPointerVisible());
                        NEWTDemoListener.this.printlnState("[set pointer-visible post]");
                    }
                });
                break;
            }
            case 74: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set pointer-confined pre]", "warp-center: " + keyEvent.isShiftDown());
                        boolean bl = !NEWTDemoListener.this.glWindow.isPointerConfined();
                        NEWTDemoListener.this.glWindow.confinePointer(bl);
                        NEWTDemoListener.this.printlnState("[set pointer-confined post]", "warp-center: " + keyEvent.isShiftDown());
                        if (keyEvent.isShiftDown()) {
                            NEWTDemoListener.this.setConfinedFixedCenter(bl);
                        } else if (!bl) {
                            NEWTDemoListener.this.setConfinedFixedCenter(false);
                        }
                    }
                });
                break;
            }
            case 77: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        boolean bl;
                        boolean bl2;
                        if (keyEvent.isControlDown()) {
                            bl2 = false;
                            bl = false;
                        } else if (keyEvent.isShiftDown()) {
                            boolean bl3 = NEWTDemoListener.this.glWindow.isMaximizedHorz() && NEWTDemoListener.this.glWindow.isMaximizedVert();
                            bl2 = !bl3;
                            bl = !bl3;
                        } else if (!keyEvent.isAltDown()) {
                            bl2 = NEWTDemoListener.this.glWindow.isMaximizedHorz();
                            bl = !NEWTDemoListener.this.glWindow.isMaximizedVert();
                        } else if (keyEvent.isAltDown()) {
                            bl2 = !NEWTDemoListener.this.glWindow.isMaximizedHorz();
                            bl = NEWTDemoListener.this.glWindow.isMaximizedVert();
                        } else {
                            bl = NEWTDemoListener.this.glWindow.isMaximizedVert();
                            bl2 = NEWTDemoListener.this.glWindow.isMaximizedHorz();
                        }
                        NEWTDemoListener.this.printlnState("[set maximize pre]", "max[vert " + bl + ", horz " + bl2 + "]");
                        NEWTDemoListener.this.glWindow.setMaximized(bl2, bl);
                        NEWTDemoListener.this.printlnState("[set maximize post]", "max[vert " + bl + ", horz " + bl2 + "]");
                    }
                });
                break;
            }
            case 80: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set position pre]");
                        NEWTDemoListener.this.glWindow.setPosition(100, 100);
                        NEWTDemoListener.this.printlnState("[set position post]");
                    }
                });
                break;
            }
            case 81: {
                if (!this.quitAdapterEnabled || 0 != keyEvent.getModifiers()) break;
                System.err.println("QUIT Key " + Thread.currentThread());
                this.quitAdapterShouldQuit = true;
                break;
            }
            case 82: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set resizable pre]");
                        NEWTDemoListener.this.glWindow.setResizable(!NEWTDemoListener.this.glWindow.isResizable());
                        NEWTDemoListener.this.printlnState("[set resizable post]");
                    }
                });
                break;
            }
            case 83: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set sticky pre]");
                        NEWTDemoListener.this.glWindow.setSticky(!NEWTDemoListener.this.glWindow.isSticky());
                        NEWTDemoListener.this.printlnState("[set sticky post]");
                    }
                });
                break;
            }
            case 86: {
                keyEvent.setConsumed(true);
                if (keyEvent.isControlDown()) {
                    this.glWindow.invoke(false, new GLRunnable(){

                        @Override
                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            int n;
                            GL gL = gLAutoDrawable.getGL();
                            int n2 = gL.getSwapInterval();
                            switch (n2) {
                                case 0: {
                                    n = -1;
                                    break;
                                }
                                case -1: {
                                    n = 1;
                                    break;
                                }
                                case 1: {
                                    n = 0;
                                    break;
                                }
                                default: {
                                    n = 1;
                                }
                            }
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            if (gLAutoDrawable instanceof FPSCounter) {
                                ((FPSCounter)((Object)gLAutoDrawable)).resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n2 + " -> " + n + " -> " + gL.getSwapInterval());
                            return true;
                        }
                    });
                    break;
                }
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = NEWTDemoListener.this.glWindow.isVisible();
                        NEWTDemoListener.this.printlnState("[set visible pre]");
                        NEWTDemoListener.this.glWindow.setVisible(!bl);
                        NEWTDemoListener.this.printlnState("[set visible post]");
                        if (bl && !keyEvent.isShiftDown()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            NEWTDemoListener.this.printlnState("[reset visible pre]");
                            NEWTDemoListener.this.glWindow.setVisible(true);
                            NEWTDemoListener.this.printlnState("[reset visible post]");
                        }
                    }
                });
                break;
            }
            case 87: {
                keyEvent.setConsumed(true);
                this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                    @Override
                    public void run() {
                        NEWTDemoListener.this.printlnState("[set pointer-pos pre]");
                        NEWTDemoListener.this.glWindow.warpPointer(NEWTDemoListener.this.glWindow.getSurfaceWidth() / 2, NEWTDemoListener.this.glWindow.getSurfaceHeight() / 2);
                        NEWTDemoListener.this.printlnState("[set pointer-pos post]");
                    }
                });
                break;
            }
            case 88: {
                keyEvent.setConsumed(true);
                float[] fArray = this.glWindow.getCurrentSurfaceScale(new float[2]);
                float[] fArray2 = fArray[0] == 1.0f ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
                System.err.println("[set PixelScale pre]: had " + fArray[0] + "x" + fArray[1] + " -> req " + fArray2[0] + "x" + fArray2[1]);
                this.glWindow.setSurfaceScale(fArray2);
                float[] fArray3 = this.glWindow.getRequestedSurfaceScale(new float[2]);
                float[] fArray4 = this.glWindow.getCurrentSurfaceScale(new float[2]);
                System.err.println("[set PixelScale post]: " + fArray[0] + "x" + fArray[1] + " (had) -> " + fArray2[0] + "x" + fArray2[1] + " (req) -> " + fArray3[0] + "x" + fArray3[1] + " (val) -> " + fArray4[0] + "x" + fArray4[1] + " (has)");
                this.setTitle();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setConfinedFixedCenter(boolean bl) {
        this.confinedFixedCenter = bl;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.isConfined()) {
            this.mouseCenterWarp(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConfined()) {
            this.mouseCenterWarp(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getPointerCount() == 3) {
            this.glWindow.setFullscreen(!this.glWindow.isFullscreen());
            System.err.println("setFullscreen: " + this.glWindow.isFullscreen());
        }
    }

    private void mouseCenterWarp(MouseEvent mouseEvent) {
        if (mouseEvent.isConfined() && this.confinedFixedCenter) {
            int n = this.glWindow.getSurfaceWidth() / 2;
            int n2 = this.glWindow.getSurfaceHeight() / 2;
            this.glWindow.warpPointer(n, n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseEvent mouseEvent) {
    }

    protected void quitAdapterOff() {
        this.quitAdapterEnabled2 = false;
    }

    protected void quitAdapterOn() {
        this.clearQuitAdapter();
        this.quitAdapterEnabled2 = true;
    }

    public void quitAdapterEnable(boolean bl) {
        this.quitAdapterEnabled = bl;
    }

    public void clearQuitAdapter() {
        this.quitAdapterShouldQuit = false;
    }

    public boolean shouldQuit() {
        return this.quitAdapterShouldQuit;
    }

    public void doQuit() {
        this.quitAdapterShouldQuit = true;
    }

    @Override
    public void windowDestroyNotify(WindowEvent windowEvent) {
        if (this.quitAdapterEnabled && this.quitAdapterEnabled2) {
            System.err.println("QUIT Window " + Thread.currentThread());
            this.quitAdapterShouldQuit = true;
        }
    }

    public void setTitle() {
        NEWTDemoListener.setTitle(this.glWindow);
    }

    public static void setTitle(GLWindow gLWindow) {
        CapabilitiesImmutable capabilitiesImmutable = gLWindow.getChosenCapabilities();
        CapabilitiesImmutable capabilitiesImmutable2 = gLWindow.getRequestedCapabilities();
        CapabilitiesImmutable capabilitiesImmutable3 = null != capabilitiesImmutable ? capabilitiesImmutable : capabilitiesImmutable2;
        String string = capabilitiesImmutable3.isBackgroundOpaque() ? "opaque" : "transl";
        float[] fArray = gLWindow.getPixelsPerMM(new float[2]);
        fArray[0] = fArray[0] * 25.4f;
        fArray[1] = fArray[1] * 25.4f;
        float[] fArray2 = gLWindow.getMinimumSurfaceScale(new float[2]);
        float[] fArray3 = gLWindow.getMaximumSurfaceScale(new float[2]);
        float[] fArray4 = gLWindow.getRequestedSurfaceScale(new float[2]);
        float[] fArray5 = gLWindow.getCurrentSurfaceScale(new float[2]);
        gLWindow.setTitle("GLWindow[" + string + "], win: " + gLWindow.getBounds() + ", pix: " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", sDPI " + fArray[0] + " x " + fArray[1] + ", scale[min " + fArray2[0] + "x" + fArray2[1] + ", max " + fArray3[0] + "x" + fArray3[1] + ", req " + fArray4[0] + "x" + fArray4[1] + " -> has " + fArray5[0] + "x" + fArray5[1] + "]");
    }

    public static Display.PointerIcon[] createPointerIcons(Display display) {
        ArrayList<Display.PointerIcon> arrayList = new ArrayList<Display.PointerIcon>();
        display.createNative();
        Display.PointerIcon pointerIcon = null;
        IOUtil.ClassResources classResources = new IOUtil.ClassResources(new String[]{"newt/data/cross-grey-alpha-16x16.png"}, display.getClass().getClassLoader(), null);
        try {
            pointerIcon = display.createPointerIcon(classResources, 8, 8);
            arrayList.add(pointerIcon);
            System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size(), pointerIcon.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"newt/data/pointer-grey-alpha-16x24.png"}, display.getClass().getClassLoader(), null);
        try {
            pointerIcon = display.createPointerIcon(classResources, 0, 0);
            arrayList.add(pointerIcon);
            System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size(), pointerIcon.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"arrow-red-alpha-64x64.png"}, display.getClass().getClassLoader(), null);
        try {
            pointerIcon = display.createPointerIcon(classResources, 0, 0);
            arrayList.add(pointerIcon);
            System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size(), pointerIcon.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        pointerIcon = null;
        classResources = new IOUtil.ClassResources(new String[]{"arrow-blue-alpha-64x64.png"}, display.getClass().getClassLoader(), null);
        try {
            pointerIcon = display.createPointerIcon(classResources, 0, 0);
            arrayList.add(pointerIcon);
            System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size(), pointerIcon.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        if (PNGIcon.isAvailable()) {
            pointerIcon = null;
            classResources = new IOUtil.ClassResources(new String[]{"jogamp-pointer-64x64.png"}, display.getClass().getClassLoader(), null);
            try {
                URLConnection uRLConnection = classResources.resolve(0);
                if (null != uRLConnection) {
                    PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), null, false, 0, false);
                    System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size() + 1, pNGPixelRect.toString());
                    pointerIcon = display.createPointerIcon(pNGPixelRect, 32, 0);
                    arrayList.add(pointerIcon);
                    System.err.printf("Create PointerIcon #%02d: %s%n", arrayList.size(), pointerIcon.toString());
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return arrayList.toArray(new Display.PointerIcon[arrayList.size()]);
    }
}

