/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.JSONObject;
import processing.data.Sort;
import processing.data.StringList;

public class FloatDict {
    protected int count;
    protected String[] keys;
    protected float[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public FloatDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new float[10];
    }

    public FloatDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new float[length];
    }

    public FloatDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new float[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = PApplet.parseFloat(pieces[1]);
                this.indices.put(pieces[0], this.count);
                ++this.count;
            }
            ++i;
        }
    }

    public FloatDict(String[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        int i = 0;
        while (i < this.count) {
            this.indices.put(keys[i], i);
            ++i;
        }
    }

    public FloatDict(Object[][] pairs) {
        this.count = pairs.length;
        this.keys = new String[this.count];
        this.values = new float[this.count];
        int i = 0;
        while (i < this.count) {
            this.keys[i] = (String)pairs[i][0];
            this.values[i] = ((Float)pairs[i][1]).floatValue();
            this.indices.put(this.keys[i], i);
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return FloatDict.this.entryIterator();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        return new Iterator<Entry>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Entry next() {
                Entry e = new Entry(FloatDict.this.keys[this.index], FloatDict.this.values[this.index]);
                ++this.index;
                return e;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return FloatDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return FloatDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        this.crop();
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public float value(int index) {
        return this.values[index];
    }

    public Iterable<Float> values() {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return FloatDict.this.valueIterator();
            }
        };
    }

    public Iterator<Float> valueIterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatDict.this.value(++this.index));
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public float[] valueArray() {
        this.crop();
        return this.valueArray(null);
    }

    public float[] valueArray(float[] array) {
        if (array == null || array.length != this.size()) {
            array = new float[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public float get(String key) {
        int index = this.index(key);
        if (index == -1) {
            throw new IllegalArgumentException("No key named '" + key + "'");
        }
        return this.values[index];
    }

    public float get(String key, float alternate) {
        int index = this.index(key);
        if (index == -1) {
            return alternate;
        }
        return this.values[index];
    }

    public void set(String key, float amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    public void add(String key, float amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + amount;
        }
    }

    public void sub(String key, float amount) {
        this.add(key, -amount);
    }

    public void mult(String key, float amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] * amount;
        }
    }

    public void div(String key, float amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] / amount;
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public int minIndex() {
        if (this.count == 0) {
            return -1;
        }
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.values[i] == this.values[i]) {
                m = this.values[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.values[j];
                    if (d == d && d < m) {
                        m = this.values[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public String minKey() {
        this.checkMinMax("minKey");
        int index = this.minIndex();
        if (index == -1) {
            return null;
        }
        return this.keys[index];
    }

    public float minValue() {
        this.checkMinMax("minValue");
        int index = this.minIndex();
        if (index == -1) {
            return Float.NaN;
        }
        return this.values[index];
    }

    public int maxIndex() {
        if (this.count == 0) {
            return -1;
        }
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.values[i] == this.values[i]) {
                m = this.values[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.values[j];
                    if (!Float.isNaN(d) && d > m) {
                        m = this.values[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public String maxKey() {
        int index = this.maxIndex();
        if (index == -1) {
            return null;
        }
        return this.keys[index];
    }

    public float maxValue() {
        int index = this.maxIndex();
        if (index == -1) {
            return Float.NaN;
        }
        return this.values[index];
    }

    public float sum() {
        double amount = this.sumDouble();
        if (amount > 3.4028234663852886E38) {
            throw new RuntimeException("sum() exceeds 3.4028235E38, use sumDouble()");
        }
        if (amount < -3.4028234663852886E38) {
            throw new RuntimeException("sum() lower than -3.4028235E38, use sumDouble()");
        }
        return (float)amount;
    }

    public double sumDouble() {
        double sum = 0.0;
        int i = 0;
        while (i < this.count) {
            sum += (double)this.values[i];
            ++i;
        }
        return sum;
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, float much) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(what, this.count);
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public int remove(String key) {
        int index = this.index(key);
        if (index != -1) {
            this.removeIndex(index);
        }
        return index;
    }

    public String removeIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String key = this.keys[index];
        this.indices.remove(this.keys[index]);
        int i = index;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0.0f;
        return key;
    }

    public void swap(int a, int b) {
        String tkey = this.keys[a];
        float tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
    }

    public void sortKeys() {
        this.sortImpl(true, false, true);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true, true);
    }

    public void sortValues() {
        this.sortValues(true);
    }

    public void sortValues(boolean stable) {
        this.sortImpl(false, false, stable);
    }

    public void sortValuesReverse() {
        this.sortValuesReverse(true);
    }

    public void sortValuesReverse(boolean stable) {
        this.sortImpl(false, true, stable);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse, final boolean stable) {
        Sort s = new Sort(){

            @Override
            public int size() {
                if (useKeys) {
                    return FloatDict.this.count;
                }
                if (FloatDict.this.count == 0) {
                    return 0;
                }
                int right = FloatDict.this.count - 1;
                while (FloatDict.this.values[right] != FloatDict.this.values[right]) {
                    if (--right != -1) continue;
                    return 0;
                }
                int i = right;
                while (i >= 0) {
                    if (Float.isNaN(FloatDict.this.values[i])) {
                        this.swap(i, right);
                        --right;
                    }
                    --i;
                }
                return right + 1;
            }

            @Override
            public float compare(int a, int b) {
                float diff = 0.0f;
                if (useKeys) {
                    diff = FloatDict.this.keys[a].compareToIgnoreCase(FloatDict.this.keys[b]);
                    if (diff == 0.0f) {
                        diff = FloatDict.this.values[a] - FloatDict.this.values[b];
                    }
                } else {
                    diff = FloatDict.this.values[a] - FloatDict.this.values[b];
                    if (diff == 0.0f && stable) {
                        diff = FloatDict.this.keys[a].compareToIgnoreCase(FloatDict.this.keys[b]);
                    }
                }
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                FloatDict.this.swap(a, b);
            }
        };
        s.run();
        this.indices = new HashMap();
        int i = 0;
        while (i < this.count) {
            this.indices.put(this.keys[i], i);
            ++i;
        }
    }

    public FloatDict getPercent() {
        double sum = this.sum();
        FloatDict outgoing = new FloatDict();
        int i = 0;
        while (i < this.size()) {
            double percent = (double)this.value(i) / sum;
            outgoing.set(this.key(i), (float)percent);
            ++i;
        }
        return outgoing;
    }

    public FloatDict copy() {
        FloatDict outgoing = new FloatDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        int i = 0;
        while (i < this.count) {
            outgoing.indices.put(this.keys[i], i);
            ++i;
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(String.valueOf(this.keys[i]) + " = " + this.values[i]);
            ++i;
        }
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public String toJSON() {
        StringList items = new StringList();
        int i = 0;
        while (i < this.count) {
            items.append(String.valueOf(JSONObject.quote(this.keys[i])) + ": " + this.values[i]);
            ++i;
        }
        return "{ " + items.join(", ") + " }";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " " + this.toJSON();
    }

    public class Entry {
        public String key;
        public float value;

        Entry(String key, float value) {
            this.key = key;
            this.value = value;
        }
    }
}

