(ns ragtime.main
  "Migrate databases via the command line."
  (:require [ragtime.core :as core]))

(defn- load-var [var-name]
  (let [var-sym (symbol var-name)]
    (require (-> var-sym namespace symbol))
    (find-var var-sym)))

(defn -main
  "Migrates a database to the latest version when supplied with a database URL
  and a function that returns a sequence of migrations."
  [database-url migrations-fn]
  (core/migrate-all
   (core/connection database-url)
   ((load-var migrations-fn))))